/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;

public final class PropertyPermission
extends BasicPermission {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    int getMask() {
        return this.mask;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private void init(int n2) {
        if ((n2 & 3) != n2) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = n2;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(PropertyPermission.getMask(this.actions));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)object;
        return this.mask == propertyPermission.mask && this.getName().equals(propertyPermission.getName());
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = PropertyPermission.getActions(this.mask);
        }
        return this.actions;
    }

    static String getActions(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if ((n2 & 1) == 1) {
            bl2 = true;
            stringBuffer.append("read");
        }
        if ((n2 & 2) == 2) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("write");
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = 0;
        if (var0 == null) {
            return var1_1;
        }
        var2_2 = var0.toCharArray();
        var3_3 = var2_2.length - 1;
        if (var3_3 >= 0) ** GOTO lbl32
        return var1_1;
        {
            --var3_3;
            do {
                if (var3_3 != -1 && ((var4_4 = var2_2[var3_3]) == ' ' || var4_4 == '\r' || var4_4 == '\n' || var4_4 == '\f' || var4_4 == '\t')) continue block4;
                if (!(var3_3 < 3 || var2_2[var3_3 - 3] != 'r' && var2_2[var3_3 - 3] != 'R' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 'a' && var2_2[var3_3 - 1] != 'A' || var2_2[var3_3] != 'd' && var2_2[var3_3] != 'D')) {
                    var5_5 = 4;
                    var1_1 |= 1;
                } else if (!(var3_3 < 4 || var2_2[var3_3 - 4] != 'w' && var2_2[var3_3 - 4] != 'W' || var2_2[var3_3 - 3] != 'r' && var2_2[var3_3 - 3] != 'R' || var2_2[var3_3 - 2] != 'i' && var2_2[var3_3 - 2] != 'I' || var2_2[var3_3 - 1] != 't' && var2_2[var3_3 - 1] != 'T' || var2_2[var3_3] != 'e' && var2_2[var3_3] != 'E')) {
                    var5_5 = 5;
                    var1_1 |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var6_6 = false;
                while (var3_3 >= var5_5 && !var6_6) {
                    switch (var2_2[var3_3 - var5_5]) {
                        case ',': {
                            var6_6 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var3_3;
                }
                var3_3 -= var5_5;
lbl32:
                // 2 sources

            } while (var3_3 != -1);
        }
        return var1_1;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        return (this.mask & propertyPermission.mask) == propertyPermission.mask && super.implies(propertyPermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }

    public PropertyPermission(String string, String string2) {
        super(string, string2);
        this.init(PropertyPermission.getMask(string2));
    }
}

