/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    private volatile transient Set keySet = null;
    private volatile transient Set entrySet = null;
    private volatile transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyEnumerator emptyEnumerator = new EmptyEnumerator();
    private static EmptyIterator emptyIterator = new EmptyIterator();

    public synchronized int hashCode() {
        int n2 = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return n2;
        }
        this.loadFactor = -this.loadFactor;
        Entry[] entryArray = this.table;
        int n3 = 0;
        while (n3 < entryArray.length) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                n2 += entry.key.hashCode() ^ entry.value.hashCode();
                entry = entry.next;
            }
            ++n3;
        }
        this.loadFactor = -this.loadFactor;
        return n2;
    }

    public synchronized int size() {
        return this.count;
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n2 = entryArray.length;
        while (--n2 >= 0) {
            entryArray[n2] = null;
        }
        this.count = 0;
    }

    protected void rehash() {
        int n2 = this.table.length;
        Entry[] entryArray = this.table;
        int n3 = n2 * 2 + 1;
        Entry[] entryArray2 = new Entry[n3];
        ++this.modCount;
        this.threshold = (int)((float)n3 * this.loadFactor);
        this.table = entryArray2;
        int n4 = n2;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = (entry2.hash & Integer.MAX_VALUE) % n3;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public Hashtable(int n2) {
        this(n2, 0.75f);
    }

    public Hashtable(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.loadFactor = f2;
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f2);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        int n4 = (int)((float)n3 * this.loadFactor) + n3 / 20 + 3;
        if (n4 > n3 && (n4 & 1) == 0) {
            --n4;
        }
        if (n2 > 0 && n4 > n2) {
            n4 = n2;
        }
        this.table = new Entry[n4];
        this.count = 0;
        while (n3 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n3;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n2 = this.table.length - 1;
        while (n2 >= 0) {
            Entry entry = this.table[n2];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
            --n2;
        }
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.table = new Entry[this.table.length];
            int n2 = this.table.length;
            while (n2-- > 0) {
                Entry entry = hashtable.table[n2] = this.table[n2] != null ? (Entry)this.table[n2].clone() : null;
            }
            hashtable.keySet = null;
            hashtable.entrySet = null;
            hashtable.values = null;
            hashtable.modCount = 0;
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object object2 = entry.getKey();
                Object object3 = entry.getValue();
                if (!(object3 == null ? map.get(object2) != null || !map.containsKey(object2) : !object3.equals(map.get(object2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public synchronized String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.entrySet().iterator();
        stringBuffer.append("{");
        int n3 = 0;
        while (n3 <= n2) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            stringBuffer.append((object == this ? "(this Map)" : object) + "=" + (object2 == this ? "(this Map)" : object2));
            if (n3 < n2) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Collection values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection(this, null), this);
        }
        return this.values;
    }

    public synchronized Enumeration elements() {
        return this.getEnumeration(1);
    }

    public synchronized Enumeration keys() {
        return this.getEnumeration(0);
    }

    private Enumeration getEnumeration(int n2) {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(this, n2, false);
    }

    static int access$200(Hashtable hashtable) {
        return hashtable.count;
    }

    static int access$210(Hashtable hashtable) {
        return hashtable.count--;
    }

    static int access$500(Hashtable hashtable) {
        return hashtable.modCount;
    }

    static int access$508(Hashtable hashtable) {
        return hashtable.modCount++;
    }

    private Iterator getIterator(int n2) {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new Enumerator(this, n2, true);
    }

    public Hashtable(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public synchronized void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet(this, null), this);
        }
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.synchronizedSet(new KeySet(this, null), this);
        }
        return this.keySet;
    }

    public synchronized Object get(Object object) {
        Entry[] entryArray = this.table;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized Object remove(Object object) {
        Entry[] entryArray = this.table;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(object)) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                --this.count;
                Object object2 = entry.value;
                entry.value = null;
                return object2;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    static Entry[] access$400(Hashtable hashtable) {
        return hashtable.table;
    }

    static Iterator access$100(Hashtable hashtable, int n2) {
        return hashtable.getIterator(n2);
    }

    public synchronized Object put(Object object, Object object2) {
        Entry entry;
        if (object2 == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = object.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry2 = entryArray[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && entry2.key.equals(object)) {
                Object object3 = entry2.value;
                entry2.value = object2;
                return object3;
            }
            entry2 = entry2.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n3] = entry = new Entry(n2, object, object2, entryArray[n3]);
        ++this.count;
        return null;
    }

    class 1 {
    }

    private static class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("Hashtable Enumerator");
        }
    }

    private static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public void remove() {
            throw new IllegalStateException("Hashtable Iterator");
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Hashtable Iterator");
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        protected Entry(int n2, Object object, Object object2, Entry entry) {
            this.hash = n2;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private final Hashtable this$0;

        public int size() {
            return Hashtable.access$200(this.this$0);
        }

        public void clear() {
            this.this$0.clear();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = entry.getKey();
            Entry[] entryArray = Hashtable.access$400(this.this$0);
            int n2 = object2.hashCode();
            int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n3];
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.equals(entry)) {
                    return true;
                }
                entry2 = entry2.next;
            }
            return false;
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = entry.getKey();
            Entry[] entryArray = Hashtable.access$400(this.this$0);
            int n2 = object2.hashCode();
            int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n3];
            Entry entry3 = null;
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.equals(entry)) {
                    Hashtable.access$508(this.this$0);
                    if (entry3 != null) {
                        entry3.next = entry2.next;
                    } else {
                        entryArray[n3] = entry2.next;
                    }
                    Hashtable.access$210(this.this$0);
                    entry2.value = null;
                    return true;
                }
                entry3 = entry2;
                entry2 = entry2.next;
            }
            return false;
        }

        private EntrySet(Hashtable hashtable) {
            this.this$0 = hashtable;
        }

        public Iterator iterator() {
            return Hashtable.access$100(this.this$0, 2);
        }

        EntrySet(Hashtable hashtable, 1 var2_2) {
            this(hashtable);
        }
    }

    private class Enumerator
    implements Enumeration,
    Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;
        private final Hashtable this$0;

        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (Hashtable.access$500(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable hashtable = this.this$0;
            synchronized (hashtable) {
                Entry[] entryArray = Hashtable.access$400(this.this$0);
                int n2 = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n2];
                Entry entry2 = null;
                while (entry != null) {
                    if (entry == this.lastReturned) {
                        Hashtable.access$508(this.this$0);
                        ++this.expectedModCount;
                        if (entry2 == null) {
                            entryArray[n2] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        Hashtable.access$210(this.this$0);
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasMoreElements() {
            Entry entry = this.entry;
            int n2 = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n2 > 0) {
                entry = entryArray[--n2];
            }
            this.entry = entry;
            this.index = n2;
            return entry != null;
        }

        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            if (Hashtable.access$500(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        public Object nextElement() {
            Entry entry = this.entry;
            int n2 = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n2 > 0) {
                entry = entryArray[--n2];
            }
            this.entry = entry;
            this.index = n2;
            if (entry != null) {
                Entry entry2 = this.lastReturned = this.entry;
                this.entry = entry2.next;
                return this.type == 0 ? entry2.key : (this.type == 1 ? entry2.value : entry2);
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        Enumerator(Hashtable hashtable, int n2, boolean bl2) {
            this.this$0 = hashtable;
            this.table = Hashtable.access$400(this.this$0);
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = Hashtable.access$500(this.this$0);
            this.type = n2;
            this.iterator = bl2;
        }
    }

    private class KeySet
    extends AbstractSet {
        private final Hashtable this$0;

        public int size() {
            return Hashtable.access$200(this.this$0);
        }

        public void clear() {
            this.this$0.clear();
        }

        public boolean contains(Object object) {
            return this.this$0.containsKey(object);
        }

        public boolean remove(Object object) {
            return this.this$0.remove(object) != null;
        }

        private KeySet(Hashtable hashtable) {
            this.this$0 = hashtable;
        }

        public Iterator iterator() {
            return Hashtable.access$100(this.this$0, 0);
        }

        KeySet(Hashtable hashtable, 1 var2_2) {
            this(hashtable);
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private final Hashtable this$0;

        public int size() {
            return Hashtable.access$200(this.this$0);
        }

        public void clear() {
            this.this$0.clear();
        }

        public boolean contains(Object object) {
            return this.this$0.containsValue(object);
        }

        private ValueCollection(Hashtable hashtable) {
            this.this$0 = hashtable;
        }

        public Iterator iterator() {
            return Hashtable.access$100(this.this$0, 1);
        }

        ValueCollection(Hashtable hashtable, 1 var2_2) {
            this(hashtable);
        }
    }
}

