/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import sun.util.calendar.ZoneInfo;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final int EPOCH_JULIAN_DAY = 2440588;
    private static final int EPOCH_YEAR = 1970;
    private static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final int[] MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -43200000, 0};
    private static final int[] LEAST_MAX_VALUES = new int[]{1, 292269054, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    private static final int[] MAX_VALUES = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    private long gregorianCutover;
    private transient long normalizedGregorianCutover;
    private transient int gregorianCutoverYear;
    static final long serialVersionUID = -8125100834729963327L;

    int getISOYear() {
        this.complete();
        int n2 = this.internalGet(3);
        int n3 = this.internalGet(1);
        if (this.internalGet(2) == 0) {
            if (n2 >= 52) {
                --n3;
            }
        } else if (n2 == 1) {
            ++n3;
        }
        return n3;
    }

    public int hashCode() {
        return super.hashCode() ^ (int)this.gregorianCutover;
    }

    private final int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : 1;
    }

    private final int yearLength() {
        return this.isLeapYear(this.internalGet(1)) ? 366 : 365;
    }

    private final long getEpochDay() {
        this.complete();
        long l2 = this.time / 1000L + (long)((this.internalGet(15) + this.internalGet(16)) / 1000);
        return GregorianCalendar.floorDivide(l2, 86400L);
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected void computeFields() {
        TimeZone timeZone = this.getTimeZone();
        int[] nArray = new int[2];
        int n2 = timeZone instanceof ZoneInfo ? ((ZoneInfo)timeZone).getOffsets(this.time, nArray) : timeZone.getOffsets(this.time, nArray);
        long l2 = this.time + (long)n2;
        if (this.time > 0L && l2 < 0L && n2 > 0) {
            l2 = Long.MAX_VALUE;
        } else if (this.time < 0L && l2 > 0L && n2 < 0) {
            l2 = Long.MIN_VALUE;
        }
        this.timeToFields(l2, false);
        long l3 = GregorianCalendar.floorDivide(l2, 86400000L);
        int n3 = (int)(l2 - l3 * 86400000L);
        if (n3 < 0) {
            n3 = (int)((long)n3 + 86400000L);
        }
        this.internalSet(14, n3 % 1000);
        this.internalSet(13, (n3 /= 1000) % 60);
        this.internalSet(12, (n3 /= 60) % 60);
        this.internalSet(11, n3 /= 60);
        this.internalSet(9, n3 / 12);
        this.internalSet(10, n3 % 12);
        this.internalSet(15, nArray[0]);
        this.internalSet(16, nArray[1]);
        int n4 = 0;
        while (n4 < 17) {
            this.stamp[n4] = 1;
            this.isSet[n4] = true;
            ++n4;
        }
    }

    protected void computeTime() {
        int n2;
        long l2;
        long l3;
        boolean bl2;
        if (!this.isLenient() && !this.validateFields()) {
            throw new IllegalArgumentException();
        }
        int n3 = this.stamp[1] != 0 ? this.internalGet(1) : 1970;
        int n4 = 1;
        if (this.stamp[0] != 0) {
            n4 = this.internalGet(0);
            if (n4 == 0) {
                n3 = 1 - n3;
            } else if (n4 != 1) {
                throw new IllegalArgumentException("Invalid era");
            }
        }
        if ((bl2 = n3 >= this.gregorianCutoverYear) != (l3 = GregorianCalendar.julianDayToMillis(l2 = this.computeJulianDay(bl2, n3))) >= this.normalizedGregorianCutover && l2 != -106749550580L) {
            l2 = this.computeJulianDay(!bl2, n3);
            l3 = GregorianCalendar.julianDayToMillis(l2);
        }
        int n5 = 0;
        int n6 = this.stamp[10];
        int n7 = this.stamp[11];
        int n8 = n2 = n6 > n7 ? n6 : n7;
        if (n2 != 0) {
            if (n2 == n7) {
                n5 += this.internalGet(11);
            } else {
                n5 += this.internalGet(10);
                n5 += 12 * this.internalGet(9);
            }
        }
        n5 *= 60;
        n5 += this.internalGet(12);
        n5 *= 60;
        n5 += this.internalGet(13);
        n5 *= 1000;
        l3 += (long)(n5 += this.internalGet(14));
        TimeZone timeZone = this.getTimeZone();
        if (timeZone instanceof ZoneInfo) {
            int[] nArray = new int[2];
            ((ZoneInfo)timeZone).getOffsetsByWall(l3, nArray);
            int n9 = this.stamp[15] >= 2 ? this.internalGet(15) : nArray[0];
            this.time = l3 - (long)(n9 += this.stamp[16] >= 2 ? this.internalGet(16) : nArray[1]);
        } else {
            int n10;
            int n11 = n10 = this.stamp[15] >= 2 ? this.internalGet(15) : timeZone.getRawOffset();
            if (this.stamp[16] >= 2) {
                this.time = l3 - (long)n10 - (long)this.internalGet(16);
                return;
            }
            this.time = l3 - (long)timeZone.getOffsets(l3 - (long)n10, null);
        }
    }

    private final void pinDayOfMonth() {
        int n2 = this.monthLength(this.internalGet(2));
        int n3 = this.internalGet(5);
        if (n3 > n2) {
            this.set(5, n2);
        }
    }

    boolean inDaylightTime() {
        if (!this.getTimeZone().useDaylightTime()) {
            return false;
        }
        this.complete();
        return this.internalGet(16) != 0;
    }

    private boolean validateFields() {
        int n2;
        int n3 = 0;
        while (n3 < 17) {
            if (n3 != 5 && n3 != 6 && this.isSet(n3) && !this.boundsCheck(this.internalGet(n3), n3)) {
                return false;
            }
            ++n3;
        }
        if (this.stamp[5] >= 2 && ((n2 = this.internalGet(5)) < this.getMinimum(5) || n2 > this.monthLength(this.internalGet(2)))) {
            return false;
        }
        if (this.stamp[6] >= 2 && ((n2 = this.internalGet(6)) < 1 || n2 > this.yearLength())) {
            return false;
        }
        return !this.isSet(8) || 0 != this.internalGet(8);
    }

    public int getActualMaximum(int n2) {
        switch (n2) {
            case 5: {
                return this.monthLength(this.get(2));
            }
            case 6: {
                return this.yearLength();
            }
            case 3: 
            case 4: 
            case 8: {
                return super.getActualMaximum(n2);
            }
            case 1: {
                Calendar calendar = (Calendar)this.clone();
                calendar.setLenient(true);
                int n3 = calendar.get(0);
                Date date = calendar.getTime();
                int n4 = LEAST_MAX_VALUES[1];
                int n5 = MAX_VALUES[1] + 1;
                while (n4 + 1 < n5) {
                    int n6 = (n4 + n5) / 2;
                    calendar.set(1, n6);
                    if (calendar.get(1) == n6 && calendar.get(0) == n3) {
                        n4 = n6;
                        continue;
                    }
                    n5 = n6;
                    calendar.setTime(date);
                }
                return n4;
            }
        }
        return this.getMaximum(n2);
    }

    public int getActualMinimum(int n2) {
        return this.getMinimum(n2);
    }

    public int getGreatestMinimum(int n2) {
        return MIN_VALUES[n2];
    }

    public int getLeastMaximum(int n2) {
        return LEAST_MAX_VALUES[n2];
    }

    public int getMaximum(int n2) {
        return MAX_VALUES[n2];
    }

    public int getMinimum(int n2) {
        return MIN_VALUES[n2];
    }

    private final int monthLength(int n2) {
        int n3 = this.internalGet(1);
        if (this.internalGetEra() == 0) {
            n3 = 1 - n3;
        }
        return this.monthLength(n2, n3);
    }

    private final int prevMonthLength(int n2) {
        return n2 > 1 ? this.monthLength(n2 - 1) : 31;
    }

    private final int yearLength(int n2) {
        return this.isLeapYear(n2) ? 366 : 365;
    }

    public boolean isLeapYear(int n2) {
        return n2 >= this.gregorianCutoverYear ? n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0) : n2 % 4 == 0;
    }

    private static final int aggregateStamp(int n2, int n3) {
        return n2 != 0 && n3 != 0 ? Math.max(n2, n3) : 0;
    }

    private static final int floorDivide(int n2, int n3) {
        return n2 >= 0 ? n2 / n3 : (n2 + 1) / n3 - 1;
    }

    private final int monthLength(int n2, int n3) {
        return this.isLeapYear(n3) ? LEAP_MONTH_LENGTH[n2] : MONTH_LENGTH[n2];
    }

    private final int weekNumber(int n2, int n3) {
        int n4 = (n3 - this.getFirstDayOfWeek() - n2 + 1) % 7;
        if (n4 < 0) {
            n4 += 7;
        }
        int n5 = (n2 + n4 - 1) / 7;
        if (7 - n4 >= this.getMinimalDaysInFirstWeek()) {
            ++n5;
        }
        return n5;
    }

    public void add(int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.complete();
        if (n2 == 1) {
            int n4 = this.internalGet(1);
            if (this.internalGetEra() == 1) {
                if ((n4 += n3) > 0) {
                    this.set(1, n4);
                } else {
                    this.set(1, 1 - n4);
                    this.set(0, 0);
                }
            } else if ((n4 -= n3) > 0) {
                this.set(1, n4);
            } else {
                this.set(1, 1 - n4);
                this.set(0, 1);
            }
            this.pinDayOfMonth();
        } else if (n2 == 2) {
            int n5 = this.internalGet(2) + n3;
            int n6 = this.internalGet(1);
            int n7 = n5 >= 0 ? n5 / 12 : (n5 + 1) / 12 - 1;
            if (n7 != 0) {
                if (this.internalGetEra() == 1) {
                    if ((n6 += n7) > 0) {
                        this.set(1, n6);
                    } else {
                        this.set(1, 1 - n6);
                        this.set(0, 0);
                    }
                } else if ((n6 -= n7) > 0) {
                    this.set(1, n6);
                } else {
                    this.set(1, 1 - n6);
                    this.set(0, 1);
                }
            }
            if (n5 >= 0) {
                this.set(2, n5 % 12);
            } else {
                if ((n5 %= 12) < 0) {
                    n5 += 12;
                }
                this.set(2, 0 + n5);
            }
            this.pinDayOfMonth();
        } else if (n2 == 0) {
            int n8 = this.internalGet(0) + n3;
            if (n8 < 0) {
                n8 = 0;
            }
            if (n8 > 1) {
                n8 = 1;
            }
            this.set(0, n8);
        } else {
            long l2 = n3;
            boolean bl2 = true;
            switch (n2) {
                case 3: 
                case 4: 
                case 8: {
                    l2 *= 604800000L;
                    break;
                }
                case 9: {
                    l2 *= 43200000L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    l2 *= 86400000L;
                    break;
                }
                case 10: 
                case 11: {
                    l2 *= 3600000L;
                    bl2 = false;
                    break;
                }
                case 12: {
                    l2 *= 60000L;
                    bl2 = false;
                    break;
                }
                case 13: {
                    l2 *= 1000L;
                    bl2 = false;
                    break;
                }
                case 14: {
                    bl2 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            long l3 = 0L;
            if (bl2) {
                l3 = this.internalGet(16);
            }
            this.setTimeInMillis(this.time + l2);
            if (bl2 && (l3 -= (long)this.internalGet(16)) != 0L) {
                this.setTimeInMillis(this.time + l3);
            }
        }
    }

    public void roll(int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        if (n2 >= 0 && n2 < 17) {
            this.complete();
            n4 = this.getMinimum(n2);
            n5 = this.getMaximum(n2);
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                Date date = this.getTime();
                int n6 = this.internalGet(n2);
                int n7 = (n6 + n3) % (n5 + 1);
                if (n7 < 0) {
                    n7 += n5 + 1;
                }
                this.setTime(new Date(date.getTime() + (long)(3600000 * (n7 - n6))));
                return;
            }
            case 2: {
                int n8 = (this.internalGet(2) + n3) % 12;
                if (n8 < 0) {
                    n8 += 12;
                }
                this.set(2, n8);
                int n9 = this.monthLength(n8);
                int n10 = this.internalGet(5);
                if (n10 > n9) {
                    this.set(5, n9);
                }
                return;
            }
            case 3: {
                int n11 = this.internalGet(3);
                int n12 = this.internalGet(1);
                int n13 = this.internalGet(6);
                if (this.internalGet(2) == 0) {
                    if (n11 >= 52) {
                        n13 += this.yearLength(--n12);
                    }
                } else if (n11 == 1) {
                    n13 -= this.yearLength(n12);
                    ++n12;
                }
                if ((n11 += n3) < 1 || n11 > 52) {
                    int n14;
                    int n15;
                    int n16 = this.yearLength(n12);
                    int n17 = this.internalGet(7) - this.getFirstDayOfWeek();
                    if (n17 < 0) {
                        n17 += 7;
                    }
                    if ((n15 = (n16 - n13 + n17) % 7) < 0) {
                        n15 += 7;
                    }
                    if ((n16 -= n15 + 1) - (n14 = n16 / 7) * 7 >= this.getMinimalDaysInFirstWeek()) {
                        ++n14;
                    }
                    if (6 - n15 < this.getMinimalDaysInFirstWeek()) {
                        ++n14;
                    }
                    n11 = (n11 + n14 - 1) % n14 + 1;
                }
                this.set(3, n11);
                this.set(1, n12);
                return;
            }
            case 4: {
                int n18;
                int n19 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n19 < 0) {
                    n19 += 7;
                }
                if ((n18 = (n19 - this.internalGet(5) + 1) % 7) < 0) {
                    n18 += 7;
                }
                int n20 = 7 - n18 < this.getMinimalDaysInFirstWeek() ? 8 - n18 : 1 - n18;
                int n21 = this.monthLength(this.internalGet(2));
                int n22 = (n21 - this.internalGet(5) + n19) % 7;
                int n23 = n21 + 7 - n22;
                int n24 = n23 - n20;
                int n25 = (this.internalGet(5) + n3 * 7 - n20) % n24;
                if (n25 < 0) {
                    n25 += n24;
                }
                if ((n25 += n20) < 1) {
                    n25 = 1;
                }
                if (n25 > n21) {
                    n25 = n21;
                }
                this.set(5, n25);
                return;
            }
            case 5: {
                n5 = this.monthLength(this.internalGet(2));
                break;
            }
            case 6: {
                long l2 = (long)n3 * 86400000L;
                long l3 = this.time - (long)(this.internalGet(6) - 1) * 86400000L;
                int n26 = this.yearLength();
                this.time = (this.time + l2 - l3) % ((long)n26 * 86400000L);
                if (this.time < 0L) {
                    this.time += (long)n26 * 86400000L;
                }
                long l4 = this.internalGet(16);
                this.setTimeInMillis(this.time + l3);
                if ((l4 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.time + l4);
                }
                return;
            }
            case 7: {
                long l5 = (long)n3 * 86400000L;
                int n27 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n27 < 0) {
                    n27 += 7;
                }
                long l6 = this.time - (long)n27 * 86400000L;
                this.time = (this.time + l5 - l6) % 604800000L;
                if (this.time < 0L) {
                    this.time += 604800000L;
                }
                long l7 = this.internalGet(16);
                this.setTimeInMillis(this.time + l6);
                if ((l7 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.time + l7);
                }
                return;
            }
            case 8: {
                long l8 = (long)n3 * 604800000L;
                int n28 = (this.internalGet(5) - 1) / 7;
                int n29 = (this.monthLength(this.internalGet(2)) - this.internalGet(5)) / 7;
                long l9 = this.time - (long)n28 * 604800000L;
                long l10 = 604800000L * (long)(n28 + n29 + 1);
                this.time = (this.time + l8 - l9) % l10;
                if (this.time < 0L) {
                    this.time += l10;
                }
                long l11 = this.internalGet(16);
                this.setTimeInMillis(this.time + l9);
                if ((l11 -= (long)this.internalGet(16)) != 0L) {
                    this.setTimeInMillis(this.time + l11);
                }
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n30 = n5 - n4 + 1;
        int n31 = this.internalGet(n2) + n3;
        n31 = (n31 - n4) % n30;
        if (n31 < 0) {
            n31 += n30;
        }
        this.set(n2, n31 += n4);
    }

    private final boolean boundsCheck(int n2, int n3) {
        return n2 >= this.getMinimum(n3) && n2 <= this.getMaximum(n3);
    }

    public GregorianCalendar(int n2, int n3, int n4) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
    }

    public GregorianCalendar(int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
    }

    public GregorianCalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
        this.set(13, n7);
    }

    private static final int floorDivide(int n2, int n3, int[] nArray) {
        if (n2 >= 0) {
            nArray[0] = n2 % n3;
            return n2 / n3;
        }
        int n4 = (n2 + 1) / n3 - 1;
        nArray[0] = n2 - n4 * n3;
        return n4;
    }

    public void roll(int n2, boolean bl2) {
        this.roll(n2, bl2 ? 1 : -1);
    }

    private static final int julianDayToDayOfWeek(long l2) {
        int n2;
        return n2 + ((n2 = (int)((l2 + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private static final long julianDayToMillis(long l2) {
        return (l2 - 2440588L) * 86400000L;
    }

    private static final long millisToJulianDay(long l2) {
        return 2440588L + GregorianCalendar.floorDivide(l2, 86400000L);
    }

    private static final int floorDivide(long l2, int n2, int[] nArray) {
        if (l2 >= 0L) {
            nArray[0] = (int)(l2 % (long)n2);
            return (int)(l2 / (long)n2);
        }
        int n3 = (int)((l2 + 1L) / (long)n2 - 1L);
        nArray[0] = (int)(l2 - (long)(n3 * n2));
        return n3;
    }

    private static final long floorDivide(long l2, long l3) {
        return l2 >= 0L ? l2 / l3 : (l2 + 1L) / l3 - 1L;
    }

    private final void timeToFields(long l2, boolean bl2) {
        int n2;
        int n3;
        boolean bl3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        long l3;
        if (l2 >= this.normalizedGregorianCutover) {
            int n9;
            l3 = GregorianCalendar.millisToJulianDay(l2) - 1721426L;
            if (l3 > 0L) {
                n9 = (int)(l3 / 146097L);
                n8 = (int)(l3 % 146097L);
                n7 = n8 / 36524;
                n6 = (n8 %= 36524) / 1461;
                n5 = (n8 %= 1461) / 365;
                n8 %= 365;
            } else {
                int[] nArray = new int[1];
                n9 = GregorianCalendar.floorDivide(l3, 146097, nArray);
                n7 = GregorianCalendar.floorDivide(nArray[0], 36524, nArray);
                n6 = GregorianCalendar.floorDivide(nArray[0], 1461, nArray);
                n5 = GregorianCalendar.floorDivide(nArray[0], 365, nArray);
                n8 = nArray[0];
            }
            n4 = 400 * n9 + 100 * n7 + 4 * n6 + n5;
            if (n7 == 4 || n5 == 4) {
                n8 = 365;
            } else {
                ++n4;
            }
            bl3 = (n4 & 3) == 0 && (n4 % 100 != 0 || n4 % 400 == 0);
            n3 = (int)((l3 + 1L) % 7L);
        } else {
            l3 = GregorianCalendar.millisToJulianDay(l2) - 1721424L;
            n4 = (int)GregorianCalendar.floorDivide(4L * l3 + 1464L, 1461L);
            long l4 = 365 * (n4 - 1) + GregorianCalendar.floorDivide(n4 - 1, 4);
            n8 = (int)(l3 - l4);
            bl3 = (n4 & 3) == 0;
            n3 = (int)((l3 - 1L) % 7L);
        }
        int n10 = 0;
        int n11 = n2 = bl3 ? 60 : 59;
        if (n8 >= n2) {
            n10 = bl3 ? 1 : 2;
        }
        int n12 = (12 * (n8 + n10) + 6) / 367;
        int n13 = n8 - (bl3 ? LEAP_NUM_DAYS[n12] : NUM_DAYS[n12]) + 1;
        n3 += n3 < 0 ? 8 : 1;
        int n14 = 1;
        int n15 = n4;
        if (n15 < 1) {
            n14 = 0;
            n15 = 1 - n15;
        }
        this.internalSet(0, n14);
        this.internalSet(1, n15);
        this.internalSet(2, n12 + 0);
        this.internalSet(5, n13);
        this.internalSet(7, n3);
        this.internalSet(6, ++n8);
        if (bl2) {
            return;
        }
        int n16 = (n3 + 7 - this.getFirstDayOfWeek()) % 7;
        n7 = (n3 - n8 + 701 - this.getFirstDayOfWeek()) % 7;
        n6 = (n8 - 1 + n7) / 7;
        if (7 - n7 >= this.getMinimalDaysInFirstWeek()) {
            ++n6;
        }
        if (n8 > 359) {
            n5 = this.yearLength();
            int n17 = (n16 + n5 - n8) % 7;
            if (n17 < 0) {
                n17 += 7;
            }
            if (6 - n17 >= this.getMinimalDaysInFirstWeek() && n8 + 7 - n16 > n5) {
                n6 = 1;
            }
        } else if (n6 == 0) {
            n5 = n8 + this.yearLength(n4 - 1);
            n6 = this.weekNumber(n5, n3);
        }
        this.internalSet(3, n6);
        this.internalSet(4, this.weekNumber(n13, n3));
        this.internalSet(8, (n13 - 1) / 7 + 1);
    }

    private final long computeJulianDay(boolean bl2, int n2) {
        int n3 = 0;
        int n4 = 0;
        long l2 = 0L;
        int n5 = this.stamp[7];
        int n6 = this.stamp[2];
        int n7 = this.stamp[5];
        int n8 = GregorianCalendar.aggregateStamp(this.stamp[4], n5);
        int n9 = GregorianCalendar.aggregateStamp(this.stamp[8], n5);
        int n10 = this.stamp[6];
        int n11 = GregorianCalendar.aggregateStamp(this.stamp[3], n5);
        int n12 = n7;
        if (n8 > n12) {
            n12 = n8;
        }
        if (n9 > n12) {
            n12 = n9;
        }
        if (n10 > n12) {
            n12 = n10;
        }
        if (n11 > n12) {
            n12 = n11;
        }
        if (n12 == 0) {
            n8 = this.stamp[4];
            n9 = Math.max(this.stamp[8], n5);
            n11 = this.stamp[3];
            n12 = Math.max(Math.max(n8, n9), n11);
            if (n12 == 0) {
                n12 = n7 = n6;
            }
        }
        boolean bl3 = false;
        if (n12 == n7 || n12 == n8 && this.stamp[4] >= this.stamp[3] || n12 == n9 && this.stamp[8] >= this.stamp[3]) {
            bl3 = true;
            int n13 = n3 = n6 != 0 ? this.internalGet(2) - 0 : 0;
            if (n3 < 0 || n3 > 11) {
                int[] nArray = new int[1];
                n2 += GregorianCalendar.floorDivide(n3, 12, nArray);
                n3 = nArray[0];
            }
        }
        boolean bl4 = n2 % 4 == 0;
        int n14 = n2 - 1;
        long l3 = 365L * (long)n14 + (long)GregorianCalendar.floorDivide(n14, 4) + 1721423L;
        if (bl2) {
            bl4 = bl4 && (n2 % 100 != 0 || n2 % 400 == 0);
            l3 += (long)(GregorianCalendar.floorDivide(n14, 400) - GregorianCalendar.floorDivide(n14, 100) + 2);
        }
        if (bl3) {
            l3 += bl4 ? (long)LEAP_NUM_DAYS[n3] : (long)NUM_DAYS[n3];
            if (n12 == n7) {
                n4 = this.stamp[5] != 0 ? this.internalGet(5) : 1;
            } else {
                int n15 = GregorianCalendar.julianDayToDayOfWeek(l3 + 1L) - this.getFirstDayOfWeek();
                if (n15 < 0) {
                    n15 += 7;
                }
                int n16 = 0;
                if (n5 != 0 && (n16 = this.internalGet(7) - this.getFirstDayOfWeek()) < 0) {
                    n16 += 7;
                }
                n4 = 1 - n15 + n16;
                if (n12 == n8) {
                    if (7 - n15 < this.getMinimalDaysInFirstWeek()) {
                        n4 += 7;
                    }
                    n4 += 7 * (this.internalGet(4) - 1);
                } else {
                    int n17;
                    if (n4 < 1) {
                        n4 += 7;
                    }
                    int n18 = n17 = this.stamp[8] != 0 ? this.internalGet(8) : 1;
                    n4 = n17 >= 0 ? (n4 += 7 * (n17 - 1)) : (n4 += ((this.monthLength(this.internalGet(2), n2) - n4) / 7 + n17 + 1) * 7);
                }
            }
            l3 += (long)n4;
        } else if (n12 == n10) {
            l3 += (long)this.internalGet(6);
        } else {
            int n19 = GregorianCalendar.julianDayToDayOfWeek(l3 + 1L) - this.getFirstDayOfWeek();
            if (n19 < 0) {
                n19 += 7;
            }
            int n20 = 0;
            if (n5 != 0 && (n20 = this.internalGet(7) - this.getFirstDayOfWeek()) < 0) {
                n20 += 7;
            }
            n4 = 1 - n19 + n20;
            if (7 - n19 < this.getMinimalDaysInFirstWeek()) {
                n4 += 7;
            }
            l3 += (long)(n4 += 7 * (this.internalGet(3) - 1));
        }
        return l3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setGregorianChange(new Date(this.gregorianCutover));
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof GregorianCalendar && this.gregorianCutover == ((GregorianCalendar)object).gregorianCutover;
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
        long l2 = GregorianCalendar.floorDivide(this.gregorianCutover, 86400000L);
        this.normalizedGregorianCutover = l2 * 86400000L;
        if (l2 < 0L && this.normalizedGregorianCutover > 0L) {
            this.normalizedGregorianCutover = (l2 + 1L) * 86400000L;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setTime(date);
        this.gregorianCutoverYear = gregorianCalendar.get(1);
        if (gregorianCalendar.get(0) == 0) {
            this.gregorianCutoverYear = 1 - this.gregorianCutoverYear;
        }
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.setTimeInMillis(System.currentTimeMillis());
    }
}

