/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class ArrayList
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient Object[] elementData;
    private int size;

    public int size() {
        return this.size;
    }

    public ArrayList() {
        this(10);
    }

    public void clear() {
        ++this.modCount;
        int n2 = 0;
        while (n2 < this.size) {
            this.elementData[n2] = null;
            ++n2;
        }
        this.size = 0;
    }

    public void trimToSize() {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (this.size < n2) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ArrayList(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        this.elementData = new Object[n2];
    }

    private void RangeCheck(int n2) {
        if (n2 >= this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
    }

    public void ensureCapacity(int n2) {
        ++this.modCount;
        int n3 = this.elementData.length;
        if (n2 > n3) {
            Object[] objectArray = this.elementData;
            int n4 = n3 * 3 / 2 + 1;
            if (n4 < n2) {
                n4 = n2;
            }
            this.elementData = new Object[n4];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    protected void removeRange(int n2, int n3) {
        ++this.modCount;
        int n4 = this.size - n3;
        System.arraycopy(this.elementData, n3, this.elementData, n2, n4);
        int n5 = this.size - (n3 - n2);
        while (this.size != n5) {
            this.elementData[--this.size] = null;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.elementData = new Object[n2];
        int n3 = 0;
        while (n3 < this.size) {
            this.elementData[n3] = objectInputStream.readObject();
            ++n3;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        int n2 = 0;
        while (n2 < this.size) {
            objectOutputStream.writeObject(this.elementData[n2]);
            ++n2;
        }
    }

    public Object clone() {
        try {
            ArrayList arrayList = (ArrayList)super.clone();
            arrayList.elementData = new Object[this.size];
            System.arraycopy(this.elementData, 0, arrayList.elementData, 0, this.size);
            arrayList.modCount = 0;
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object get(int n2) {
        this.RangeCheck(n2);
        return this.elementData[n2];
    }

    public Object remove(int n2) {
        this.RangeCheck(n2);
        ++this.modCount;
        Object object = this.elementData[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        this.elementData[--this.size] = null;
        return object;
    }

    public void add(int n2, Object object) {
        if (n2 > this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.size - n2);
        this.elementData[n2] = object;
        ++this.size;
    }

    public int indexOf(Object object) {
        if (object == null) {
            int n2 = 0;
            while (n2 < this.size) {
                if (this.elementData[n2] == null) {
                    return n2;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.size) {
                if (object.equals(this.elementData[n3])) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            int n2 = this.size - 1;
            while (n2 >= 0) {
                if (this.elementData[n2] == null) {
                    return n2;
                }
                --n2;
            }
        } else {
            int n3 = this.size - 1;
            while (n3 >= 0) {
                if (object.equals(this.elementData[n3])) {
                    return n3;
                }
                --n3;
            }
        }
        return -1;
    }

    public boolean add(Object object) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = object;
        return true;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public boolean addAll(int n2, Collection collection) {
        if (n2 > this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        int n3 = collection.size();
        this.ensureCapacity(this.size + n3);
        int n4 = this.size - n2;
        if (n4 > 0) {
            System.arraycopy(this.elementData, n2, this.elementData, n2 + n3, n4);
        }
        Iterator iterator = collection.iterator();
        int n5 = 0;
        while (n5 < n3) {
            this.elementData[n2++] = iterator.next();
            ++n5;
        }
        this.size += n3;
        return n3 != 0;
    }

    public ArrayList(Collection collection) {
        this.size = collection.size();
        this.elementData = new Object[(int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE)];
        collection.toArray(this.elementData);
    }

    public boolean addAll(Collection collection) {
        ++this.modCount;
        int n2 = collection.size();
        this.ensureCapacity(this.size + n2);
        Iterator iterator = collection.iterator();
        int n3 = 0;
        while (n3 < n2) {
            this.elementData[this.size++] = iterator.next();
            ++n3;
        }
        return n2 != 0;
    }

    public Object set(int n2, Object object) {
        this.RangeCheck(n2);
        Object object2 = this.elementData[n2];
        this.elementData[n2] = object;
        return object2;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }
}

