/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RBCollationTables;
import sun.text.Normalizer;
import sun.text.NormalizerUtilities;

public class RuleBasedCollator
extends Collator {
    static final int CHARINDEX = 0x70000000;
    static final int EXPANDCHARINDEX = 0x7E000000;
    static final int CONTRACTCHARINDEX = 0x7F000000;
    static final int UNMAPPED = -1;
    private static final int COLLATIONKEYOFFSET = 1;
    private RBCollationTables tables = null;
    private StringBuffer primResult = null;
    private StringBuffer secResult = null;
    private StringBuffer terResult = null;
    private CollationElementIterator sourceCursor = null;
    private CollationElementIterator targetCursor = null;
    static Class class$java$text$RuleBasedCollator;

    public int hashCode() {
        return this.getRules().hashCode();
    }

    public Object clone() {
        if (this.getClass() == (class$java$text$RuleBasedCollator == null ? (class$java$text$RuleBasedCollator = RuleBasedCollator.class$("java.text.RuleBasedCollator")) : class$java$text$RuleBasedCollator)) {
            return new RuleBasedCollator(this);
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)super.clone();
        ruleBasedCollator.primResult = null;
        ruleBasedCollator.secResult = null;
        ruleBasedCollator.terResult = null;
        ruleBasedCollator.sourceCursor = null;
        ruleBasedCollator.targetCursor = null;
        return ruleBasedCollator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)object;
        return this.getRules().equals(ruleBasedCollator.getRules());
    }

    public String getRules() {
        return this.tables.getRules();
    }

    public RuleBasedCollator(String string) throws ParseException {
        this(string, 1);
    }

    RuleBasedCollator(String string, int n2) throws ParseException {
        this.setStrength(2);
        this.setDecomposition(n2);
        this.tables = new RBCollationTables(string, n2);
    }

    RBCollationTables getTables() {
        return this.tables;
    }

    private RuleBasedCollator(RuleBasedCollator ruleBasedCollator) {
        this.setStrength(ruleBasedCollator.getStrength());
        this.setDecomposition(ruleBasedCollator.getDecomposition());
        this.tables = ruleBasedCollator.tables;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized int compare(String string, String string2) {
        boolean bl2;
        int n2 = 0;
        if (this.sourceCursor == null) {
            this.sourceCursor = this.getCollationElementIterator(string);
        } else {
            this.sourceCursor.setText(string);
        }
        if (this.targetCursor == null) {
            this.targetCursor = this.getCollationElementIterator(string2);
        } else {
            this.targetCursor.setText(string2);
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = bl2 = this.getStrength() >= 1;
        boolean bl4 = this.getStrength() >= 2;
        boolean bl5 = true;
        boolean bl6 = true;
        while (true) {
            short s2;
            short s3;
            short s4;
            if (bl5) {
                n3 = this.sourceCursor.next();
            } else {
                bl5 = true;
            }
            if (bl6) {
                n4 = this.targetCursor.next();
            } else {
                bl6 = true;
            }
            if (n3 == -1 || n4 == -1) break;
            int n5 = CollationElementIterator.primaryOrder(n3);
            int n6 = CollationElementIterator.primaryOrder(n4);
            if (n3 == n4) {
                if (!this.tables.isFrenchSec() || n5 == 0 || bl3) continue;
                bl3 = bl2;
                bl4 = false;
                continue;
            }
            if (n5 != n6) {
                if (n3 == 0) {
                    bl6 = false;
                    continue;
                }
                if (n4 == 0) {
                    bl5 = false;
                    continue;
                }
                if (n5 == 0) {
                    if (bl3) {
                        n2 = 1;
                        bl3 = false;
                    }
                    bl6 = false;
                    continue;
                }
                if (n6 == 0) {
                    if (bl3) {
                        n2 = -1;
                        bl3 = false;
                    }
                    bl5 = false;
                    continue;
                }
                if (n5 < n6) {
                    return -1;
                }
                return 1;
            }
            if (!bl3) continue;
            short s5 = CollationElementIterator.secondaryOrder(n3);
            if (s5 != (s4 = CollationElementIterator.secondaryOrder(n4))) {
                n2 = s5 < s4 ? -1 : 1;
                bl3 = false;
                continue;
            }
            if (!bl4 || (s3 = CollationElementIterator.tertiaryOrder(n3)) == (s2 = CollationElementIterator.tertiaryOrder(n4))) continue;
            n2 = s3 < s2 ? -1 : 1;
            bl4 = false;
        }
        if (n3 != -1) {
            do {
                if (CollationElementIterator.primaryOrder(n3) != 0) {
                    return 1;
                }
                if (CollationElementIterator.secondaryOrder(n3) == 0 || !bl3) continue;
                n2 = 1;
                bl3 = false;
            } while ((n3 = this.sourceCursor.next()) != -1);
        } else if (n4 != -1) {
            do {
                if (CollationElementIterator.primaryOrder(n4) != 0) {
                    return -1;
                }
                if (CollationElementIterator.secondaryOrder(n4) == 0 || !bl3) continue;
                n2 = -1;
                bl3 = false;
            } while ((n4 = this.targetCursor.next()) != -1);
        }
        if (n2 == 0 && this.getStrength() == 3) {
            Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.getDecomposition());
            String string3 = Normalizer.normalize(string, mode, 0);
            String string4 = Normalizer.normalize(string2, mode, 0);
            n2 = string3.compareTo(string4);
        }
        return n2;
    }

    public CollationElementIterator getCollationElementIterator(String string) {
        return new CollationElementIterator(string, this);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator characterIterator) {
        return new CollationElementIterator(characterIterator, this);
    }

    public synchronized CollationKey getCollationKey(String string) {
        if (string == null) {
            return null;
        }
        if (this.primResult == null) {
            this.primResult = new StringBuffer();
            this.secResult = new StringBuffer();
            this.terResult = new StringBuffer();
        } else {
            this.primResult.setLength(0);
            this.secResult.setLength(0);
            this.terResult.setLength(0);
        }
        int n2 = 0;
        boolean bl2 = this.getStrength() >= 1;
        boolean bl3 = this.getStrength() >= 2;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        if (this.sourceCursor == null) {
            this.sourceCursor = this.getCollationElementIterator(string);
        } else {
            this.sourceCursor.setText(string);
        }
        while ((n2 = this.sourceCursor.next()) != -1) {
            n3 = CollationElementIterator.secondaryOrder(n2);
            n4 = CollationElementIterator.tertiaryOrder(n2);
            if (!CollationElementIterator.isIgnorable(n2)) {
                this.primResult.append((char)(CollationElementIterator.primaryOrder(n2) + 1));
                if (bl2) {
                    if (this.tables.isFrenchSec() && n5 < this.secResult.length()) {
                        RBCollationTables.reverse(this.secResult, n5, this.secResult.length());
                    }
                    this.secResult.append((char)(n3 + 1));
                    n5 = this.secResult.length();
                }
                if (!bl3) continue;
                this.terResult.append((char)(n4 + 1));
                continue;
            }
            if (bl2 && n3 != 0) {
                this.secResult.append((char)(n3 + this.tables.getMaxSecOrder() + 1));
            }
            if (!bl3 || n4 == 0) continue;
            this.terResult.append((char)(n4 + this.tables.getMaxTerOrder() + 1));
        }
        if (this.tables.isFrenchSec()) {
            if (n5 < this.secResult.length()) {
                RBCollationTables.reverse(this.secResult, n5, this.secResult.length());
            }
            RBCollationTables.reverse(this.secResult, 0, this.secResult.length());
        }
        this.primResult.append('\u0000');
        this.secResult.append('\u0000');
        this.secResult.append(this.terResult.toString());
        this.primResult.append(this.secResult.toString());
        if (this.getStrength() == 3) {
            this.primResult.append('\u0000');
            Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.getDecomposition());
            this.primResult.append(Normalizer.normalize(string, mode, 0));
        }
        return new CollationKey(string, this.primResult.toString());
    }
}

