/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public static final int DBL_DIG = 17;
    public int decimalAt = 0;
    public int count = 0;
    public byte[] digits = new byte[19];
    private static final boolean DEBUG = false;
    private static byte[] LONG_MIN_REP;
    private static final double LOG10;

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        stringBuffer.append('.');
        int n2 = 0;
        while (n2 < this.count) {
            stringBuffer.append((char)this.digits[n2]);
            ++n2;
        }
        stringBuffer.append('E');
        stringBuffer.append(Integer.toString(this.decimalAt));
        return Double.valueOf(stringBuffer.toString());
    }

    public int hashCode() {
        int n2 = this.decimalAt;
        int n3 = 0;
        while (n3 < this.count) {
            n2 = n2 * 37 + this.digits[n3];
            ++n3;
        }
        return n2;
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        int n2 = 0;
        while (n2 < this.decimalAt) {
            stringBuffer.append(n2 < this.count ? (char)this.digits[n2] : (char)'0');
            ++n2;
        }
        return Long.parseLong(stringBuffer.toString());
    }

    static {
        String string = Long.toString(Long.MIN_VALUE);
        LONG_MIN_REP = new byte[19];
        int n2 = 0;
        while (n2 < 19) {
            DigitList.LONG_MIN_REP[n2] = (byte)string.charAt(n2 + 1);
            ++n2;
        }
        LOG10 = Math.log(10.0);
    }

    DigitList() {
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.count) {
            if (this.digits[n2] != LONG_MIN_REP[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean isZero() {
        int n2 = 0;
        while (n2 < this.count) {
            if (this.digits[n2] != 48) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final int log10(double d2) {
        double d3 = Math.log(d2) / LOG10;
        int n2 = (int)Math.floor(d3);
        if (d3 > 0.0 && d2 >= Math.pow(10.0, n2 + 1)) {
            ++n2;
        } else if (d3 < 0.0 && d2 < Math.pow(10.0, n2)) {
            --n2;
        }
        return n2;
    }

    public final void set(double d2, int n2) {
        this.set(d2, n2, true);
    }

    /*
     * Unable to fully structure code
     */
    final void set(double var1_1, int var3_2, boolean var4_3) {
        if (var1_1 == 0.0) {
            var1_1 = 0.0;
        }
        var5_4 = Double.toString(var1_1);
        this.decimalAt = -1;
        this.count = 0;
        var6_5 = 0;
        var7_6 = 0;
        var8_7 = false;
        var9_8 = 0;
        while (var9_8 < var5_4.length()) {
            var10_9 = var5_4.charAt(var9_8);
            if (var10_9 == '.') {
                this.decimalAt = this.count;
            } else {
                if (var10_9 == 'e' || var10_9 == 'E') {
                    var6_5 = Integer.valueOf(var5_4.substring(var9_8 + 1));
                    break;
                }
                if (this.count < 19) {
                    if (!var8_7) {
                        v0 = var8_7 = var10_9 != '0';
                        if (!var8_7 && this.decimalAt != -1) {
                            ++var7_6;
                        }
                    }
                    if (var8_7) {
                        this.digits[this.count++] = (byte)var10_9;
                    }
                }
            }
            ++var9_8;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        if (var8_7) {
            this.decimalAt += var6_5 - var7_6;
        }
        if (!var4_3) ** GOTO lbl44
        if (-this.decimalAt > var3_2) {
            this.count = 0;
            return;
        }
        if (-this.decimalAt != var3_2) ** GOTO lbl44
        if (this.shouldRoundUp(0)) {
            this.count = 1;
            ++this.decimalAt;
            this.digits[0] = 49;
        } else {
            this.count = 0;
        }
        return;
lbl-1000:
        // 1 sources

        {
            --this.count;
lbl44:
            // 3 sources

            ** while (this.count > 1 && this.digits[this.count - 1] == 48)
        }
lbl45:
        // 1 sources

        this.round(var4_3 != false ? var3_2 + this.decimalAt : var3_2);
    }

    public void append(int n2) {
        if (this.count < 19) {
            this.digits[this.count++] = (byte)n2;
        }
    }

    private final void round(int n2) {
        if (n2 >= 0 && n2 < this.count) {
            if (this.shouldRoundUp(n2)) {
                do {
                    if (--n2 < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n2 = 0;
                        break;
                    }
                    int n3 = n2;
                    this.digits[n3] = (byte)(this.digits[n3] + 1);
                } while (this.digits[n2] > 57);
                ++n2;
            }
            this.count = n2;
            while (this.count > 1 && this.digits[this.count - 1] == 48) {
                --this.count;
            }
        }
    }

    private boolean shouldRoundUp(int n2) {
        boolean bl2 = false;
        if (n2 < this.count) {
            if (this.digits[n2] > 53) {
                return true;
            }
            if (this.digits[n2] == 53) {
                int n3 = n2 + 1;
                while (n3 < this.count) {
                    if (this.digits[n3] != 48) {
                        return true;
                    }
                    ++n3;
                }
                return n2 > 0 && this.digits[n2 - 1] % 2 != 0;
            }
        }
        return false;
    }

    public final void set(long l2) {
        this.set(l2, 0);
    }

    public final void set(long l2, int n2) {
        if (l2 <= 0L) {
            if (l2 == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int n3 = 19;
            while (l2 > 0L) {
                this.digits[--n3] = (byte)(48L + l2 % 10L);
                l2 /= 10L;
            }
            this.decimalAt = 19 - n3;
            int n4 = 18;
            while (this.digits[n4] == 48) {
                --n4;
            }
            this.count = n4 - n3 + 1;
            System.arraycopy(this.digits, n3, this.digits, 0, this.count);
        }
        if (n2 > 0) {
            this.round(n2);
        }
    }

    boolean fitsIntoLong(boolean bl2, boolean bl3) {
        while (this.count > 0 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        if (this.count == 0) {
            return bl2 || bl3;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.count) {
            byte by = this.digits[n2];
            byte by2 = LONG_MIN_REP[n2];
            if (by > by2) {
                return false;
            }
            if (by < by2) {
                return true;
            }
            ++n2;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl2;
    }

    public Object clone() {
        try {
            DigitList digitList = (DigitList)super.clone();
            byte[] byArray = new byte[this.digits.length];
            System.arraycopy(this.digits, 0, byArray, 0, this.digits.length);
            digitList.digits = byArray;
            return digitList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.count) {
            if (this.digits[n2] != digitList.digits[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer("0.");
        int n2 = 0;
        while (n2 < this.count) {
            stringBuffer.append((char)this.digits[n2]);
            ++n2;
        }
        stringBuffer.append("x10^");
        stringBuffer.append(this.decimalAt);
        return stringBuffer.toString();
    }
}

