/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributeEntry;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class AttributedString {
    private static final int ARRAY_SIZE_INCREMENT = 10;
    String text;
    int runArraySize;
    int runCount;
    int[] runStarts;
    Vector[] runAttributes;
    Vector[] runAttributeValues;

    int length() {
        return this.text.length();
    }

    private final void createRunAttributeDataVectors() {
        int[] nArray = new int[10];
        Vector[] vectorArray = new Vector[10];
        Vector[] vectorArray2 = new Vector[10];
        this.runStarts = nArray;
        this.runAttributes = vectorArray;
        this.runAttributeValues = vectorArray2;
        this.runArraySize = 10;
        this.runCount = 1;
    }

    private char charAt(int n2) {
        return this.text.charAt(n2);
    }

    private final int ensureRunBreak(int n2) {
        return this.ensureRunBreak(n2, true);
    }

    private final int ensureRunBreak(int n2, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        if (n2 == this.length()) {
            return this.runCount;
        }
        int n3 = 0;
        while (n3 < this.runCount && this.runStarts[n3] < n2) {
            ++n3;
        }
        if (n3 < this.runCount && this.runStarts[n3] == n2) {
            return n3;
        }
        if (this.runCount == this.runArraySize) {
            int n4 = this.runArraySize + 10;
            object3 = new int[n4];
            object2 = new Vector[n4];
            object = new Vector[n4];
            int n5 = 0;
            while (n5 < this.runArraySize) {
                object3[n5] = this.runStarts[n5];
                object2[n5] = this.runAttributes[n5];
                object[n5] = this.runAttributeValues[n5];
                ++n5;
            }
            this.runStarts = object3;
            this.runAttributes = object2;
            this.runAttributeValues = object;
            this.runArraySize = n4;
        }
        Vector vector = null;
        object3 = null;
        if (bl2) {
            object2 = this.runAttributes[n3 - 1];
            object = this.runAttributeValues[n3 - 1];
            if (object2 != null) {
                vector = (Vector)((Vector)object2).clone();
            }
            if (object != null) {
                object3 = (Vector)((Vector)object).clone();
            }
        }
        ++this.runCount;
        int n6 = this.runCount - 1;
        while (n6 > n3) {
            this.runStarts[n6] = this.runStarts[n6 - 1];
            this.runAttributes[n6] = this.runAttributes[n6 - 1];
            this.runAttributeValues[n6] = this.runAttributeValues[n6 - 1];
            --n6;
        }
        this.runStarts[n3] = n2;
        this.runAttributes[n3] = vector;
        this.runAttributeValues[n3] = object3;
        return n3;
    }

    public AttributedString(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
    }

    public AttributedCharacterIterator getIterator() {
        return this.getIterator(null, 0, this.length());
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator) {
        this(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this(attributedCharacterIterator, n2, n3, null);
    }

    AttributedString(AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        if (attributedCharacterIteratorArray == null) {
            throw new NullPointerException("Iterators must not be null");
        }
        if (attributedCharacterIteratorArray.length == 0) {
            this.text = "";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < attributedCharacterIteratorArray.length) {
                this.appendContents(stringBuffer, attributedCharacterIteratorArray[n2]);
                ++n2;
            }
            this.text = stringBuffer.toString();
            if (this.text.length() > 0) {
                int n3 = 0;
                Map map = null;
                int n4 = 0;
                while (n4 < attributedCharacterIteratorArray.length) {
                    AttributedCharacterIterator attributedCharacterIterator = attributedCharacterIteratorArray[n4];
                    int n5 = attributedCharacterIterator.getBeginIndex();
                    int n6 = attributedCharacterIterator.getEndIndex();
                    int n7 = n5;
                    while (n7 < n6) {
                        attributedCharacterIterator.setIndex(n7);
                        Map map2 = attributedCharacterIterator.getAttributes();
                        if (AttributedString.mapsDiffer(map, map2)) {
                            this.setAttributes(map2, n7 - n5 + n3);
                        }
                        map = map2;
                        n7 = attributedCharacterIterator.getRunLimit();
                    }
                    n3 += n6 - n5;
                    ++n4;
                }
            }
        }
    }

    static char access$000(AttributedString attributedString, int n2) {
        return attributedString.charAt(n2);
    }

    private void setAttributes(Map map, int n2) {
        int n3;
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int n4 = this.ensureRunBreak(n2, false);
        if (map != null && (n3 = map.size()) > 0) {
            Vector vector = new Vector(n3);
            Vector vector2 = new Vector(n3);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                vector.add(entry.getKey());
                vector2.add(entry.getValue());
            }
            this.runAttributes[n4] = vector;
            this.runAttributeValues[n4] = vector2;
        }
    }

    public void addAttributes(Map map, int n2, int n3) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 > this.length() || n2 > n3) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        if (n2 == n3) {
            if (map.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int n4 = this.ensureRunBreak(n2);
        int n5 = this.ensureRunBreak(n3);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.addAttributeRunData((AttributedCharacterIterator.Attribute)entry.getKey(), entry.getValue(), n4, n5);
        }
    }

    private boolean attributeValuesMatch(Set set, int n2, int n3) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator.next();
            if (AttributedString.valuesMatch(this.getAttribute(attribute, n2), this.getAttribute(attribute, n3))) continue;
            return false;
        }
        return true;
    }

    static boolean access$200(Object object, Object object2) {
        return AttributedString.valuesMatch(object, object2);
    }

    private static final boolean valuesMatch(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private synchronized Object getAttribute(AttributedCharacterIterator.Attribute attribute, int n2) {
        Vector vector = this.runAttributes[n2];
        Vector vector2 = this.runAttributeValues[n2];
        if (vector == null) {
            return null;
        }
        int n3 = vector.indexOf(attribute);
        if (n3 != -1) {
            return vector2.elementAt(n3);
        }
        return null;
    }

    private Object getAttributeCheckRange(AttributedCharacterIterator.Attribute attribute, int n2, int n3, int n4) {
        Object object = this.getAttribute(attribute, n2);
        if (object instanceof Annotation) {
            int n5;
            int n6;
            if (n3 > 0) {
                n6 = n2;
                n5 = this.runStarts[n6];
                while (n5 >= n3 && AttributedString.valuesMatch(object, this.getAttribute(attribute, n6 - 1))) {
                    n5 = this.runStarts[--n6];
                }
                if (n5 < n3) {
                    return null;
                }
            }
            if (n4 < (n6 = this.length())) {
                n5 = n2;
                int n7 = n5 < this.runCount - 1 ? this.runStarts[n5 + 1] : n6;
                while (n7 <= n4 && AttributedString.valuesMatch(object, this.getAttribute(attribute, n5 + 1))) {
                    int n8 = n7 = ++n5 < this.runCount - 1 ? this.runStarts[n5 + 1] : n6;
                }
                if (n7 > n4) {
                    return null;
                }
            }
        }
        return object;
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        int n2 = this.length();
        if (n2 == 0) {
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        this.addAttributeImpl(attribute, object, 0, n2);
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n2, int n3) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 > this.length() || n2 >= n3) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        this.addAttributeImpl(attribute, object, n2, n3);
    }

    private synchronized void addAttributeImpl(AttributedCharacterIterator.Attribute attribute, Object object, int n2, int n3) {
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int n4 = this.ensureRunBreak(n2);
        int n5 = this.ensureRunBreak(n3);
        this.addAttributeRunData(attribute, object, n4, n5);
    }

    private void addAttributeRunData(AttributedCharacterIterator.Attribute attribute, Object object, int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            int n5 = -1;
            if (this.runAttributes[n4] == null) {
                Vector vector = new Vector();
                Vector vector2 = new Vector();
                this.runAttributes[n4] = vector;
                this.runAttributeValues[n4] = vector2;
            } else {
                n5 = this.runAttributes[n4].indexOf(attribute);
            }
            if (n5 == -1) {
                int n6 = this.runAttributes[n4].size();
                this.runAttributes[n4].addElement(attribute);
                try {
                    this.runAttributeValues[n4].addElement(object);
                }
                catch (Exception exception) {
                    this.runAttributes[n4].setSize(n6);
                    this.runAttributeValues[n4].setSize(n6);
                }
            } else {
                this.runAttributeValues[n4].set(n5, object);
            }
            ++n4;
        }
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getIterator(attributeArray, 0, this.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n2, int n3) {
        return new AttributedStringIterator(this, attributeArray, n2, n3);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3, AttributedCharacterIterator.Attribute[] attributeArray) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException();
        }
        int n4 = attributedCharacterIterator.getBeginIndex();
        int n5 = attributedCharacterIterator.getEndIndex();
        if (n2 < n4 || n3 > n5 || n2 > n3) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        StringBuffer stringBuffer = new StringBuffer();
        attributedCharacterIterator.setIndex(n2);
        char c2 = attributedCharacterIterator.current();
        while (attributedCharacterIterator.getIndex() < n3) {
            stringBuffer.append(c2);
            c2 = attributedCharacterIterator.next();
        }
        this.text = stringBuffer.toString();
        if (n2 == n3) {
            return;
        }
        HashSet hashSet = new HashSet();
        if (attributeArray == null) {
            hashSet.addAll(attributedCharacterIterator.getAllAttributeKeys());
        } else {
            int n6 = 0;
            while (n6 < attributeArray.length) {
                hashSet.add(attributeArray[n6]);
                ++n6;
            }
            hashSet.retainAll(attributedCharacterIterator.getAllAttributeKeys());
        }
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        block2: while (iterator.hasNext()) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator.next();
            attributedCharacterIterator.setIndex(n4);
            while (attributedCharacterIterator.getIndex() < n3) {
                int n7 = attributedCharacterIterator.getRunStart(attribute);
                int n8 = attributedCharacterIterator.getRunLimit(attribute);
                Object object = attributedCharacterIterator.getAttribute(attribute);
                if (object != null) {
                    if (object instanceof Annotation) {
                        if (n7 >= n2 && n8 <= n3) {
                            this.addAttribute(attribute, object, n7 - n2, n8 - n2);
                        } else if (n8 > n3) {
                            continue block2;
                        }
                    } else {
                        if (n7 >= n3) continue block2;
                        if (n8 > n2) {
                            if (n7 < n2) {
                                n7 = n2;
                            }
                            if (n8 > n3) {
                                n8 = n3;
                            }
                            if (n7 != n8) {
                                this.addAttribute(attribute, object, n7 - n2, n8 - n2);
                            }
                        }
                    }
                }
                attributedCharacterIterator.setIndex(n8);
            }
        }
    }

    private final void appendContents(StringBuffer stringBuffer, CharacterIterator characterIterator) {
        int n2 = characterIterator.getBeginIndex();
        int n3 = characterIterator.getEndIndex();
        while (n2 < n3) {
            characterIterator.setIndex(n2++);
            stringBuffer.append(characterIterator.current());
        }
    }

    public AttributedString(String string, Map map) {
        if (string == null || map == null) {
            throw new NullPointerException();
        }
        this.text = string;
        if (string.length() == 0) {
            if (map.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        int n2 = map.size();
        if (n2 > 0) {
            this.createRunAttributeDataVectors();
            Vector vector = new Vector(n2);
            Vector vector2 = new Vector(n2);
            this.runAttributes[0] = vector;
            this.runAttributeValues[0] = vector2;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                vector.addElement(entry.getKey());
                vector2.addElement(entry.getValue());
            }
        }
    }

    private static boolean mapsDiffer(Map map, Map map2) {
        if (map == null) {
            return map2 != null && map2.size() > 0;
        }
        return !map.equals(map2);
    }

    static boolean access$300(AttributedString attributedString, Set set, int n2, int n3) {
        return attributedString.attributeValuesMatch(set, n2, n3);
    }

    static Object access$100(AttributedString attributedString, AttributedCharacterIterator.Attribute attribute, int n2) {
        return attributedString.getAttribute(attribute, n2);
    }

    static Object access$400(AttributedString attributedString, AttributedCharacterIterator.Attribute attribute, int n2, int n3, int n4) {
        return attributedString.getAttributeCheckRange(attribute, n2, n3, n4);
    }

    private final class AttributeMap
    extends AbstractMap {
        int runIndex;
        int beginIndex;
        int endIndex;
        private final AttributedString this$0;

        AttributeMap(AttributedString attributedString, int n2, int n3, int n4) {
            this.this$0 = attributedString;
            this.runIndex = n2;
            this.beginIndex = n3;
            this.endIndex = n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set entrySet() {
            HashSet hashSet = new HashSet();
            AttributedString attributedString = this.this$0;
            synchronized (attributedString) {
                int n2 = this.this$0.runAttributes[this.runIndex].size();
                int n3 = 0;
                while (n3 < n2) {
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)this.this$0.runAttributes[this.runIndex].get(n3);
                    Object object = this.this$0.runAttributeValues[this.runIndex].get(n3);
                    if (!(object instanceof Annotation) || (object = AttributedString.access$400(this.this$0, attribute, this.runIndex, this.beginIndex, this.endIndex)) != null) {
                        AttributeEntry attributeEntry = new AttributeEntry(attribute, object);
                        hashSet.add(attributeEntry);
                    }
                    ++n3;
                }
            }
            return hashSet;
        }

        public Object get(Object object) {
            return AttributedString.access$400(this.this$0, (AttributedCharacterIterator.Attribute)object, this.runIndex, this.beginIndex, this.endIndex);
        }
    }

    private final class AttributedStringIterator
    implements AttributedCharacterIterator {
        private int beginIndex;
        private int endIndex;
        private AttributedCharacterIterator.Attribute[] relevantAttributes;
        private int currentIndex;
        private int currentRunIndex;
        private int currentRunStart;
        private int currentRunLimit;
        private final AttributedString this$0;

        public char current() {
            if (this.currentIndex == this.endIndex) {
                return '\uffff';
            }
            return AttributedString.access$000(this.this$0, this.currentIndex);
        }

        public char first() {
            return this.internalSetIndex(this.beginIndex);
        }

        public char last() {
            if (this.endIndex == this.beginIndex) {
                return this.internalSetIndex(this.endIndex);
            }
            return this.internalSetIndex(this.endIndex - 1);
        }

        public char next() {
            if (this.currentIndex < this.endIndex) {
                return this.internalSetIndex(this.currentIndex + 1);
            }
            return '\uffff';
        }

        public char previous() {
            if (this.currentIndex > this.beginIndex) {
                return this.internalSetIndex(this.currentIndex - 1);
            }
            return '\uffff';
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public int getRunLimit() {
            return this.currentRunLimit;
        }

        public int getRunStart() {
            return this.currentRunStart;
        }

        public int hashCode() {
            return this.this$0.text.hashCode() ^ this.currentIndex ^ this.beginIndex ^ this.endIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRunInfo() {
            if (this.currentIndex == this.endIndex) {
                this.currentRunStart = this.currentRunLimit = this.endIndex;
                this.currentRunIndex = -1;
            } else {
                AttributedString attributedString = this.this$0;
                synchronized (attributedString) {
                    int n2 = -1;
                    while (n2 < this.this$0.runCount - 1 && this.this$0.runStarts[n2 + 1] <= this.currentIndex) {
                        ++n2;
                    }
                    this.currentRunIndex = n2;
                    if (n2 >= 0) {
                        this.currentRunStart = this.this$0.runStarts[n2];
                        if (this.currentRunStart < this.beginIndex) {
                            this.currentRunStart = this.beginIndex;
                        }
                    } else {
                        this.currentRunStart = this.beginIndex;
                    }
                    if (n2 < this.this$0.runCount - 1) {
                        this.currentRunLimit = this.this$0.runStarts[n2 + 1];
                        if (this.currentRunLimit > this.endIndex) {
                            this.currentRunLimit = this.endIndex;
                        }
                    } else {
                        this.currentRunLimit = this.endIndex;
                    }
                }
            }
        }

        private char internalSetIndex(int n2) {
            this.currentIndex = n2;
            if (n2 < this.currentRunStart || n2 >= this.currentRunLimit) {
                this.updateRunInfo();
            }
            if (this.currentIndex == this.endIndex) {
                return '\uffff';
            }
            return AttributedString.access$000(this.this$0, n2);
        }

        public char setIndex(int n2) {
            if (n2 < this.beginIndex || n2 > this.endIndex) {
                throw new IllegalArgumentException("Invalid index");
            }
            return this.internalSetIndex(n2);
        }

        public Object clone() {
            try {
                AttributedStringIterator attributedStringIterator = (AttributedStringIterator)super.clone();
                return attributedStringIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AttributedStringIterator)) {
                return false;
            }
            AttributedStringIterator attributedStringIterator = (AttributedStringIterator)object;
            if (this.this$0 != attributedStringIterator.getString()) {
                return false;
            }
            return this.currentIndex == attributedStringIterator.currentIndex && this.beginIndex == attributedStringIterator.beginIndex && this.endIndex == attributedStringIterator.endIndex;
        }

        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (this.currentRunLimit == this.endIndex || this.currentRunIndex == -1) {
                return this.currentRunLimit;
            }
            Object object = this.getAttribute(attribute);
            int n2 = this.currentRunLimit;
            int n3 = this.currentRunIndex;
            while (n2 < this.endIndex && AttributedString.access$200(object, AttributedString.access$100(this.this$0, attribute, n3 + 1))) {
                int n4 = n2 = ++n3 < this.this$0.runCount - 1 ? this.this$0.runStarts[n3 + 1] : this.endIndex;
            }
            if (n2 > this.endIndex) {
                n2 = this.endIndex;
            }
            return n2;
        }

        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (this.currentRunStart == this.beginIndex || this.currentRunIndex == -1) {
                return this.currentRunStart;
            }
            Object object = this.getAttribute(attribute);
            int n2 = this.currentRunStart;
            int n3 = this.currentRunIndex;
            while (n2 > this.beginIndex && AttributedString.access$200(object, AttributedString.access$100(this.this$0, attribute, n3 - 1))) {
                n2 = this.this$0.runStarts[--n3];
            }
            if (n2 < this.beginIndex) {
                n2 = this.beginIndex;
            }
            return n2;
        }

        private AttributedString getString() {
            return this.this$0;
        }

        public Map getAttributes() {
            if (this.this$0.runAttributes == null || this.currentRunIndex == -1 || this.this$0.runAttributes[this.currentRunIndex] == null) {
                return new Hashtable();
            }
            return new AttributeMap(this.this$0, this.currentRunIndex, this.beginIndex, this.endIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set getAllAttributeKeys() {
            if (this.this$0.runAttributes == null) {
                return new HashSet();
            }
            AttributedString attributedString = this.this$0;
            synchronized (attributedString) {
                HashSet hashSet = new HashSet();
                int n2 = 0;
                while (n2 < this.this$0.runCount) {
                    Vector vector;
                    if (this.this$0.runStarts[n2] < this.endIndex && (n2 == this.this$0.runCount - 1 || this.this$0.runStarts[n2 + 1] > this.beginIndex) && (vector = this.this$0.runAttributes[n2]) != null) {
                        int n3 = vector.size();
                        while (n3-- > 0) {
                            hashSet.add(vector.get(n3));
                        }
                    }
                    ++n2;
                }
                return hashSet;
            }
        }

        public int getRunLimit(Set set) {
            if (this.currentRunLimit == this.endIndex || this.currentRunIndex == -1) {
                return this.currentRunLimit;
            }
            int n2 = this.currentRunLimit;
            int n3 = this.currentRunIndex;
            while (n2 < this.endIndex && AttributedString.access$300(this.this$0, set, this.currentRunIndex, n3 + 1)) {
                int n4 = n2 = ++n3 < this.this$0.runCount - 1 ? this.this$0.runStarts[n3 + 1] : this.endIndex;
            }
            if (n2 > this.endIndex) {
                n2 = this.endIndex;
            }
            return n2;
        }

        public int getRunStart(Set set) {
            if (this.currentRunStart == this.beginIndex || this.currentRunIndex == -1) {
                return this.currentRunStart;
            }
            int n2 = this.currentRunStart;
            int n3 = this.currentRunIndex;
            while (n2 > this.beginIndex && AttributedString.access$300(this.this$0, set, this.currentRunIndex, n3 - 1)) {
                n2 = this.this$0.runStarts[--n3];
            }
            if (n2 < this.beginIndex) {
                n2 = this.beginIndex;
            }
            return n2;
        }

        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            int n2 = this.currentRunIndex;
            if (n2 < 0) {
                return null;
            }
            return AttributedString.access$400(this.this$0, attribute, n2, this.beginIndex, this.endIndex);
        }

        AttributedStringIterator(AttributedString attributedString, AttributedCharacterIterator.Attribute[] attributeArray, int n2, int n3) {
            this.this$0 = attributedString;
            if (n2 < 0 || n2 > n3 || n3 > attributedString.length()) {
                throw new IllegalArgumentException("Invalid substring range");
            }
            this.beginIndex = n2;
            this.endIndex = n3;
            this.currentIndex = n2;
            this.updateRunInfo();
            if (attributeArray != null) {
                this.relevantAttributes = (AttributedCharacterIterator.Attribute[])attributeArray.clone();
            }
        }
    }
}

