/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import sun.misc.CharacterEncoder;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificatePoliciesExtension;
import sun.security.x509.CertificatePolicyId;
import sun.security.x509.CertificatePolicySet;
import sun.security.x509.DNSName;
import sun.security.x509.EDIPartyName;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralSubtree;
import sun.security.x509.GeneralSubtrees;
import sun.security.x509.IPAddressName;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.OIDName;
import sun.security.x509.OtherName;
import sun.security.x509.PolicyInformation;
import sun.security.x509.PrivateKeyUsageExtension;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.URIName;
import sun.security.x509.X400Address;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509Key;

public class X509CertSelector
implements CertSelector {
    private static final Debug debug = Debug.getInstance("certpath");
    private BigInteger serialNumber;
    private X500Name issuer;
    private X500Name subject;
    private byte[] subjectKeyID;
    private byte[] authorityKeyID;
    private Date certificateValid;
    private Date privateKeyValid;
    private ObjectIdentifier subjectPublicKeyAlgID;
    private PublicKey subjectPublicKey;
    private byte[] subjectPublicKeyBytes;
    private boolean[] keyUsage;
    private Set keyPurposeSet;
    private HashSet subjectAlternativeNames;
    private HashSet subjectAlternativeGeneralNames;
    private CertificatePolicySet policy;
    private Set policySet;
    private HashSet pathToNames;
    private HashSet pathToGeneralNames;
    private NameConstraintsExtension nc;
    private byte[] ncBytes;
    private int basicConstraints = -1;
    private X509Certificate x509Cert;
    private boolean matchAllSubjectAltNames = true;
    private static final Boolean falseBoolean = new Boolean(false);
    private static final int PRIVATE_KEY_USAGE_ID = 0;
    private static final int SUBJECT_ALT_NAME_ID = 1;
    private static final int NAME_CONSTRAINTS_ID = 2;
    private static final int CERT_POLICIES_ID = 3;
    private static final int EXTENDED_KEY_USAGE_ID = 4;
    private static final int NUM_OF_EXTENSIONS = 5;
    private static final String[] EXTENSION_OIDS = new String[5];
    static final int NAME_ANY = 0;
    static final int NAME_RFC822 = 1;
    static final int NAME_DNS = 2;
    static final int NAME_X400 = 3;
    static final int NAME_DIRECTORY = 4;
    static final int NAME_EDI = 5;
    static final int NAME_URI = 6;
    static final int NAME_IP = 7;
    static final int NAME_OID = 8;

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    static {
        X509CertSelector.EXTENSION_OIDS[0] = "2.5.29.16";
        X509CertSelector.EXTENSION_OIDS[1] = "2.5.29.17";
        X509CertSelector.EXTENSION_OIDS[2] = "2.5.29.30";
        X509CertSelector.EXTENSION_OIDS[3] = "2.5.29.32";
        X509CertSelector.EXTENSION_OIDS[4] = "2.5.29.37";
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllSubjectAltNames;
    }

    public byte[] getAuthorityKeyIdentifier() {
        if (this.authorityKeyID == null) {
            return null;
        }
        return (byte[])this.authorityKeyID.clone();
    }

    public byte[] getIssuerAsBytes() throws IOException {
        return this.issuer == null ? null : this.issuer.getEncoded();
    }

    public byte[] getNameConstraints() {
        if (this.ncBytes == null) {
            return null;
        }
        return (byte[])this.ncBytes.clone();
    }

    public byte[] getSubjectAsBytes() throws IOException {
        return this.subject == null ? null : this.subject.getEncoded();
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.subjectKeyID == null) {
            return null;
        }
        return (byte[])this.subjectKeyID.clone();
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage == null) {
            return null;
        }
        return (boolean[])this.keyUsage.clone();
    }

    public void setBasicConstraints(int n2) {
        if (n2 < -2) {
            throw new IllegalArgumentException("basic constraints less than -2");
        }
        this.basicConstraints = n2;
    }

    public void addPathToName(int n2, byte[] byArray) throws IOException {
        this.addPathToNameInternal(n2, byArray.clone());
    }

    public void addSubjectAlternativeName(int n2, byte[] byArray) throws IOException {
        this.addSubjectAlternativeNameInternal(n2, byArray.clone());
    }

    public void setMatchAllSubjectAltNames(boolean bl2) {
        this.matchAllSubjectAltNames = bl2;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.authorityKeyID = (byte[])(byArray == null ? null : (byte[])byArray.clone());
    }

    public void setIssuer(byte[] byArray) throws IOException {
        this.issuer = byArray == null ? null : new X500Name(byArray);
    }

    public void setNameConstraints(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.ncBytes = null;
            this.nc = null;
        } else {
            this.ncBytes = (byte[])byArray.clone();
            this.nc = new NameConstraintsExtension(falseBoolean, byArray);
        }
    }

    public void setSubject(byte[] byArray) throws IOException {
        this.subject = byArray == null ? null : new X500Name(byArray);
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.subjectKeyID = (byte[])(byArray == null ? null : (byte[])byArray.clone());
    }

    public void setSubjectPublicKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.subjectPublicKey = null;
            this.subjectPublicKeyBytes = null;
        } else {
            this.subjectPublicKeyBytes = (byte[])byArray.clone();
            this.subjectPublicKey = X509Key.parse(new DerValue(this.subjectPublicKeyBytes));
        }
    }

    public void setKeyUsage(boolean[] blArray) {
        this.keyUsage = (boolean[])(blArray == null ? null : (boolean[])blArray.clone());
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.subjectAlternativeNames != null) {
                this.subjectAlternativeNames = new HashSet(this.subjectAlternativeNames);
                this.subjectAlternativeGeneralNames = new HashSet(this.subjectAlternativeGeneralNames);
            }
            if (this.pathToNames != null) {
                this.pathToNames = new HashSet(this.pathToNames);
                this.pathToGeneralNames = new HashSet(this.pathToGeneralNames);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    private void addPathToNameInternal(int n2, Object object) throws IOException {
        GeneralNameInterface generalNameInterface = X509CertSelector.makeGeneralNameInterface(n2, object);
        if (this.pathToNames == null) {
            this.pathToNames = new HashSet();
        }
        if (this.pathToGeneralNames == null) {
            this.pathToGeneralNames = new HashSet();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(n2));
        arrayList.add(object);
        this.pathToNames.add(arrayList);
        this.pathToGeneralNames.add(generalNameInterface);
    }

    private void addSubjectAlternativeNameInternal(int n2, Object object) throws IOException {
        GeneralNameInterface generalNameInterface = X509CertSelector.makeGeneralNameInterface(n2, object);
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNames = new HashSet();
        }
        if (this.subjectAlternativeGeneralNames == null) {
            this.subjectAlternativeGeneralNames = new HashSet();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(n2));
        arrayList.add(object);
        this.subjectAlternativeNames.add(arrayList);
        this.subjectAlternativeGeneralNames.add(generalNameInterface);
    }

    public String getIssuerAsString() {
        return this.issuer == null ? null : this.issuer.getRFC2253Name();
    }

    public String getSubjectAsString() {
        return this.subject == null ? null : this.subject.getRFC2253Name();
    }

    public String getSubjectPublicKeyAlgID() {
        if (this.subjectPublicKeyAlgID == null) {
            return null;
        }
        return this.subjectPublicKeyAlgID.toString();
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CertSelector: [\n");
        if (this.x509Cert != null) {
            stringBuffer.append("  Certificate: " + this.x509Cert.toString() + "\n");
        }
        if (this.serialNumber != null) {
            stringBuffer.append("  Serial Number: " + this.serialNumber.toString() + "\n");
        }
        if (this.issuer != null) {
            stringBuffer.append("  Issuer: " + this.getIssuerAsString() + "\n");
        }
        if (this.subject != null) {
            stringBuffer.append("  Subject: " + this.getSubjectAsString() + "\n");
        }
        stringBuffer.append("  matchAllSubjectAltNames flag: " + String.valueOf(this.matchAllSubjectAltNames) + "\n");
        if (this.subjectAlternativeNames != null) {
            stringBuffer.append("  SubjectAlternativeNames:\n");
            object = this.subjectAlternativeNames.iterator();
            while (object.hasNext()) {
                List list = (List)object.next();
                stringBuffer.append("    type " + list.get(0) + ", name " + list.get(1) + "\n");
            }
        }
        if (this.subjectKeyID != null) {
            object = new HexDumpEncoder();
            stringBuffer.append("  Subject Key Identifier: " + ((CharacterEncoder)object).encodeBuffer(this.subjectKeyID) + "\n");
        }
        if (this.authorityKeyID != null) {
            object = new HexDumpEncoder();
            stringBuffer.append("  Authority Key Identifier: " + ((CharacterEncoder)object).encodeBuffer(this.authorityKeyID) + "\n");
        }
        if (this.certificateValid != null) {
            stringBuffer.append("  Certificate Valid: " + this.certificateValid.toString() + "\n");
        }
        if (this.privateKeyValid != null) {
            stringBuffer.append("  Private Key Valid: " + this.privateKeyValid.toString() + "\n");
        }
        if (this.subjectPublicKeyAlgID != null) {
            stringBuffer.append("  Subject Public Key AlgID: " + this.subjectPublicKeyAlgID.toString() + "\n");
        }
        if (this.subjectPublicKey != null) {
            stringBuffer.append("  Subject Public Key: " + this.subjectPublicKey.toString() + "\n");
        }
        if (this.keyUsage != null) {
            stringBuffer.append("  Key Usage: " + X509CertSelector.keyUsageToString(this.keyUsage) + "\n");
        }
        if (this.keyPurposeSet != null) {
            stringBuffer.append("  Extended Key Usage: " + this.keyPurposeSet.toString() + "\n");
        }
        if (this.policy != null) {
            stringBuffer.append("  Policy: " + this.policy.toString() + "\n");
        }
        if (this.pathToNames != null) {
            stringBuffer.append("  Path to names:\n");
            object = this.pathToGeneralNames.iterator();
            while (object.hasNext()) {
                stringBuffer.append("    " + object.next() + "\n");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addPathToName(int n2, String string) throws IOException {
        this.addPathToNameInternal(n2, string);
    }

    public void addSubjectAlternativeName(int n2, String string) throws IOException {
        this.addSubjectAlternativeNameInternal(n2, string);
    }

    public void setIssuer(String string) throws IOException {
        this.issuer = string == null ? null : new X500Name(string, "RFC2253");
    }

    public void setSubject(String string) throws IOException {
        this.subject = string == null ? null : new X500Name(string, "RFC2253");
    }

    public void setSubjectPublicKeyAlgID(String string) throws IOException {
        this.subjectPublicKeyAlgID = string == null ? null : new ObjectIdentifier(string);
    }

    private static String keyUsageToString(boolean[] blArray) {
        String string = "KeyUsage [\n";
        try {
            if (blArray[0]) {
                string = string + "  DigitalSignature\n";
            }
            if (blArray[1]) {
                string = string + "  Non_repudiation\n";
            }
            if (blArray[2]) {
                string = string + "  Key_Encipherment\n";
            }
            if (blArray[3]) {
                string = string + "  Data_Encipherment\n";
            }
            if (blArray[4]) {
                string = string + "  Key_Agreement\n";
            }
            if (blArray[5]) {
                string = string + "  Key_CertSign\n";
            }
            if (blArray[6]) {
                string = string + "  Crl_Sign\n";
            }
            if (blArray[7]) {
                string = string + "  Encipher_Only\n";
            }
            if (blArray[8]) {
                string = string + "  Decipher_Only\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        string = string + "]\n";
        return string;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public void setSubjectPublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            this.subjectPublicKey = null;
            this.subjectPublicKeyBytes = null;
        } else {
            this.subjectPublicKey = publicKey;
            this.subjectPublicKeyBytes = publicKey.getEncoded();
        }
    }

    public boolean match(Certificate certificate) {
        Object object;
        Object object2;
        boolean bl2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (debug != null) {
            debug.println("X509CertSelector.match(SN: " + x509Certificate.getSerialNumber().toString(16) + "\n  Issuer: " + x509Certificate.getIssuerDN() + "\n  Subject: " + x509Certificate.getSubjectDN() + ")");
        }
        if (this.x509Cert != null && !this.x509Cert.equals(x509Certificate)) {
            if (debug != null) {
                debug.println("X509CertSelector.match: certs don't match");
            }
            return false;
        }
        if (this.serialNumber != null && !this.serialNumber.equals(x509Certificate.getSerialNumber())) {
            if (debug != null) {
                debug.println("X509CertSelector.match: serial numbers don't match");
            }
            return false;
        }
        if (this.issuer != null && !this.issuer.equals(x509Certificate.getIssuerX500Principal())) {
            if (debug != null) {
                debug.println("X509CertSelector.match: issuer DNs don't match");
            }
            return false;
        }
        if (this.subject != null && !this.subject.equals(x509Certificate.getSubjectX500Principal())) {
            if (debug != null) {
                debug.println("X509CertSelector.match: subject DNs don't match");
            }
            return false;
        }
        if (this.subjectKeyID != null) {
            try {
                object6 = x509Certificate.getExtensionValue("2.5.29.14");
                if (object6 == null) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: no subject key ID extension");
                    }
                    return false;
                }
                object5 = new DerInputStream((byte[])object6);
                object4 = ((DerInputStream)object5).getOctetString();
                if (object4 == null || !Arrays.equals(this.subjectKeyID, object4)) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: subject key IDs don't match");
                    }
                    return false;
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: exception in subject key ID check");
                }
                return false;
            }
        }
        if (this.authorityKeyID != null) {
            try {
                object6 = x509Certificate.getExtensionValue("2.5.29.35");
                if (object6 == null) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: no authority key ID extension");
                    }
                    return false;
                }
                object5 = new DerInputStream((byte[])object6);
                object4 = ((DerInputStream)object5).getOctetString();
                if (object4 == null || !Arrays.equals(this.authorityKeyID, object4)) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: authority key IDs don't match");
                    }
                    return false;
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: exception in authority key ID check");
                }
                return false;
            }
        }
        if (this.certificateValid != null) {
            try {
                x509Certificate.checkValidity(this.certificateValid);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: certificate not within validity date");
                }
                return false;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: certificate not within validity date");
                }
                return false;
            }
        }
        if (this.privateKeyValid != null) {
            object6 = null;
            try {
                object6 = (PrivateKeyUsageExtension)X509CertSelector.getExtensionObject(x509Certificate, 0);
                if (object6 != null) {
                    ((PrivateKeyUsageExtension)object6).valid(this.privateKeyValid);
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                if (debug != null) {
                    object4 = "n/a";
                    try {
                        Date date = (Date)((PrivateKeyUsageExtension)object6).get("not_after");
                        object4 = date.toString();
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                    debug.println("X509CertSelector.match: private key usage not within validity date; ext.NOT_After: " + (String)object4 + "; X509CertSelector: " + this.toString());
                    certificateExpiredException.printStackTrace();
                }
                return false;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                if (debug != null) {
                    String string = "n/a";
                    try {
                        Date date = (Date)((PrivateKeyUsageExtension)object6).get("not_before");
                        string = date.toString();
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                    debug.println("X509CertSelector.match: private key usage not within validity date; ext.NOT_BEFORE: " + string + "; X509CertSelector: " + this.toString());
                    certificateNotYetValidException.printStackTrace();
                }
                return false;
            }
            catch (CertificateException certificateException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: CertificateException in private key usage check; X509CertSelector: " + this.toString());
                    certificateException.printStackTrace();
                }
                return false;
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: IOException in private key usage check; X509CertSelector: " + this.toString());
                    iOException.printStackTrace();
                }
                return false;
            }
        }
        if (this.subjectPublicKeyAlgID != null) {
            try {
                object6 = x509Certificate.getPublicKey().getEncoded();
                object5 = new DerValue((byte[])object6);
                if (((DerValue)object5).tag != 48) {
                    throw new IOException("invalid key format");
                }
                object4 = AlgorithmId.parse(((DerValue)object5).data.getDerValue());
                if (debug != null) {
                    debug.println("X509CertSelector.match: subjectPublicKeyAlgID = " + this.subjectPublicKeyAlgID + ", xcert subjectPublicKeyAlgID = " + object4.getOID());
                }
                if (!this.subjectPublicKeyAlgID.equals(object4.getOID())) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: subject public key alg IDs don't match");
                    }
                    return false;
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: IOException in subject public key algorithm OID check");
                }
                return false;
            }
        }
        if (this.subjectPublicKeyBytes != null && !Arrays.equals(this.subjectPublicKeyBytes, (byte[])(object6 = x509Certificate.getPublicKey().getEncoded()))) {
            if (debug != null) {
                debug.println("X509CertSelector.match: subject public keys don't match");
            }
            return false;
        }
        if (this.keyUsage != null && (object6 = (Object)x509Certificate.getKeyUsage()) != null) {
            int n2 = 0;
            while (n2 < this.keyUsage.length) {
                if (this.keyUsage[n2] && (n2 >= ((byte[])object6).length || object6[n2] == false)) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: key usage bits don't match");
                    }
                    return false;
                }
                ++n2;
            }
        }
        if (this.keyPurposeSet != null && !this.keyPurposeSet.isEmpty()) {
            try {
                object6 = (ExtendedKeyUsageExtension)X509CertSelector.getExtensionObject(x509Certificate, 4);
                if (object6 != null) {
                    Vector vector = (Vector)((ExtendedKeyUsageExtension)object6).get("usages");
                    object4 = new HashSet();
                    object3 = this.keyPurposeSet.iterator();
                    while (object3.hasNext()) {
                        object4.add(new ObjectIdentifier((String)object3.next()));
                    }
                    if (!vector.containsAll((Collection)object4)) {
                        if (debug != null) {
                            debug.println("X509CertSelector.match: cert failed extendedKeyUsage criterion");
                        }
                        return false;
                    }
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: IOException in extended key usage check");
                }
                return false;
            }
        }
        if (this.subjectAlternativeNames != null && this.subjectAlternativeNames.size() != 0) {
            try {
                object6 = (SubjectAlternativeNameExtension)X509CertSelector.getExtensionObject(x509Certificate, 1);
                if (object6 == null) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: no subject alternative name extension");
                    }
                    return false;
                }
                Vector vector = (Vector)((SubjectAlternativeNameExtension)object6).get("subject_name");
                object4 = this.subjectAlternativeGeneralNames.iterator();
                while (object4.hasNext()) {
                    object3 = (GeneralNameInterface)object4.next();
                    bl2 = false;
                    object2 = vector.elements();
                    while (object2.hasMoreElements() && !bl2) {
                        object = ((GeneralName)object2.nextElement()).getName();
                        bl2 = object.equals(object3);
                    }
                    if (!(bl2 || !this.matchAllSubjectAltNames && object4.hasNext())) {
                        if (debug != null) {
                            debug.println("X509CertSelector.match: subject alternative name " + object3 + " not found");
                        }
                        return false;
                    }
                    if (!bl2 || this.matchAllSubjectAltNames) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: IOException in subject alternative name check");
                }
                return false;
            }
        }
        if (this.nc != null) {
            try {
                if (!this.nc.verify(x509Certificate)) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: name constraints not satisfied");
                    }
                    return false;
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: IOException in name constraints check");
                }
                return false;
            }
        }
        if (this.policy != null) {
            try {
                object6 = (CertificatePoliciesExtension)X509CertSelector.getExtensionObject(x509Certificate, 3);
                if (object6 == null) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: no certificate policy extension");
                    }
                    return false;
                }
                Vector vector = (Vector)((CertificatePoliciesExtension)object6).get("policies");
                object4 = new Vector(vector.size());
                object3 = vector.elements();
                while (object3.hasMoreElements()) {
                    object4.addElement(((PolicyInformation)object3.nextElement()).getPolicyIdentifier());
                }
                if (this.policy != null) {
                    bl2 = false;
                    if (this.policy.getCertPolicyIds().isEmpty()) {
                        if (object4.isEmpty()) {
                            if (debug != null) {
                                debug.println("X509CertSelector.match: cert failed policyAny criterion");
                            }
                            return false;
                        }
                    } else {
                        object2 = this.policy.getCertPolicyIds().iterator();
                        while (object2.hasNext() && !bl2) {
                            if (!object4.contains(object2.next())) continue;
                            bl2 = true;
                        }
                        if (!bl2) {
                            if (debug != null) {
                                debug.println("X509CertSelector.match: cert failed policyAny criterion");
                            }
                            return false;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: IOException in certificate policy ID check");
                }
                return false;
            }
        }
        try {
            object6 = (NameConstraintsExtension)X509CertSelector.getExtensionObject(x509Certificate, 2);
            if (this.pathToNames != null && object6 != null) {
                if (Debug.isOn("certpath")) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match pathToNames:\n");
                    }
                    Iterator iterator = this.pathToGeneralNames.iterator();
                    while (iterator.hasNext()) {
                        if (debug == null) continue;
                        debug.println("    " + iterator.next() + "\n");
                    }
                }
                GeneralSubtrees generalSubtrees = (GeneralSubtrees)((NameConstraintsExtension)object6).get("permitted_subtrees");
                object4 = (GeneralSubtrees)((NameConstraintsExtension)object6).get("excluded_subtrees");
                if (object4 != null) {
                    object3 = object4.elements();
                    while (object3.hasMoreElements()) {
                        GeneralSubtree generalSubtree = (GeneralSubtree)object3.nextElement();
                        object2 = generalSubtree.getName().getName();
                        object = this.pathToGeneralNames.iterator();
                        while (object.hasNext()) {
                            GeneralNameInterface generalNameInterface = (GeneralNameInterface)object.next();
                            if (object2.getType() != generalNameInterface.getType()) continue;
                            switch (generalNameInterface.constrains((GeneralNameInterface)object2)) {
                                case 0: 
                                case 2: {
                                    if (debug != null) {
                                        debug.println("X509CertSelector.match: name constraints inhibit path to specified name");
                                    }
                                    if (debug != null) {
                                        debug.println("X509CertSelector.match: excluded name: " + generalNameInterface);
                                    }
                                    return false;
                                }
                            }
                        }
                    }
                }
                if (generalSubtrees != null) {
                    object3 = this.pathToGeneralNames.iterator();
                    while (object3.hasNext()) {
                        GeneralNameInterface generalNameInterface = (GeneralNameInterface)object3.next();
                        object2 = generalSubtrees.elements();
                        boolean bl3 = false;
                        boolean bl4 = false;
                        String string = "";
                        while (object2.hasMoreElements() && !bl3) {
                            GeneralSubtree generalSubtree = (GeneralSubtree)object2.nextElement();
                            GeneralNameInterface generalNameInterface2 = generalSubtree.getName().getName();
                            if (generalNameInterface2.getType() != generalNameInterface.getType()) continue;
                            bl4 = true;
                            string = string + "  " + generalNameInterface2;
                            switch (generalNameInterface.constrains(generalNameInterface2)) {
                                case 0: 
                                case 2: {
                                    bl3 = true;
                                    break;
                                }
                            }
                        }
                        if (bl3 || !bl4) continue;
                        if (debug != null) {
                            debug.println("X509CertSelector.match: name constraints inhibit path to specified name; permitted names of type " + generalNameInterface.getType() + ": " + string);
                        }
                        return false;
                    }
                }
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("X509CertSelector.match: IOException in name constraints check");
            }
            return false;
        }
        if (this.basicConstraints != -1) {
            int n3 = x509Certificate.getBasicConstraints();
            if (this.basicConstraints == -2) {
                if (n3 != -1) {
                    if (debug != null) {
                        debug.println("X509CertSelector.match: not an EE cert");
                    }
                    return false;
                }
            } else if (n3 < this.basicConstraints) {
                if (debug != null) {
                    debug.println("X509CertSelector.match: maxPathLen too small (" + n3 + " < " + this.basicConstraints + ")");
                }
                return false;
            }
        }
        if (debug != null) {
            debug.println("X509CertSelector.match returning: true");
        }
        return true;
    }

    public X509Certificate getCertificate() {
        return this.x509Cert;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.x509Cert = x509Certificate;
    }

    public Collection getPathToNames() {
        if (this.pathToNames == null) {
            return null;
        }
        return X509CertSelector.cloneNames(this.pathToNames);
    }

    public Collection getSubjectAlternativeNames() {
        if (this.subjectAlternativeNames == null) {
            return null;
        }
        return X509CertSelector.cloneNames(this.subjectAlternativeNames);
    }

    public void setPathToNames(Collection collection) throws IOException {
        if (collection == null) {
            this.pathToNames = null;
            this.pathToGeneralNames = null;
        } else {
            if (collection.size() == 0) {
                this.pathToNames = null;
                this.pathToGeneralNames = null;
                return;
            }
            HashSet hashSet = X509CertSelector.cloneAndCheckNames(collection);
            this.pathToGeneralNames = X509CertSelector.parseNames(hashSet);
            this.pathToNames = hashSet;
        }
    }

    public void setSubjectAlternativeNames(Collection collection) throws IOException {
        if (collection == null) {
            this.subjectAlternativeNames = null;
            this.subjectAlternativeGeneralNames = null;
        } else {
            if (collection.size() == 0) {
                this.subjectAlternativeNames = null;
                this.subjectAlternativeGeneralNames = null;
                return;
            }
            HashSet hashSet = X509CertSelector.cloneAndCheckNames(collection);
            this.subjectAlternativeGeneralNames = X509CertSelector.parseNames(hashSet);
            this.subjectAlternativeNames = hashSet;
        }
    }

    public Date getCertificateValid() {
        if (this.certificateValid == null) {
            return null;
        }
        return (Date)this.certificateValid.clone();
    }

    public Date getPrivateKeyValid() {
        if (this.privateKeyValid == null) {
            return null;
        }
        return (Date)this.privateKeyValid.clone();
    }

    public void setCertificateValid(Date date) {
        this.certificateValid = date == null ? null : (Date)date.clone();
    }

    public void setPrivateKeyValid(Date date) {
        this.privateKeyValid = date == null ? null : (Date)date.clone();
    }

    public Set getExtendedKeyUsage() {
        return this.keyPurposeSet;
    }

    public Set getPolicy() {
        return this.policySet;
    }

    public void setExtendedKeyUsage(Set set) throws IOException {
        if (set == null) {
            set = null;
        } else {
            this.keyPurposeSet = Collections.unmodifiableSet(new HashSet(set));
        }
    }

    public void setPolicy(Set set) throws IOException {
        if (set == null) {
            this.policySet = null;
            this.policy = null;
        } else {
            Set set2 = Collections.unmodifiableSet(new HashSet(set));
            Iterator iterator = set2.iterator();
            Vector vector = new Vector();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof String)) {
                    throw new IOException("non String in certPolicySet");
                }
                vector.add(new CertificatePolicyId(new ObjectIdentifier((String)object)));
            }
            this.policySet = set2;
            this.policy = new CertificatePolicySet(vector);
        }
    }

    static boolean equalNames(Collection collection, Collection collection2) {
        if (collection == null && collection2 == null) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        return collection.equals(collection2);
    }

    private static HashSet cloneAndCheckNames(Collection collection) throws IOException {
        Object object;
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof List)) {
                throw new IOException("expected a List");
            }
            hashSet.add(new ArrayList((List)object));
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            if (object.size() != 2) {
                throw new IOException("name list size not 2");
            }
            Object object2 = object.get(0);
            if (!(object2 instanceof Integer)) {
                throw new IOException("expected an Integer");
            }
            int n2 = (Integer)object2;
            if (n2 < 0 || n2 > 8) {
                throw new IOException("name type not 0-8");
            }
            Object object3 = object.get(1);
            if (!(object3 instanceof byte[]) && !(object3 instanceof String)) {
                if (debug != null) {
                    debug.println("X509CertSelector.cloneAndCheckNames() name not byte array");
                }
                throw new IOException("name not byte array or String");
            }
            if (!(object3 instanceof byte[])) continue;
            object.set(1, ((byte[])object3).clone());
        }
        return hashSet;
    }

    private static HashSet cloneNames(Collection collection) {
        try {
            return X509CertSelector.cloneAndCheckNames(collection);
        }
        catch (IOException iOException) {
            throw new RuntimeException("cloneNames encountered IOException: " + iOException.getMessage());
        }
    }

    private static HashSet parseNames(Collection collection) throws IOException {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof List)) {
                throw new IOException("expected List");
            }
            List list = (List)object;
            if (list.size() != 2) {
                throw new IOException("name list size not 2");
            }
            object = list.get(0);
            if (!(object instanceof Integer)) {
                throw new IOException("expected an Integer");
            }
            int n2 = (Integer)object;
            object = list.get(1);
            hashSet.add(X509CertSelector.makeGeneralNameInterface(n2, object));
        }
        return hashSet;
    }

    private static Extension getExtensionObject(X509Certificate x509Certificate, int n2) throws IOException {
        Extension extension = null;
        if (x509Certificate instanceof X509CertImpl) {
            switch (n2) {
                case 0: {
                    extension = ((X509CertImpl)x509Certificate).getPrivateKeyUsageExtension();
                    break;
                }
                case 1: {
                    extension = ((X509CertImpl)x509Certificate).getSubjectAlternativeNameExtension();
                    break;
                }
                case 2: {
                    extension = ((X509CertImpl)x509Certificate).getNameConstraintsExtension();
                    break;
                }
                case 3: {
                    extension = ((X509CertImpl)x509Certificate).getCertificatePoliciesExtension();
                    break;
                }
                case 4: {
                    extension = ((X509CertImpl)x509Certificate).getExtendedKeyUsageExtension();
                }
            }
        } else {
            byte[] byArray = x509Certificate.getExtensionValue(EXTENSION_OIDS[n2]);
            if (byArray != null) {
                DerInputStream derInputStream = new DerInputStream(byArray);
                byte[] byArray2 = derInputStream.getOctetString();
                switch (n2) {
                    case 0: {
                        try {
                            extension = new PrivateKeyUsageExtension(Boolean.FALSE, byArray2);
                            break;
                        }
                        catch (CertificateException certificateException) {
                            throw new IOException(certificateException.getMessage());
                        }
                    }
                    case 1: {
                        extension = new SubjectAlternativeNameExtension(Boolean.FALSE, byArray2);
                        break;
                    }
                    case 2: {
                        extension = new NameConstraintsExtension(Boolean.FALSE, byArray2);
                        break;
                    }
                    case 3: {
                        extension = new CertificatePoliciesExtension(Boolean.FALSE, byArray2);
                        break;
                    }
                    case 4: {
                        extension = new ExtendedKeyUsageExtension(Boolean.FALSE, byArray2);
                    }
                }
            }
        }
        return extension;
    }

    static GeneralNameInterface makeGeneralNameInterface(int n2, Object object) throws IOException {
        GeneralNameInterface generalNameInterface;
        if (debug != null) {
            debug.println("X509CertSelector.makeGeneralNameInterface(" + n2 + ")...");
        }
        if (object instanceof String) {
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralNameInterface() name is String: " + (String)object);
            }
            switch (n2) {
                case 1: {
                    generalNameInterface = new RFC822Name((String)object);
                    break;
                }
                case 2: {
                    generalNameInterface = new DNSName((String)object);
                    break;
                }
                case 4: {
                    generalNameInterface = new X500Name((String)object, "RFC2253");
                    break;
                }
                case 6: {
                    generalNameInterface = new URIName((String)object);
                    break;
                }
                case 7: {
                    generalNameInterface = new IPAddressName((String)object);
                    break;
                }
                case 8: {
                    generalNameInterface = new OIDName((String)object);
                    break;
                }
                default: {
                    throw new IOException("unable to parse String names of type " + n2);
                }
            }
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralNameInterface() result: " + generalNameInterface.toString());
            }
        } else if (object instanceof byte[]) {
            DerValue derValue = new DerValue((byte[])object);
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralNameInterface() is byte[]");
            }
            switch (n2) {
                case 0: {
                    generalNameInterface = new OtherName(derValue);
                    break;
                }
                case 1: {
                    generalNameInterface = new RFC822Name(derValue);
                    break;
                }
                case 2: {
                    generalNameInterface = new DNSName(derValue);
                    break;
                }
                case 3: {
                    generalNameInterface = new X400Address(derValue);
                    break;
                }
                case 4: {
                    generalNameInterface = new X500Name(derValue);
                    break;
                }
                case 5: {
                    generalNameInterface = new EDIPartyName(derValue);
                    break;
                }
                case 6: {
                    generalNameInterface = new URIName(derValue);
                    break;
                }
                case 7: {
                    generalNameInterface = new IPAddressName(derValue);
                    break;
                }
                case 8: {
                    generalNameInterface = new OIDName(derValue);
                    break;
                }
                default: {
                    throw new IOException("unable to parse byte array names of type " + n2);
                }
            }
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralNameInterface() result: " + generalNameInterface.toString());
            }
        } else {
            if (debug != null) {
                debug.println("X509CertSelector.makeGeneralName() input name not String or byte array");
            }
            throw new IOException("name not String or byte array");
        }
        return generalNameInterface;
    }
}

