/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class ProtectionDomain {
    private CodeSource codesource;
    private ClassLoader classloader;
    private Principal[] principals;
    private PermissionCollection permissions;
    private boolean staticPermissions;

    private boolean seeAllp() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.debug"));
            if (string != null) {
                return true;
            }
            SecurityPermission securityPermission = new SecurityPermission("getPolicy");
            try {
                securityManager.checkPermission(securityPermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public String toString() {
        Serializable serializable;
        String string = "<no principals>";
        if (this.principals != null && this.principals.length > 0) {
            serializable = new StringBuffer("(principals ");
            int n2 = 0;
            while (n2 < this.principals.length) {
                ((StringBuffer)serializable).append(this.principals[n2].getClass().getName() + " \"" + this.principals[n2].getName() + "\"");
                if (n2 < this.principals.length - 1) {
                    ((StringBuffer)serializable).append(",\n");
                } else {
                    ((StringBuffer)serializable).append(")\n");
                }
                ++n2;
            }
            string = ((StringBuffer)serializable).toString();
        }
        serializable = Policy.isSet() && this.seeAllp() ? this.mergePermissions() : this.getPermissions();
        return "ProtectionDomain  " + this.codesource + "\n" + " " + this.classloader + "\n" + " " + string + "\n" + " " + serializable + "\n";
    }

    public final CodeSource getCodeSource() {
        return this.codesource;
    }

    public boolean implies(Permission permission) {
        if (!this.staticPermissions && Policy.getPolicyNoCheck().implies(this, permission)) {
            return true;
        }
        if (this.permissions != null) {
            return this.permissions.implies(permission);
        }
        return false;
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    private PermissionCollection mergePermissions() {
        Permission permission;
        Enumeration enumeration;
        if (this.staticPermissions) {
            return this.permissions;
        }
        PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(this){
            private final ProtectionDomain this$0;

            public Object run() {
                Policy policy = Policy.getPolicyNoCheck();
                return policy.getPermissions(this.this$0);
            }
            {
                this.this$0 = protectionDomain;
            }
        });
        Permissions permissions = new Permissions();
        int n2 = 32;
        int n3 = 8;
        Vector vector = new Vector(n3);
        Vector vector2 = new Vector(n2);
        if (this.permissions != null) {
            enumeration = this.permissions.elements();
            while (enumeration.hasMoreElements()) {
                permission = (Permission)enumeration.nextElement();
                vector.add(permission);
            }
        }
        if (permissionCollection != null) {
            enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                vector2.add(enumeration.nextElement());
                ++n3;
            }
        }
        if (permissionCollection != null && this.permissions != null) {
            enumeration = this.permissions.elements();
            block2: while (enumeration.hasMoreElements()) {
                permission = (Permission)enumeration.nextElement();
                int n4 = 0;
                while (n4 < vector2.size()) {
                    Permission permission2 = (Permission)vector2.elementAt(n4);
                    if (permission.getClass().isInstance(permission2) && permission.getName().equals(permission2.getName()) && permission.getActions().equals(permission2.getActions())) {
                        vector2.remove(n4);
                        continue block2;
                    }
                    ++n4;
                }
            }
        }
        if (permissionCollection != null) {
            int n5 = vector2.size() - 1;
            while (n5 >= 0) {
                permissions.add((Permission)vector2.elementAt(n5));
                --n5;
            }
        }
        if (this.permissions != null) {
            int n6 = vector.size() - 1;
            while (n6 >= 0) {
                permissions.add((Permission)vector.elementAt(n6));
                --n6;
            }
        }
        return permissions;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
        this.classloader = null;
        this.principals = new Principal[0];
        this.staticPermissions = true;
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
        this.classloader = classLoader;
        this.principals = principalArray != null ? (Principal[])principalArray.clone() : new Principal[]{};
        this.staticPermissions = false;
    }
}

