/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

final class BasicPermissionCollection
extends PermissionCollection
implements Serializable {
    static final long serialVersionUID = 739301742472979399L;
    private Hashtable permissions = new Hashtable(11);
    private boolean all_allowed = false;
    private Class permClass;

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Enumeration enumeration;
        objectInputStream.defaultReadObject();
        if (this.permClass == null && (enumeration = this.permissions.elements()).hasMoreElements()) {
            Permission permission = (Permission)enumeration.nextElement();
            this.permClass = permission.getClass();
        }
    }

    public void add(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (this.permissions.size() == 0) {
            this.permClass = basicPermission.getClass();
        } else if (basicPermission.getClass() != this.permClass) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        this.permissions.put(basicPermission.getName(), permission);
        if (!this.all_allowed && basicPermission.getName().equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n2;
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (basicPermission.getClass() != this.permClass) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        String string = basicPermission.getName();
        Permission permission2 = (Permission)this.permissions.get(string);
        if (permission2 != null) {
            return permission2.implies(permission);
        }
        int n3 = string.length() - 1;
        while ((n2 = string.lastIndexOf(".", n3)) != -1) {
            permission2 = (Permission)this.permissions.get(string = string.substring(0, n2 + 1) + "*");
            if (permission2 != null) {
                return permission2.implies(permission);
            }
            n3 = n2 - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

