/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Random;
import sun.security.action.GetBooleanAction;

public final class ObjID
implements Serializable {
    public static final int REGISTRY_ID = 0;
    public static final int ACTIVATOR_ID = 1;
    public static final int DGC_ID = 2;
    private static final long serialVersionUID = -6386392263968365220L;
    private static final UID mySpace;
    private static final Random generator;
    private final long objNum;
    private final UID space;

    public int hashCode() {
        return (int)this.objNum;
    }

    static {
        boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.randomIDs"));
        if (bl2) {
            generator = new SecureRandom();
            mySpace = null;
        } else {
            generator = new InsecureRandom(null);
            mySpace = new UID();
        }
    }

    public ObjID() {
        this.space = mySpace != null ? mySpace : new UID();
        this.objNum = generator.nextLong();
    }

    public ObjID(int n2) {
        this.space = new UID(0);
        this.objNum = n2;
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.objNum);
        this.space.write(objectOutput);
    }

    public boolean equals(Object object) {
        if (object instanceof ObjID) {
            ObjID objID = (ObjID)object;
            return this.objNum == objID.objNum && this.space.equals(objID.space);
        }
        return false;
    }

    public String toString() {
        return "[" + (this.space.equals(mySpace) ? "" : this.space + ", ") + this.objNum + "]";
    }

    private ObjID(long l2, UID uID) {
        this.objNum = l2;
        this.space = uID;
    }

    public static ObjID read(ObjectInput objectInput) throws IOException {
        long l2 = objectInput.readLong();
        UID uID = UID.read(objectInput);
        return new ObjID(l2, uID);
    }

    class 1 {
    }

    private static final class InsecureRandom
    extends Random {
        private static final long serialVersionUID = -698228687531590145L;
        private long nextNum;

        public synchronized long nextLong() {
            return this.nextNum++;
        }

        private InsecureRandom() {
        }

        InsecureRandom(1 var1_1) {
            this();
        }
    }
}

