/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapShortBufferR;
import java.nio.ShortBuffer;

class HeapShortBuffer
extends ShortBuffer {
    public short get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected int ix(int n2) {
        return n2 + this.offset;
    }

    public short get(int n2) {
        return this.hb[this.ix(this.checkIndex(n2))];
    }

    HeapShortBuffer(int n2, int n3) {
        super(-1, 0, n3, n2, new short[n2], 0);
    }

    HeapShortBuffer(short[] sArray, int n2, int n3) {
        super(-1, n2, n2 + n3, sArray.length, sArray, 0);
    }

    protected HeapShortBuffer(short[] sArray, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, sArray, n6);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new HeapShortBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public ShortBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    public ShortBuffer duplicate() {
        return new HeapShortBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public ShortBuffer slice() {
        return new HeapShortBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public ShortBuffer put(int n2, short s2) {
        this.hb[this.ix((int)this.checkIndex((int)n2))] = s2;
        return this;
    }

    public ShortBuffer put(short s2) {
        this.hb[this.ix((int)this.nextPutIndex())] = s2;
        return this;
    }

    public ShortBuffer get(short[] sArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, sArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), sArray, n2, n3);
        this.position(this.position() + n3);
        return this;
    }

    public ShortBuffer put(short[] sArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, sArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(sArray, n2, this.hb, this.ix(this.position()), n3);
        this.position(this.position() + n3);
        return this;
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer instanceof HeapShortBuffer) {
            if (shortBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapShortBuffer heapShortBuffer = (HeapShortBuffer)shortBuffer;
            int n2 = heapShortBuffer.remaining();
            if (n2 > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapShortBuffer.hb, heapShortBuffer.ix(heapShortBuffer.position()), this.hb, this.ix(this.position()), n2);
            heapShortBuffer.position(heapShortBuffer.position() + n2);
            this.position(this.position() + n2);
        } else if (shortBuffer.isDirect()) {
            int n3 = shortBuffer.remaining();
            if (n3 > this.remaining()) {
                throw new BufferOverflowException();
            }
            shortBuffer.get(this.hb, this.ix(this.position()), n3);
            this.position(this.position() + n3);
        } else {
            super.put(shortBuffer);
        }
        return this;
    }
}

