/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBufferR;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

class HeapByteBuffer
extends ByteBuffer {
    public byte get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public char getChar() {
        return Bits.getChar(this, this.ix(this.nextGetIndex(2)), this.bigEndian);
    }

    public double getDouble() {
        return Bits.getDouble(this, this.ix(this.nextGetIndex(8)), this.bigEndian);
    }

    public float getFloat() {
        return Bits.getFloat(this, this.ix(this.nextGetIndex(4)), this.bigEndian);
    }

    public int getInt() {
        return Bits.getInt(this, this.ix(this.nextGetIndex(4)), this.bigEndian);
    }

    public long getLong() {
        return Bits.getLong(this, this.ix(this.nextGetIndex(8)), this.bigEndian);
    }

    public short getShort() {
        return Bits.getShort(this, this.ix(this.nextGetIndex(2)), this.bigEndian);
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    byte _get(int n2) {
        return this.hb[n2];
    }

    public byte get(int n2) {
        return this.hb[this.ix(this.checkIndex(n2))];
    }

    public char getChar(int n2) {
        return Bits.getChar(this, this.ix(this.checkIndex(n2, 2)), this.bigEndian);
    }

    public double getDouble(int n2) {
        return Bits.getDouble(this, this.ix(this.checkIndex(n2, 8)), this.bigEndian);
    }

    public float getFloat(int n2) {
        return Bits.getFloat(this, this.ix(this.checkIndex(n2, 4)), this.bigEndian);
    }

    public int getInt(int n2) {
        return Bits.getInt(this, this.ix(this.checkIndex(n2, 4)), this.bigEndian);
    }

    protected int ix(int n2) {
        return n2 + this.offset;
    }

    public long getLong(int n2) {
        return Bits.getLong(this, this.ix(this.checkIndex(n2, 8)), this.bigEndian);
    }

    public short getShort(int n2) {
        return Bits.getShort(this, this.ix(this.checkIndex(n2, 2)), this.bigEndian);
    }

    void _put(int n2, byte by) {
        this.hb[n2] = by;
    }

    HeapByteBuffer(int n2, int n3) {
        super(-1, 0, n3, n2, new byte[n2], 0);
    }

    HeapByteBuffer(byte[] byArray, int n2, int n3) {
        super(-1, n2, n2 + n3, byArray.length, byArray, 0);
    }

    protected HeapByteBuffer(byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, byArray, n6);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return new HeapByteBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public ByteBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    public ByteBuffer duplicate() {
        return new HeapByteBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public ByteBuffer slice() {
        return new HeapByteBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public ByteBuffer put(byte by) {
        this.hb[this.ix((int)this.nextPutIndex())] = by;
        return this;
    }

    public ByteBuffer putChar(char c2) {
        Bits.putChar(this, this.ix(this.nextPutIndex(2)), c2, this.bigEndian);
        return this;
    }

    public ByteBuffer putDouble(double d2) {
        Bits.putDouble(this, this.ix(this.nextPutIndex(8)), d2, this.bigEndian);
        return this;
    }

    public ByteBuffer putFloat(float f2) {
        Bits.putFloat(this, this.ix(this.nextPutIndex(4)), f2, this.bigEndian);
        return this;
    }

    public ByteBuffer putInt(int n2) {
        Bits.putInt(this, this.ix(this.nextPutIndex(4)), n2, this.bigEndian);
        return this;
    }

    public ByteBuffer put(int n2, byte by) {
        this.hb[this.ix((int)this.checkIndex((int)n2))] = by;
        return this;
    }

    public ByteBuffer putChar(int n2, char c2) {
        Bits.putChar(this, this.ix(this.checkIndex(n2, 2)), c2, this.bigEndian);
        return this;
    }

    public ByteBuffer putDouble(int n2, double d2) {
        Bits.putDouble(this, this.ix(this.checkIndex(n2, 8)), d2, this.bigEndian);
        return this;
    }

    public ByteBuffer putFloat(int n2, float f2) {
        Bits.putFloat(this, this.ix(this.checkIndex(n2, 4)), f2, this.bigEndian);
        return this;
    }

    public ByteBuffer putInt(int n2, int n3) {
        Bits.putInt(this, this.ix(this.checkIndex(n2, 4)), n3, this.bigEndian);
        return this;
    }

    public ByteBuffer putLong(int n2, long l2) {
        Bits.putLong(this, this.ix(this.checkIndex(n2, 8)), l2, this.bigEndian);
        return this;
    }

    public ByteBuffer putShort(int n2, short s2) {
        Bits.putShort(this, this.ix(this.checkIndex(n2, 2)), s2, this.bigEndian);
        return this;
    }

    public ByteBuffer putLong(long l2) {
        Bits.putLong(this, this.ix(this.nextPutIndex(8)), l2, this.bigEndian);
        return this;
    }

    public ByteBuffer putShort(short s2) {
        Bits.putShort(this, this.ix(this.nextPutIndex(2)), s2, this.bigEndian);
        return this;
    }

    public ByteBuffer get(byte[] byArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, byArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), byArray, n2, n3);
        this.position(this.position() + n3);
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, byArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(byArray, n2, this.hb, this.ix(this.position()), n3);
        this.position(this.position() + n3);
        return this;
    }

    public CharBuffer asCharBuffer() {
        int n2 = this.remaining() >> 1;
        int n3 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, n2, n2, n3) : new ByteBufferAsCharBufferL(this, -1, 0, n2, n2, n3);
    }

    public DoubleBuffer asDoubleBuffer() {
        int n2 = this.remaining() >> 3;
        int n3 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, n2, n2, n3) : new ByteBufferAsDoubleBufferL(this, -1, 0, n2, n2, n3);
    }

    public FloatBuffer asFloatBuffer() {
        int n2 = this.remaining() >> 2;
        int n3 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, n2, n2, n3) : new ByteBufferAsFloatBufferL(this, -1, 0, n2, n2, n3);
    }

    public IntBuffer asIntBuffer() {
        int n2 = this.remaining() >> 2;
        int n3 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, n2, n2, n3) : new ByteBufferAsIntBufferL(this, -1, 0, n2, n2, n3);
    }

    public LongBuffer asLongBuffer() {
        int n2 = this.remaining() >> 3;
        int n3 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, n2, n2, n3) : new ByteBufferAsLongBufferL(this, -1, 0, n2, n2, n3);
    }

    public ShortBuffer asShortBuffer() {
        int n2 = this.remaining() >> 1;
        int n3 = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, n2, n2, n3) : new ByteBufferAsShortBufferL(this, -1, 0, n2, n2, n3);
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer instanceof HeapByteBuffer) {
            if (byteBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapByteBuffer heapByteBuffer = (HeapByteBuffer)byteBuffer;
            int n2 = heapByteBuffer.remaining();
            if (n2 > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapByteBuffer.hb, heapByteBuffer.ix(heapByteBuffer.position()), this.hb, this.ix(this.position()), n2);
            heapByteBuffer.position(heapByteBuffer.position() + n2);
            this.position(this.position() + n2);
        } else if (byteBuffer.isDirect()) {
            int n3 = byteBuffer.remaining();
            if (n3 > this.remaining()) {
                throw new BufferOverflowException();
            }
            byteBuffer.get(this.hb, this.ix(this.position()), n3);
            this.position(this.position() + n3);
        } else {
            super.put(byteBuffer);
        }
        return this;
    }
}

