/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectIntBufferRS;
import java.nio.IntBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferS
extends IntBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected boolean allocated;
    protected Object viewedBuffer = null;
    static final boolean $assertionsDisabled;
    static Class class$java$nio$DirectIntBufferS;

    public int get() {
        return Bits.swap(unsafe.getInt(this.ix(this.nextGetIndex())));
    }

    public long address() {
        return this.address;
    }

    static {
        $assertionsDisabled = !(class$java$nio$DirectIntBufferS == null ? (class$java$nio$DirectIntBufferS = DirectIntBufferS.class$("java.nio.DirectIntBufferS")) : class$java$nio$DirectIntBufferS).desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public int get(int n2) {
        return Bits.swap(unsafe.getInt(this.ix(this.checkIndex(n2))));
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 2);
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    DirectIntBufferS(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 2, directByteBuffer.remaining() >> 2);
        int n2 = this.capacity();
        this.limit(n2);
        int n3 = this.position();
        if (!$assertionsDisabled && n3 > n2) {
            throw new AssertionError();
        }
        this.address = directByteBuffer.address() + (long)n3;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    public IntBuffer asReadOnlyBuffer() {
        return new DirectIntBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public IntBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 2);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public IntBuffer duplicate() {
        return new DirectIntBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public IntBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 2;
        return new DirectIntBufferS(this, -1, 0, n4, n4, n5);
    }

    public IntBuffer put(int n2) {
        unsafe.putInt(this.ix(this.nextPutIndex()), Bits.swap(n2));
        return this;
    }

    public IntBuffer put(int n2, int n3) {
        unsafe.putInt(this.ix(this.checkIndex(n2)), Bits.swap(n3));
        return this;
    }

    public IntBuffer get(int[] nArray, int n2, int n3) {
        if (n3 << 2 > 6) {
            int n4;
            Buffer.checkBounds(n2, n3, nArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(n5), nArray, n2 << 2, n3 << 2);
            } else {
                Bits.copyToByteArray(this.ix(n5), nArray, n2 << 2, n3 << 2);
            }
            this.position(n5 + n3);
        } else {
            super.get(nArray, n2, n3);
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n2, int n3) {
        if (n3 << 2 > 6) {
            int n4;
            Buffer.checkBounds(n2, n3, nArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(nArray, n2 << 2, this.ix(n5), n3 << 2);
            } else {
                Bits.copyFromByteArray(nArray, n2 << 2, this.ix(n5), n3 << 2);
            }
            this.position(n5 + n3);
        } else {
            super.put(nArray, n2, n3);
        }
        return this;
    }

    DirectIntBufferS(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof DirectIntBufferS) {
            int n2;
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectIntBufferS directIntBufferS = (DirectIntBufferS)intBuffer;
            int n3 = directIntBufferS.position();
            int n4 = directIntBufferS.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directIntBufferS.ix(n3), this.ix(n6), n5 << 2);
            directIntBufferS.position(n3 + n5);
            this.position(n6 + n5);
        } else if (!intBuffer.isDirect()) {
            int n9 = intBuffer.position();
            int n10 = intBuffer.limit();
            if (!$assertionsDisabled && n9 > n10) {
                throw new AssertionError();
            }
            int n11 = n9 <= n10 ? n10 - n9 : 0;
            this.put(intBuffer.array(), intBuffer.arrayOffset() + n9, n11);
            intBuffer.position(n9 + n11);
        } else {
            super.put(intBuffer);
        }
        return this;
    }
}

