/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImplFactory;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.security.action.GetPropertyAction;

public class Socket {
    private boolean created = false;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private boolean shutIn = false;
    private boolean shutOut = false;
    SocketImpl impl;
    private boolean oldImpl = false;
    private static SocketImplFactory factory;
    static Class class$java$net$SocketAddress;

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n2 = 0;
        Object object = this.getImpl().getOption(4098);
        if (object instanceof Integer) {
            n2 = (Integer)object;
        }
        return n2;
    }

    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n2 = 0;
        Object object = this.getImpl().getOption(4097);
        if (object instanceof Integer) {
            n2 = (Integer)object;
        }
        return n2;
    }

    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(128);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public int getTrafficClass() throws SocketException {
        return (Integer)this.getImpl().getOption(3);
    }

    static {
        int n2 = -1;
        String string = null;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyHost"));
        string = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyPort"));
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n2 = -1;
            }
        }
        if (string2 != null) {
            factory = new SocksSocketImplFactory(string2, n2);
        }
    }

    public Socket() {
        this.setImpl();
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        Class[] classArray = new Class[]{class$java$net$SocketAddress == null ? (class$java$net$SocketAddress = Socket.class$("java.net.SocketAddress")) : class$java$net$SocketAddress, Integer.TYPE};
        try {
            this.impl.getClass().getDeclaredMethod("connect", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.oldImpl = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    final void postAccept() {
        this.connected = true;
        this.created = true;
        this.bound = true;
    }

    void setBound() {
        this.bound = true;
    }

    void setConnected() {
        this.connected = true;
    }

    void setCreated() {
        this.created = true;
    }

    void setImpl() {
        if (factory != null) {
            this.impl = factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            this.impl = new PlainSocketImpl();
        }
        if (this.impl != null) {
            this.impl.setSocket(this);
        }
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.getImpl().shutdownInput();
        this.shutIn = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.getImpl().shutdownOutput();
        this.shutOut = true;
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(8);
    }

    public boolean getOOBInline() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4099);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(1);
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean isConnected() {
        return this.connected || this.oldImpl;
    }

    public boolean isInputShutdown() {
        return this.shutIn;
    }

    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    public void sendUrgentData(int n2) throws IOException {
        if (!this.getImpl().supportsUrgentData()) {
            throw new SocketException("Urgent data not supported");
        }
        this.getImpl().sendUrgentData(n2);
    }

    public synchronized void setReceiveBufferSize(int n2) throws SocketException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(n2));
    }

    public synchronized void setSendBufferSize(int n2) throws SocketException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, new Integer(n2));
    }

    public synchronized void setSoTimeout(int n2) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.getImpl().setOption(4102, new Integer(n2));
    }

    public void setTrafficClass(int n2) throws SocketException {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("tc is not in range 0 -- 255");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(3, new Integer(n2));
    }

    void createImpl(boolean bl2) throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(bl2);
            this.created = true;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.getMessage());
        }
    }

    public void setKeepAlive(boolean bl2) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(8, new Boolean(bl2));
    }

    public void setOOBInline(boolean bl2) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4099, new Boolean(bl2));
    }

    public void setReuseAddress(boolean bl2) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, new Boolean(bl2));
    }

    public void setTcpNoDelay(boolean bl2) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(1, new Boolean(bl2));
    }

    public void setSoLinger(boolean bl2, int n2) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!bl2) {
            this.getImpl().setOption(128, new Boolean(bl2));
        } else {
            if (n2 < 0) {
                throw new IllegalArgumentException("invalid value for SO_LINGER");
            }
            if (n2 > 65535) {
                n2 = 65535;
            }
            this.getImpl().setOption(128, new Integer(n2));
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        Socket socket = this;
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                private final Socket this$0;

                public Object run() throws IOException {
                    return this.this$0.impl.getInputStream();
                }
                {
                    this.this$0 = socket;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        Socket socket = this;
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                private final Socket this$0;

                public Object run() throws IOException {
                    return this.this$0.impl.getOutputStream();
                }
                {
                    this.this$0 = socket;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    public String toString() {
        try {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {}
        return "Socket[unconnected]";
    }

    public Socket(String string, int n2) throws UnknownHostException, IOException {
        this(string != null ? new InetSocketAddress(string, n2) : null, new InetSocketAddress(0), true);
    }

    public Socket(String string, int n2, boolean bl2) throws IOException {
        this(string != null ? new InetSocketAddress(string, n2) : null, new InetSocketAddress(0), bl2);
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            return InetAddress.anyLocalAddress();
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = (InetAddress)this.getImpl().getOption(15);
            if (inetAddress.isAnyLocalAddress()) {
                inetAddress = InetAddress.anyLocalAddress();
            }
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress();
        }
        return inetAddress;
    }

    public Socket(InetAddress inetAddress, int n2) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n2) : null, new InetSocketAddress(0), true);
    }

    public Socket(InetAddress inetAddress, int n2, boolean bl2) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n2) : null, new InetSocketAddress(0), bl2);
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress != null && !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress != null && inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (socketAddress == null) {
            this.getImpl().bind(InetAddress.anyLocalAddress(), 0);
        } else {
            this.getImpl().bind(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        this.bound = true;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    public void connect(SocketAddress socketAddress, int n2) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isConnected()) {
            throw new SocketException("already connected");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (inetSocketAddress.isUnresolved()) {
                securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            } else {
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
            }
        }
        if (!this.created) {
            this.createImpl(true);
        }
        if (!this.oldImpl) {
            this.impl.connect(inetSocketAddress, n2);
        } else if (n2 == 0) {
            if (inetSocketAddress.isUnresolved()) {
                this.impl.connect(inetSocketAddress.getAddress().getHostName(), inetSocketAddress.getPort());
            } else {
                this.impl.connect(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            }
        } else {
            throw new UnsupportedOperationException("SocketImpl.connect(addr, timeout)");
        }
        this.connected = true;
        this.bound = true;
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl(true);
        }
        return this.impl;
    }

    protected Socket(SocketImpl socketImpl) throws SocketException {
        this.impl = socketImpl;
        if (socketImpl != null) {
            this.checkOldImpl();
            this.impl.setSocket(this);
        }
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }

    public SocketChannel getChannel() {
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Socket(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        this(string != null ? new InetSocketAddress(string, n2) : null, new InetSocketAddress(inetAddress, n3), true);
    }

    public Socket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n2) : null, new InetSocketAddress(inetAddress2, n3), true);
    }

    private Socket(SocketAddress socketAddress, SocketAddress socketAddress2, boolean bl2) throws IOException {
        this.setImpl();
        if (socketAddress == null) {
            throw new NullPointerException();
        }
        try {
            this.createImpl(bl2);
            if (socketAddress2 == null) {
                socketAddress2 = new InetSocketAddress(0);
            }
            this.bind(socketAddress2);
            if (socketAddress != null) {
                this.connect(socketAddress);
            }
        }
        catch (SocketException socketException) {
            this.close();
            throw socketException;
        }
    }
}

