/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;

public class BigDecimal
extends Number
implements Comparable {
    private BigInteger intVal;
    private int scale = 0;
    private static final long serialVersionUID = 6108874887143696463L;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    static final boolean $assertionsDisabled = !(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BigDecimal.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).desiredAssertionStatus();
    static Class class$java$math$BigDecimal;

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public int hashCode() {
        return 31 * this.intVal.hashCode() + this.scale;
    }

    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public int scale() {
        return this.scale;
    }

    public int signum() {
        return this.intVal.signum();
    }

    public long longValue() {
        return this.toBigInteger().longValue();
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal(double var1_1) {
        super();
        if (Double.isInfinite(var1_1) || Double.isNaN(var1_1)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        var3_2 = Double.doubleToLongBits(var1_1);
        var5_3 = var3_2 >> 63 == 0L ? 1 : -1;
        var6_4 = (int)(var3_2 >> 52 & 2047L);
        var7_5 = var6_4 == 0 ? (var3_2 & 0xFFFFFFFFFFFFFL) << 1 : var3_2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        var6_4 -= 1075;
        if (var7_5 != 0L) ** GOTO lbl15
        this.intVal = BigInteger.ZERO;
        return;
lbl-1000:
        // 1 sources

        {
            var7_5 >>= 1;
            ++var6_4;
lbl15:
            // 2 sources

            ** while ((var7_5 & 1L) == 0L)
        }
lbl16:
        // 1 sources

        this.intVal = BigInteger.valueOf((long)var5_3 * var7_5);
        if (var6_4 < 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(5L).pow(-var6_4));
            this.scale = -var6_4;
        } else if (var6_4 > 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(2L).pow(var6_4));
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.scale < 0) {
            throw new StreamCorruptedException("BigDecimal: Negative scale");
        }
    }

    public int compareTo(Object object) {
        return this.compareTo((BigDecimal)object);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        return this.scale == bigDecimal.scale && this.intVal.equals(bigDecimal.intVal);
    }

    public String toString() {
        if (this.scale == 0) {
            return this.intVal.toString();
        }
        return this.getValueString(this.signum(), this.intVal.abs().toString(), this.scale);
    }

    public BigDecimal(String string) {
        int n2;
        if (string.length() == 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '+' && ((string = string.substring(1)).length() == 0 || string.charAt(0) == '-')) {
            throw new NumberFormatException();
        }
        int n3 = 0;
        int n4 = string.indexOf(101);
        if (n4 == -1) {
            n4 = string.indexOf(69);
        }
        if (n4 != -1) {
            String string2 = string.substring(n4 + 1);
            if (string2.length() == 0) {
                throw new NumberFormatException();
            }
            if (string2.charAt(0) == '+' && ((string2 = string2.substring(1)).length() == 0 || string2.charAt(0) == '-')) {
                throw new NumberFormatException();
            }
            n3 = Integer.parseInt(string2);
            if (n4 == 0) {
                throw new NumberFormatException();
            }
            string = string.substring(0, n4);
        }
        if ((n2 = string.indexOf(46)) == -1) {
            this.intVal = new BigInteger(string);
        } else if (n2 == string.length() - 1) {
            this.intVal = new BigInteger(string.substring(0, string.length() - 1));
        } else {
            if (string.charAt(n2 + 1) == '-') {
                throw new NumberFormatException();
            }
            char[] cArray = new char[string.length() - 1];
            string.getChars(0, n2, cArray, 0);
            string.getChars(n2 + 1, string.length(), cArray, n2);
            this.scale = string.length() - n2 - 1;
            this.intVal = new BigInteger(cArray);
        }
        if (!$assertionsDisabled && this.scale < 0) {
            throw new AssertionError();
        }
        long l2 = (long)this.scale - (long)n3;
        if (l2 > Integer.MAX_VALUE) {
            throw new NumberFormatException("Final scale out of range");
        }
        this.scale = (int)l2;
        if (!($assertionsDisabled || (long)this.scale == l2 && Math.abs(l2) <= Integer.MAX_VALUE)) {
            throw new AssertionError(l2);
        }
        if (this.scale < 0) {
            this.intVal = BigDecimal.timesTenToThe(this.intVal, -this.scale);
            this.scale = 0;
        }
    }

    public BigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public BigDecimal movePointLeft(int n2) {
        return n2 >= 0 ? new BigDecimal(this.intVal, this.scale + n2) : this.movePointRight(-n2);
    }

    public BigDecimal movePointRight(int n2) {
        return this.scale >= n2 ? new BigDecimal(this.intVal, this.scale - n2) : new BigDecimal(BigDecimal.timesTenToThe(this.intVal, n2 - this.scale), 0);
    }

    public BigDecimal setScale(int n2) {
        return this.setScale(n2, 7);
    }

    public BigDecimal setScale(int n2, int n3) {
        if (n2 < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (n2 == this.scale) {
            return this;
        }
        if (n2 > this.scale) {
            return new BigDecimal(BigDecimal.timesTenToThe(this.intVal, n2 - this.scale), n2);
        }
        return this.divide(BigDecimal.valueOf(1L), n2, n3);
    }

    public static BigDecimal valueOf(long l2) {
        return BigDecimal.valueOf(l2, 0);
    }

    public static BigDecimal valueOf(long l2, int n2) {
        return new BigDecimal(BigInteger.valueOf(l2), n2);
    }

    public int compareTo(BigDecimal bigDecimal) {
        int n2 = this.signum() - bigDecimal.signum();
        if (n2 != 0) {
            return n2 > 0 ? 1 : -1;
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        BigDecimal.matchScale(bigDecimalArray);
        return bigDecimalArray[0].intVal.compareTo(bigDecimalArray[1].intVal);
    }

    private static void matchScale(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray[0].scale < bigDecimalArray[1].scale) {
            bigDecimalArray[0] = bigDecimalArray[0].setScale(bigDecimalArray[1].scale);
        } else if (bigDecimalArray[1].scale < bigDecimalArray[0].scale) {
            bigDecimalArray[1] = bigDecimalArray[1].setScale(bigDecimalArray[0].scale);
        }
    }

    public BigInteger toBigInteger() {
        return this.scale == 0 ? this.intVal : this.intVal.divide(BigInteger.valueOf(10L).pow(this.scale));
    }

    public BigInteger unscaledValue() {
        return this.intVal;
    }

    public BigDecimal(BigInteger bigInteger) {
        this.intVal = bigInteger;
    }

    public BigDecimal(BigInteger bigInteger, int n2) {
        if (n2 < 0) {
            throw new NumberFormatException("Negative scale");
        }
        this.intVal = bigInteger;
        this.scale = n2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String getValueString(int n2, String string, int n3) {
        StringBuffer stringBuffer;
        int n4 = string.length() - n3;
        if (n4 == 0) {
            return (n2 < 0 ? "-0." : "0.") + string;
        }
        if (n4 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n4, '.');
            if (n2 < 0) {
                stringBuffer.insert(0, '-');
            }
        } else {
            stringBuffer = new StringBuffer(3 - n4 + string.length());
            stringBuffer.append(n2 < 0 ? "-0." : "0.");
            int n5 = 0;
            while (n5 < -n4) {
                stringBuffer.append('0');
                ++n5;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String roundup(String string) {
        int n2;
        int n3;
        char[] cArray = string.toCharArray();
        char c2 = cArray[n3 = (n2 = cArray.length) - 1];
        if (c2 == '9') {
            while (c2 == '9' && n3 > 0) {
                cArray[n3] = 48;
                c2 = cArray[--n3];
            }
            if (c2 == '9') {
                cArray[0] = 48;
                return "1" + String.valueOf(cArray);
            }
        }
        cArray[n3] = (char)(c2 + '\u0001');
        return String.valueOf(cArray);
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        BigDecimal.matchScale(bigDecimalArray);
        return new BigDecimal(bigDecimalArray[0].intVal.add(bigDecimalArray[1].intVal), bigDecimalArray[0].scale);
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) > 0 ? this : bigDecimal;
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) < 0 ? this : bigDecimal;
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        return new BigDecimal(this.intVal.multiply(bigDecimal.intVal), this.scale + bigDecimal.scale);
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        BigDecimal.matchScale(bigDecimalArray);
        return new BigDecimal(bigDecimalArray[0].intVal.subtract(bigDecimalArray[1].intVal), bigDecimalArray[0].scale);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n2) {
        return this.divide(bigDecimal, this.scale, n2);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n2, int n3) {
        int n4;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        if (n2 < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (n2 + bigDecimal.scale >= this.scale) {
            bigDecimal3 = this.setScale(n2 + bigDecimal.scale);
            bigDecimal2 = bigDecimal;
        } else {
            bigDecimal3 = this;
            bigDecimal2 = bigDecimal.setScale(this.scale - n2);
        }
        BigInteger[] bigIntegerArray = bigDecimal3.intVal.divideAndRemainder(bigDecimal2.intVal);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        if (bigInteger2.signum() == 0) {
            return new BigDecimal(bigInteger, n2);
        }
        if (n3 == 7) {
            throw new ArithmeticException("Rounding necessary");
        }
        int n5 = bigDecimal3.signum() * bigDecimal2.signum();
        boolean bl2 = n3 == 0 ? true : (n3 == 1 ? false : (n3 == 2 ? n5 > 0 : (n3 == 3 ? n5 < 0 : ((n4 = bigInteger2.abs().multiply(BigInteger.valueOf(2L)).compareTo(bigDecimal2.intVal.abs())) < 0 ? false : (n4 > 0 ? true : (n3 == 4 ? true : (n3 == 5 ? false : bigInteger.testBit(0))))))));
        return bl2 ? new BigDecimal(bigInteger.add(BigInteger.valueOf(n5)), n2) : new BigDecimal(bigInteger, n2);
    }

    private static BigInteger timesTenToThe(BigInteger bigInteger, int n2) {
        return bigInteger.multiply(BigInteger.valueOf(10L).pow(n2));
    }
}

