/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;

public final class Method
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private volatile MethodAccessor methodAccessor;
    private Method root;
    private volatile Class securityCheckTargetClassCache;

    public int getModifiers() {
        return this.modifiers;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    private void acquireMethodAccessor() {
        MethodAccessor methodAccessor = null;
        if (this.root != null) {
            methodAccessor = this.root.getMethodAccessor();
        }
        if (methodAccessor != null) {
            this.methodAccessor = methodAccessor;
            return;
        }
        methodAccessor = AccessibleObject.reflectionFactory.newMethodAccessor(this);
        this.setMethodAccessor(methodAccessor);
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Class[] getExceptionTypes() {
        return Method.copy(this.exceptionTypes);
    }

    public Class[] getParameterTypes() {
        return Method.copy(this.parameterTypes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Method) {
            Class[] classArray;
            Class[] classArray2;
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName().equals(method.getName()) && (classArray2 = this.parameterTypes).length == (classArray = method.parameterTypes).length) {
                int n2 = 0;
                while (n2 < classArray2.length) {
                    if (classArray2[n2] != classArray[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.getModifiers();
            if (n2 != 0) {
                stringBuffer.append(Modifier.toString(n2) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getReturnType()) + " ");
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuffer.append(this.getName() + "(");
            Class[] classArray = this.parameterTypes;
            int n3 = 0;
            while (n3 < classArray.length) {
                stringBuffer.append(Field.getTypeName(classArray[n3]));
                if (n3 < classArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n3;
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                int n4 = 0;
                while (n4 < classArray2.length) {
                    stringBuffer.append(classArray2[n4].getName());
                    if (n4 < classArray2.length - 1) {
                        stringBuffer.append(",");
                    }
                    ++n4;
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    Method copy() {
        Method method = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot);
        method.root = this;
        method.methodAccessor = this.methodAccessor;
        return method;
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor methodAccessor) {
        this.methodAccessor = methodAccessor;
        if (this.root != null) {
            this.root.setMethodAccessor(methodAccessor);
        }
    }

    static Class[] copy(Class[] classArray) {
        int n2 = classArray.length;
        if (n2 == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[n2];
        int n3 = 0;
        while (n3 < n2) {
            classArray2[n3] = classArray[n3];
            ++n3;
        }
        return classArray2;
    }

    public Object invoke(Object object, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class clazz;
            Class clazz2 = Reflection.getCallerClass(1);
            Class clazz3 = clazz = object == null || !Modifier.isProtected(this.modifiers) ? this.clazz : object.getClass();
            if (this.securityCheckCache != clazz2 || clazz != this.securityCheckTargetClassCache) {
                Reflection.ensureMemberAccess(clazz2, this.clazz, object, this.modifiers);
                this.securityCheckCache = clazz2;
                this.securityCheckTargetClassCache = clazz;
            }
        }
        if (this.methodAccessor == null) {
            this.acquireMethodAccessor();
        }
        return this.methodAccessor.invoke(object, objectArray);
    }

    Method(Class clazz, String string, Class[] classArray, Class clazz2, Class[] classArray2, int n2, int n3) {
        this.clazz = clazz;
        this.name = string;
        this.parameterTypes = classArray;
        this.returnType = clazz2;
        this.exceptionTypes = classArray2;
        this.modifiers = n2;
        this.slot = n3;
    }
}

