/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class StringBuffer
implements Serializable,
CharSequence {
    private char[] value;
    private int count;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;
    private static final StringBuffer NULL = new StringBuffer("null");

    public synchronized int capacity() {
        return this.value.length;
    }

    public synchronized int length() {
        return this.count;
    }

    public StringBuffer() {
        this(16);
    }

    private final void copy() {
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    final void setShared() {
        this.shared = true;
    }

    final char[] getValue() {
        return this.value;
    }

    public synchronized char charAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return this.value[n2];
    }

    public StringBuffer(int n2) {
        this.value = new char[n2];
        this.shared = false;
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
    }

    private void expandCapacity(int n2) {
        int n3 = (this.value.length + 1) * 2;
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        } else if (n2 > n3) {
            n3 = n2;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void setLength(int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        if (this.count < n2) {
            if (this.shared) {
                this.copy();
            }
            while (this.count < n2) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = n2;
            if (this.shared) {
                this.copy();
            }
        }
    }

    public synchronized void setCharAt(int n2, char c2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (this.shared) {
            this.copy();
        }
        this.value[n2] = c2;
    }

    public synchronized void getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0 || n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, n2, cArray, n4, n3 - n2);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.value = (char[])this.value.clone();
        this.shared = false;
    }

    public CharSequence subSequence(int n2, int n3) {
        return this.substring(n2, n3);
    }

    public String toString() {
        return new String(this);
    }

    public synchronized String substring(int n2) {
        return this.substring(n2, this.count);
    }

    public synchronized String substring(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        return new String(this.value, n2, n3 - n2);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public StringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public synchronized int indexOf(String string, int n2) {
        return String.indexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n2);
    }

    public synchronized int lastIndexOf(String string, int n2) {
        return String.lastIndexOf(this.value, 0, this.count, string.toCharArray(), 0, string.length(), n2);
    }

    public synchronized StringBuffer reverse() {
        if (this.shared) {
            this.copy();
        }
        int n2 = this.count - 1;
        int n3 = n2 - 1 >> 1;
        while (n3 >= 0) {
            char c2 = this.value[n3];
            this.value[n3] = this.value[n2 - n3];
            this.value[n2 - n3] = c2;
            --n3;
        }
        return this;
    }

    public synchronized StringBuffer append(char c2) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        this.value[this.count++] = c2;
        return this;
    }

    public StringBuffer append(double d2) {
        return this.append(String.valueOf(d2));
    }

    public StringBuffer append(float f2) {
        return this.append(String.valueOf(f2));
    }

    public StringBuffer append(int n2) {
        return this.append(String.valueOf(n2));
    }

    public synchronized StringBuffer deleteCharAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n2 + 1, this.value, n2, this.count - n2 - 1);
        --this.count;
        return this;
    }

    public synchronized StringBuffer insert(int n2, char c2) {
        int n3 = this.count + 1;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n2, this.value, n2 + 1, this.count - n2);
        this.value[n2] = c2;
        this.count = n3;
        return this;
    }

    public StringBuffer insert(int n2, double d2) {
        return this.insert(n2, String.valueOf(d2));
    }

    public StringBuffer insert(int n2, float f2) {
        return this.insert(n2, String.valueOf(f2));
    }

    public synchronized StringBuffer delete(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            n3 = this.count;
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        if (n4 > 0) {
            if (this.shared) {
                this.copy();
            }
            System.arraycopy(this.value, n2 + n4, this.value, n2, this.count - n3);
            this.count -= n4;
        }
        return this;
    }

    public StringBuffer insert(int n2, int n3) {
        return this.insert(n2, String.valueOf(n3));
    }

    public StringBuffer insert(int n2, long l2) {
        return this.insert(n2, String.valueOf(l2));
    }

    public StringBuffer insert(int n2, boolean bl2) {
        return this.insert(n2, String.valueOf(bl2));
    }

    public synchronized StringBuffer insert(int n2, char[] cArray) {
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = cArray.length;
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n2, this.value, n2 + n3, this.count - n2);
        System.arraycopy(cArray, 0, this.value, n2, n3);
        this.count = n4;
        return this;
    }

    public synchronized StringBuffer insert(int n2, char[] cArray, int n3, int n4) {
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n3 < 0 || n3 + n4 < 0 || n3 + n4 > cArray.length) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n4 < 0) {
            throw new StringIndexOutOfBoundsException(n4);
        }
        int n5 = this.count + n4;
        if (n5 > this.value.length) {
            this.expandCapacity(n5);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n2, this.value, n2 + n4, this.count - n2);
        System.arraycopy(cArray, n3, this.value, n2, n4);
        this.count = n5;
        return this;
    }

    public StringBuffer append(long l2) {
        return this.append(String.valueOf(l2));
    }

    public StringBuffer append(boolean bl2) {
        return this.append(String.valueOf(bl2));
    }

    public synchronized StringBuffer append(char[] cArray) {
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, 0, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray, int n2, int n3) {
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(cArray, n2, this.value, this.count, n3);
        this.count = n4;
        return this;
    }

    public synchronized StringBuffer insert(int n2, Object object) {
        return this.insert(n2, String.valueOf(object));
    }

    public synchronized StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized StringBuffer replace(int n2, int n3, String string) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            n3 = this.count;
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException();
        }
        int n4 = string.length();
        int n5 = this.count + n4 - (n3 - n2);
        if (n5 > this.value.length) {
            this.expandCapacity(n5);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n3, this.value, n2 + n4, this.count - n3);
        string.getChars(0, n4, this.value, n2);
        this.count = n5;
        return this;
    }

    public synchronized StringBuffer insert(int n2, String string) {
        int n3;
        int n4;
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n4 = this.count + (n3 = string.length())) > this.value.length) {
            this.expandCapacity(n4);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n2, this.value, n2 + n3, this.count - n2);
        string.getChars(0, n3, this.value, n2);
        this.count = n4;
        return this;
    }

    public synchronized StringBuffer append(String string) {
        int n2;
        int n3;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + (n2 = string.length())) > this.value.length) {
            this.expandCapacity(n3);
        }
        string.getChars(0, n2, this.value, this.count);
        this.count = n3;
        return this;
    }

    public synchronized StringBuffer append(StringBuffer stringBuffer) {
        int n2;
        int n3;
        if (stringBuffer == null) {
            stringBuffer = NULL;
        }
        if ((n3 = this.count + (n2 = stringBuffer.length())) > this.value.length) {
            this.expandCapacity(n3);
        }
        stringBuffer.getChars(0, n2, this.value, this.count);
        this.count = n3;
        return this;
    }
}

