/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import sun.nio.ch.FileChannelImpl;

public class RandomAccessFile
implements DataOutput,
DataInput {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean rw;
    private static final int O_RDONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_SYNC = 4;
    private static final int O_DSYNC = 8;

    public final byte readByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public final char readChar() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 8) + (n2 << 0));
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public native int read() throws IOException;

    public final int readInt() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
    }

    public final int readUnsignedByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public final int readUnsignedShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + (n2 << 0);
    }

    public native long getFilePointer() throws IOException;

    public native long length() throws IOException;

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final short readShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n3 << 8) + (n2 << 0));
    }

    static {
        RandomAccessFile.initIDs();
    }

    public native void close() throws IOException;

    private static native void initIDs();

    public final boolean readBoolean() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    public final void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public int skipBytes(int n2) throws IOException {
        long l2;
        if (n2 <= 0) {
            return 0;
        }
        long l3 = this.getFilePointer();
        long l4 = l3 + (long)n2;
        if (l4 > (l2 = this.length())) {
            l4 = l2;
        }
        this.seek(l4);
        return (int)(l4 - l3);
    }

    public native void write(int var1) throws IOException;

    public final void writeByte(int n2) throws IOException {
        this.write(n2);
    }

    public final void writeChar(int n2) throws IOException {
        this.write(n2 >>> 8 & 0xFF);
        this.write(n2 >>> 0 & 0xFF);
    }

    public final void writeInt(int n2) throws IOException {
        this.write(n2 >>> 24 & 0xFF);
        this.write(n2 >>> 16 & 0xFF);
        this.write(n2 >>> 8 & 0xFF);
        this.write(n2 >>> 0 & 0xFF);
    }

    public final void writeShort(int n2) throws IOException {
        this.write(n2 >>> 8 & 0xFF);
        this.write(n2 >>> 0 & 0xFF);
    }

    public native void seek(long var1) throws IOException;

    public native void setLength(long var1) throws IOException;

    public final void writeLong(long l2) throws IOException {
        this.write((int)(l2 >>> 56) & 0xFF);
        this.write((int)(l2 >>> 48) & 0xFF);
        this.write((int)(l2 >>> 40) & 0xFF);
        this.write((int)(l2 >>> 32) & 0xFF);
        this.write((int)(l2 >>> 24) & 0xFF);
        this.write((int)(l2 >>> 16) & 0xFF);
        this.write((int)(l2 >>> 8) & 0xFF);
        this.write((int)(l2 >>> 0) & 0xFF);
    }

    public final void writeBoolean(boolean bl2) throws IOException {
        this.write(bl2 ? 1 : 0);
    }

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.readBytes(byArray, n2, n3);
    }

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public final void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        do {
            if ((n4 = this.read(byArray, n2 + n5, n3 - n5)) >= 0) continue;
            throw new EOFException();
        } while ((n5 += n4) < n3);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.writeBytes(byArray, n2, n3);
    }

    private native void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        boolean bl2 = false;
        block4: while (!bl2) {
            n2 = this.read();
            switch (n2) {
                case -1: 
                case 10: {
                    bl2 = true;
                    break;
                }
                case 13: {
                    bl2 = true;
                    long l2 = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(l2);
                    break;
                }
                default: {
                    stringBuffer.append((char)n2);
                }
            }
        }
        if (n2 == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final void writeBytes(String string) throws IOException {
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        string.getBytes(0, n2, byArray, 0);
        this.writeBytes(byArray, 0, n2);
    }

    public final void writeChars(String string) throws IOException {
        int n2 = string.length();
        int n3 = 2 * n2;
        byte[] byArray = new byte[n3];
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            byArray[n5++] = (byte)(cArray[n4] >>> 8);
            byArray[n5++] = (byte)(cArray[n4] >>> 0);
            ++n4;
        }
        this.writeBytes(byArray, 0, n3);
    }

    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    private native void open(String var1, int var2) throws FileNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileChannel getChannel() {
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, true, this.rw, this);
            }
            return this.channel;
        }
    }

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
        String string2 = file != null ? file.getPath() : null;
        int n2 = -1;
        if (string.equals("r")) {
            n2 = 1;
        } else if (string.startsWith("rw")) {
            n2 = 2;
            this.rw = true;
            if (string.length() > 2) {
                n2 = string.equals("rws") ? (n2 |= 4) : (string.equals("rwd") ? (n2 |= 8) : -1);
            }
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal mode \"" + string + "\" must be one of " + "\"r\", \"rw\", \"rws\"," + " or \"rwd\"");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string2);
            if (this.rw) {
                securityManager.checkWrite(string2);
            }
        }
        this.fd = new FileDescriptor();
        this.open(string2, n2);
    }

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
        this(string != null ? new File(string) : null, string2);
    }
}

