/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IdentityHashtable;
import java.util.HashMap;

class NameGenerator {
    private static HashMap valueToName;
    private static HashMap instanceCountsByClassName;

    static {
        NameGenerator.init();
    }

    NameGenerator() {
    }

    static void clear() {
        NameGenerator.init();
    }

    private static void init() {
        valueToName = new IdentityHashtable();
        instanceCountsByClassName = new HashMap();
    }

    private static String unqualifiedClassName(Class clazz) {
        if (clazz.isArray()) {
            return NameGenerator.unqualifiedClassName(clazz.getComponentType()) + "Array";
        }
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    static String instanceName(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Class) {
            return NameGenerator.unqualifiedClassName((Class)object);
        }
        String string = (String)valueToName.get(object);
        if (string != null) {
            return string;
        }
        Class clazz = object.getClass();
        String string2 = NameGenerator.unqualifiedClassName(clazz);
        Object object2 = instanceCountsByClassName.get(string2);
        int n2 = object2 == null ? 0 : (Integer)object2 + 1;
        instanceCountsByClassName.put(string2, new Integer(n2));
        string = string2 + n2;
        valueToName.put(object, string);
        return string;
    }

    static String replace(String string, char c2, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != c2) {
                stringBuffer.append(string.charAt(n2));
            } else {
                stringBuffer.append(string2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

