/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ArrayPersistenceDelegate;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.ExceptionListener;
import java.beans.Introspector;
import java.beans.NullPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.beans.PrimitivePersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.ProxyPersistenceDelegate;
import java.beans.Statement;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Vector;

class MetaData {
    private static Hashtable internalPersistenceDelegates = new Hashtable();
    private static Hashtable transientProperties = new Hashtable();
    private static PersistenceDelegate nullPersistenceDelegate = new NullPersistenceDelegate();
    private static PersistenceDelegate primitivePersistenceDelegate = new PrimitivePersistenceDelegate();
    private static PersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate();
    private static PersistenceDelegate arrayPersistenceDelegate;
    private static PersistenceDelegate proxyPersistenceDelegate;

    static {
        MetaData.registerConstructor("java.util.Date", new String[]{"time"});
        MetaData.registerConstructor("java.beans.Statement", new String[]{"target", "methodName", "arguments"});
        MetaData.registerConstructor("java.beans.Expression", new String[]{"target", "methodName", "arguments"});
        MetaData.registerConstructor("java.beans.EventHandler", new String[]{"target", "action", "eventPropertyName", "listenerMethodName"});
        MetaData.registerConstructor("java.awt.Point", new String[]{"x", "y"});
        MetaData.registerConstructor("java.awt.Dimension", new String[]{"width", "height"});
        MetaData.registerConstructor("java.awt.Rectangle", new String[]{"x", "y", "width", "height"});
        MetaData.registerConstructor("java.awt.Insets", new String[]{"top", "left", "bottom", "right"});
        MetaData.registerConstructor("java.awt.Color", new String[]{"red", "green", "blue", "alpha"});
        MetaData.registerConstructor("java.awt.Font", new String[]{"name", "style", "size"});
        MetaData.registerConstructor("java.awt.Cursor", new String[]{"type"});
        MetaData.registerConstructor("java.awt.GridBagConstraints", new String[]{"gridx", "gridy", "gridwidth", "gridheight", "weightx", "weighty", "anchor", "fill", "insets", "ipadx", "ipady"});
        MetaData.registerConstructor("java.awt.ScrollPane", new String[]{"scrollbarDisplayPolicy"});
        MetaData.registerConstructor("javax.swing.plaf.FontUIResource", new String[]{"name", "style", "size"});
        MetaData.registerConstructor("javax.swing.plaf.ColorUIResource", new String[]{"red", "green", "blue"});
        MetaData.registerConstructor("javax.swing.tree.TreePath", new String[]{"path"});
        MetaData.registerConstructor("javax.swing.OverlayLayout", new String[]{"target"});
        MetaData.registerConstructor("javax.swing.BoxLayout", new String[]{"target", "axis"});
        MetaData.registerConstructor("javax.swing.DefaultCellEditor", new String[]{"component"});
        MetaData.registerConstructor("javax.swing.JSplitPane", new String[]{"orientation"});
        MetaData.registerConstructor("javax.swing.ImageIcon", new String[]{"description"});
        MetaData.registerConstructor("javax.swing.JButton", new String[]{"label"});
        MetaData.registerConstructor("javax.swing.border.BevelBorder", new String[]{"bevelType", "highlightOuter", "highlightInner", "shadowOuter", "shadowInner"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$BevelBorderUIResource", new String[]{"bevelType", "highlightOuter", "highlightInner", "shadowOuter", "shadowInner"});
        MetaData.registerConstructor("javax.swing.border.CompoundBorder", new String[]{"outsideBorder", "insideBorder"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$CompoundBorderUIResource", new String[]{"outsideBorder", "insideBorder"});
        MetaData.registerConstructor("javax.swing.border.EmptyBorder", new String[]{"top", "left", "bottom", "right"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new String[]{"top", "left", "bottom", "right"});
        MetaData.registerConstructor("javax.swing.border.EtchedBorder", new String[]{"etchType", "highlight", "shadow"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$EtchedBorderUIResource", new String[]{"etchType", "highlight", "shadow"});
        MetaData.registerConstructor("javax.swing.border.LineBorder", new String[]{"lineColor", "thickness"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new String[]{"lineColor", "thickness"});
        MetaData.registerConstructor("javax.swing.border.MatteBorder", new String[]{"top", "left", "bottom", "right", "tileIcon"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new String[]{"top", "left", "bottom", "right", "tileIcon"});
        MetaData.registerConstructor("javax.swing.border.SoftBevelBorder", new String[]{"bevelType", "highlightOuter", "highlightInner", "shadowOuter", "shadowInner"});
        MetaData.registerConstructor("javax.swing.border.TitledBorder", new String[]{"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$TitledBorderUIResource", new String[]{"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"});
        MetaData.removeProperty("java.awt.geom.RectangularShape", "frame");
        MetaData.removeProperty("java.awt.Rectangle", "bounds");
        MetaData.removeProperty("java.awt.Dimension", "size");
        MetaData.removeProperty("java.awt.Point", "location");
        MetaData.removeProperty("java.awt.Component", "foreground");
        MetaData.removeProperty("java.awt.Component", "background");
        MetaData.removeProperty("java.awt.Component", "font");
        MetaData.removeProperty("java.awt.Component", "visible");
        MetaData.removeProperty("java.awt.ScrollPane", "scrollPosition");
        MetaData.removeProperty("javax.swing.JComponent", "minimumSize");
        MetaData.removeProperty("javax.swing.JComponent", "preferredSize");
        MetaData.removeProperty("javax.swing.JComponent", "maximumSize");
        MetaData.removeProperty("javax.swing.ImageIcon", "image");
        MetaData.removeProperty("javax.swing.ImageIcon", "imageObserver");
        MetaData.removeProperty("javax.swing.JMenu", "accelerator");
        MetaData.removeProperty("javax.swing.JMenuItem", "accelerator");
        MetaData.removeProperty("javax.swing.JMenuBar", "helpMenu");
        MetaData.removeProperty("javax.swing.JScrollPane", "verticalScrollBar");
        MetaData.removeProperty("javax.swing.JScrollPane", "horizontalScrollBar");
        MetaData.removeProperty("javax.swing.JScrollPane", "rowHeader");
        MetaData.removeProperty("javax.swing.JScrollPane", "columnHeader");
        MetaData.removeProperty("javax.swing.JViewport", "extentSize");
        MetaData.removeProperty("javax.swing.table.JTableHeader", "defaultRenderer");
        MetaData.removeProperty("javax.swing.JList", "cellRenderer");
        MetaData.removeProperty("javax.swing.JList", "selectedIndices");
        MetaData.removeProperty("javax.swing.DefaultListSelectionModel", "leadSelectionIndex");
        MetaData.removeProperty("javax.swing.DefaultListSelectionModel", "anchorSelectionIndex");
        MetaData.removeProperty("javax.swing.JComboBox", "selectedIndex");
        MetaData.removeProperty("javax.swing.JTabbedPane", "selectedIndex");
        MetaData.removeProperty("javax.swing.JTabbedPane", "selectedComponent");
        MetaData.removeProperty("javax.swing.AbstractButton", "disabledIcon");
        MetaData.removeProperty("javax.swing.JLabel", "disabledIcon");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "caret");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "caretPosition");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "selectionStart");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "selectionEnd");
    }

    MetaData() {
    }

    private static boolean isPrimitive(Class clazz) {
        return Statement.primitiveTypeFor(clazz) != null;
    }

    static BeanInfo getBeanInfo(Class clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return beanInfo;
    }

    static PersistenceDelegate getPersistenceDelegate(Class clazz) {
        Object object;
        if (clazz == null) {
            return nullPersistenceDelegate;
        }
        if (MetaData.isPrimitive(clazz)) {
            return primitivePersistenceDelegate;
        }
        if (clazz.isArray()) {
            if (arrayPersistenceDelegate == null) {
                arrayPersistenceDelegate = new ArrayPersistenceDelegate();
            }
            return arrayPersistenceDelegate;
        }
        try {
            if (Proxy.isProxyClass(clazz)) {
                if (proxyPersistenceDelegate == null) {
                    proxyPersistenceDelegate = new ProxyPersistenceDelegate();
                }
                return proxyPersistenceDelegate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = clazz.getName();
        if (MetaData.getBeanAttribute(clazz, "transient_init") == null) {
            object = (Vector)transientProperties.get(string);
            if (object != null) {
                int n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    MetaData.setPropertyAttribute(clazz, (String)((Vector)object).get(n2), "transient", Boolean.TRUE);
                    ++n2;
                }
            }
            MetaData.setBeanAttribute(clazz, "transient_init", Boolean.TRUE);
        }
        if ((object = (PersistenceDelegate)MetaData.getBeanAttribute(clazz, "persistenceDelegate")) == null) {
            object = MetaData.getInternalPersistenceDelegate(string);
            if (object != null) {
                return object;
            }
            MetaData.setInternalPersistenceDelegate(string, defaultPersistenceDelegate);
            try {
                String string2 = clazz.getName();
                Class clazz2 = Class.forName("java.beans." + string2.replace('.', '_') + "_PersistenceDelegate");
                object = (PersistenceDelegate)clazz2.newInstance();
                MetaData.setInternalPersistenceDelegate(string, (PersistenceDelegate)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                System.err.println("Internal error: " + exception);
            }
        }
        return object != null ? object : defaultPersistenceDelegate;
    }

    static void setPersistenceDelegate(Class clazz, PersistenceDelegate persistenceDelegate) {
        MetaData.setBeanAttribute(clazz, "persistenceDelegate", persistenceDelegate);
    }

    private static PersistenceDelegate getInternalPersistenceDelegate(String string) {
        return (PersistenceDelegate)internalPersistenceDelegates.get(string);
    }

    private static void setInternalPersistenceDelegate(String string, PersistenceDelegate persistenceDelegate) {
        internalPersistenceDelegates.put(string, persistenceDelegate);
    }

    static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static void removeProperty(String string, String string2) {
        Vector vector = (Vector)transientProperties.get(string);
        if (vector == null) {
            vector = new Vector();
            transientProperties.put(string, vector);
        }
        vector.add(string2);
    }

    private static void registerConstructor(String string, String[] stringArray) {
        MetaData.setInternalPersistenceDelegate(string, new DefaultPersistenceDelegate(stringArray));
    }

    static Field typeToField(Class clazz) {
        try {
            return Statement.typeToClass(clazz).getDeclaredField("TYPE");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) {
        BeanInfo beanInfo = MetaData.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            if (string.equals(propertyDescriptor.getName())) {
                return propertyDescriptor;
            }
            ++n2;
        }
        return null;
    }

    private static Object getBeanAttribute(Class clazz, String string) {
        return MetaData.getBeanInfo(clazz).getBeanDescriptor().getValue(string);
    }

    private static void setBeanAttribute(Class clazz, String string, Object object) {
        MetaData.getBeanInfo(clazz).getBeanDescriptor().setValue(string, object);
    }

    private static void setPropertyAttribute(Class clazz, String string, String string2, Object object) {
        PropertyDescriptor propertyDescriptor = MetaData.getPropertyDescriptor(clazz, string);
        if (propertyDescriptor == null) {
            System.err.println("Warning: property " + string + " is not defined on " + clazz);
            return;
        }
        propertyDescriptor.setValue(string2, object);
    }

    static Object getPrivateField(Object object, Class clazz, String string, ExceptionListener exceptionListener) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            exceptionListener.exceptionThrown(exception);
            return null;
        }
    }
}

