/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ShortLookupTable
extends LookupTable {
    short[][] data;

    public final short[][] getTable() {
        return this.data;
    }

    public ShortLookupTable(int n2, short[] sArray) {
        super(n2, sArray.length);
        this.numComponents = 1;
        this.numEntries = sArray.length;
        this.data = new short[1][];
        this.data[0] = sArray;
    }

    public ShortLookupTable(int n2, short[][] sArray) {
        super(n2, sArray.length);
        this.numComponents = sArray.length;
        this.numEntries = sArray[0].length;
        this.data = new short[this.numComponents][];
        int n3 = 0;
        while (n3 < this.numComponents) {
            this.data[n3] = sArray[n3];
            ++n3;
        }
    }

    public int[] lookupPixel(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.numComponents == 1) {
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = (nArray[n2] & 0xFFFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n2 + "]-offset is " + "less than zero");
                }
                nArray2[n2] = this.data[0][n3];
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < nArray.length) {
                int n5 = (nArray[n4] & 0xFFFF) - this.offset;
                if (n5 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n4 + "]-offset is " + "less than zero");
                }
                nArray2[n4] = this.data[n4][n5];
                ++n4;
            }
        }
        return nArray2;
    }

    public short[] lookupPixel(short[] sArray, short[] sArray2) {
        if (sArray2 == null) {
            sArray2 = new short[sArray.length];
        }
        if (this.numComponents == 1) {
            int n2 = 0;
            while (n2 < sArray.length) {
                int n3 = (sArray[n2] & 0xFFFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n2 + "]-offset is " + "less than zero");
                }
                sArray2[n2] = this.data[0][n3];
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < sArray.length) {
                int n5 = (sArray[n4] & 0xFFFF) - this.offset;
                if (n5 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n4 + "]-offset is " + "less than zero");
                }
                sArray2[n4] = this.data[n4][n5];
                ++n4;
            }
        }
        return sArray2;
    }
}

