/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class ReplicateScaleFilter
extends ImageFilter {
    protected int srcWidth;
    protected int srcHeight;
    protected int destWidth;
    protected int destHeight;
    protected int[] srcrows;
    protected int[] srccols;
    protected Object outpixbuf;

    private void calculateMaps() {
        this.srcrows = new int[this.destHeight + 1];
        int n2 = 0;
        while (n2 <= this.destHeight) {
            this.srcrows[n2] = (2 * n2 * this.srcHeight + this.srcHeight) / (2 * this.destHeight);
            ++n2;
        }
        this.srccols = new int[this.destWidth + 1];
        int n3 = 0;
        while (n3 <= this.destWidth) {
            this.srccols[n3] = (2 * n3 * this.srcWidth + this.srcWidth) / (2 * this.destWidth);
            ++n3;
        }
    }

    public ReplicateScaleFilter(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("Width (" + n2 + ") and height (" + n3 + ") must be non-zero");
        }
        this.destWidth = n2;
        this.destHeight = n3;
    }

    public void setDimensions(int n2, int n3) {
        this.srcWidth = n2;
        this.srcHeight = n3;
        if (this.destWidth < 0) {
            if (this.destHeight < 0) {
                this.destWidth = this.srcWidth;
                this.destHeight = this.srcHeight;
            } else {
                this.destWidth = this.srcWidth * this.destHeight / this.srcHeight;
            }
        } else if (this.destHeight < 0) {
            this.destHeight = this.srcHeight * this.destWidth / this.srcWidth;
        }
        this.consumer.setDimensions(this.destWidth, this.destHeight);
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        int n8;
        byte[] byArray2;
        if (this.srcrows == null || this.srccols == null) {
            this.calculateMaps();
        }
        int n9 = (2 * n2 * this.destWidth + this.srcWidth - 1) / (2 * this.srcWidth);
        int n10 = (2 * n3 * this.destHeight + this.srcHeight - 1) / (2 * this.srcHeight);
        if (this.outpixbuf != null && this.outpixbuf instanceof byte[]) {
            byArray2 = (byte[])this.outpixbuf;
        } else {
            byArray2 = new byte[this.destWidth];
            this.outpixbuf = byArray2;
        }
        int n11 = n10;
        while ((n8 = this.srcrows[n11]) < n3 + n5) {
            int n12;
            int n13 = n6 + n7 * (n8 - n3);
            int n14 = n9;
            while ((n12 = this.srccols[n14]) < n2 + n4) {
                byArray2[n14] = byArray[n13 + n12 - n2];
                ++n14;
            }
            if (n14 > n9) {
                this.consumer.setPixels(n9, n11, n14 - n9, 1, colorModel, byArray2, n9, this.destWidth);
            }
            ++n11;
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        int n8;
        int[] nArray2;
        if (this.srcrows == null || this.srccols == null) {
            this.calculateMaps();
        }
        int n9 = (2 * n2 * this.destWidth + this.srcWidth - 1) / (2 * this.srcWidth);
        int n10 = (2 * n3 * this.destHeight + this.srcHeight - 1) / (2 * this.srcHeight);
        if (this.outpixbuf != null && this.outpixbuf instanceof int[]) {
            nArray2 = (int[])this.outpixbuf;
        } else {
            nArray2 = new int[this.destWidth];
            this.outpixbuf = nArray2;
        }
        int n11 = n10;
        while ((n8 = this.srcrows[n11]) < n3 + n5) {
            int n12;
            int n13 = n6 + n7 * (n8 - n3);
            int n14 = n9;
            while ((n12 = this.srccols[n14]) < n2 + n4) {
                nArray2[n14] = nArray[n13 + n12 - n2];
                ++n14;
            }
            if (n14 > n9) {
                this.consumer.setPixels(n9, n11, n14 - n9, 1, colorModel, nArray2, n9, this.destWidth);
            }
            ++n11;
        }
    }

    public void setProperties(Hashtable hashtable) {
        hashtable = (Hashtable)hashtable.clone();
        String string = "rescale";
        String string2 = this.destWidth + "x" + this.destHeight;
        Object object = hashtable.get(string);
        if (object != null && object instanceof String) {
            string2 = (String)object + ", " + string2;
        }
        hashtable.put(string, string2);
        super.setProperties(hashtable);
    }
}

