/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands = 1;
    protected int numBanks = 1;
    protected int scanlineStride;
    protected int pixelStride;

    public final int getNumDataElements() {
        return this.getNumBands();
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = this.width;
        n2 <<= 8;
        n2 ^= this.height;
        n2 <<= 8;
        n2 ^= this.numBands;
        n2 <<= 8;
        n2 ^= this.dataType;
        n2 <<= 8;
        int n3 = 0;
        while (n3 < this.bandOffsets.length) {
            n2 ^= this.bandOffsets[n3];
            n2 <<= 8;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.bankIndices.length) {
            n2 ^= this.bankIndices[n4];
            n2 <<= 8;
            ++n4;
        }
        n2 ^= this.numBands;
        n2 <<= 8;
        n2 ^= this.numBanks;
        n2 <<= 8;
        n2 ^= this.scanlineStride;
        n2 <<= 8;
        return n2 ^= this.pixelStride;
    }

    private long getBufferSize() {
        int n2 = this.bandOffsets[0];
        int n3 = 1;
        while (n3 < this.bandOffsets.length) {
            n2 = Math.max(n2, this.bandOffsets[n3]);
            ++n3;
        }
        long l2 = 0L;
        if (n2 >= 0) {
            l2 += (long)(n2 + 1);
        }
        if (this.pixelStride > 0) {
            l2 += (long)(this.pixelStride * (this.width - 1));
        }
        if (this.scanlineStride > 0) {
            l2 += (long)(this.scanlineStride * (this.height - 1));
        }
        return l2;
    }

    static {
        ColorModel.loadLibraries();
        ComponentSampleModel.initIDs();
    }

    private static native void initIDs();

    public final int[] getBandOffsets() {
        return (int[])this.bandOffsets.clone();
    }

    public final int[] getBankIndices() {
        return (int[])this.bankIndices.clone();
    }

    public final int[] getSampleSize() {
        int[] nArray = new int[this.numBands];
        int n2 = this.getSampleSize(0);
        int n3 = 0;
        while (n3 < this.numBands) {
            nArray[n3] = n2;
            ++n3;
        }
        return nArray;
    }

    public final int getSampleSize(int n2) {
        return DataBuffer.getDataTypeSize(this.dataType);
    }

    public int getOffset(int n2, int n3) {
        int n4 = n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[0];
        return n4;
    }

    public int getOffset(int n2, int n3, int n4) {
        int n5 = n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4];
        return n5;
    }

    public ComponentSampleModel(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        super(n2, n3, n4, nArray.length);
        this.dataType = n2;
        this.pixelStride = n5;
        this.scanlineStride = n6;
        this.bandOffsets = (int[])nArray.clone();
        this.numBands = nArray.length;
        if (n5 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (this.numBands < 1) {
            throw new IllegalArgumentException("Must have at least one band.");
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        this.bankIndices = new int[this.numBands];
        int n7 = 0;
        while (n7 < this.numBands) {
            this.bankIndices[n7] = 0;
            ++n7;
        }
    }

    public ComponentSampleModel(int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2) {
        super(n2, n3, n4, nArray2.length);
        this.dataType = n2;
        this.pixelStride = n5;
        this.scanlineStride = n6;
        this.bandOffsets = (int[])nArray2.clone();
        this.bankIndices = (int[])nArray.clone();
        if (n5 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        int n7 = nArray[0];
        if (n7 < 0) {
            throw new IllegalArgumentException("Index of bank 0 is less than 0 (" + n7 + ")");
        }
        int n8 = 1;
        while (n8 < nArray.length) {
            if (nArray[n8] > n7) {
                n7 = nArray[n8];
            } else if (nArray[n8] < 0) {
                throw new IllegalArgumentException("Index of bank " + n8 + " is less than 0 (" + n7 + ")");
            }
            ++n8;
        }
        this.numBanks = n7 + 1;
        this.numBands = nArray2.length;
        if (nArray2.length != nArray.length) {
            throw new IllegalArgumentException("Length of bandOffsets must equal length of bankIndices.");
        }
    }

    int[] orderBands(int[] nArray, int n2) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray2[n3] = n3;
            ++n3;
        }
        int n4 = 0;
        while (n4 < nArray3.length) {
            int n5 = n4;
            int n6 = n4 + 1;
            while (n6 < nArray3.length) {
                if (nArray[nArray2[n5]] > nArray[nArray2[n6]]) {
                    n5 = n6;
                }
                ++n6;
            }
            nArray3[nArray2[n5]] = n4 * n2;
            nArray2[n5] = nArray2[n4];
            ++n4;
        }
        return nArray3;
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n2 = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n2, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n2, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(n2, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(n2, this.numBanks);
            }
        }
        return dataBuffer;
    }

    public void setSample(int n2, int n3, int n4, double d2, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4], d2);
    }

    public void setSample(int n2, int n3, int n4, float f2, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4], f2);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n6];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = n7;
            int n11 = 0;
            while (n11 < n4) {
                dataBuffer.setElem(this.bankIndices[n6], n10, nArray[n8++]);
                n10 += this.pixelStride;
                ++n11;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        int n7 = n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n6];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = n7;
            int n11 = 0;
            while (n11 < n4) {
                nArray2[n8++] = dataBuffer.getElem(this.bankIndices[n6], n10);
                n10 += this.pixelStride;
                ++n11;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
        return nArray2;
    }

    public void setSample(int n2, int n3, int n4, int n5, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElem(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4], n5);
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = 0;
                while (n11 < this.numBands) {
                    dataBuffer.setElem(this.bankIndices[n11], n9 + this.bandOffsets[n11], nArray[n7++]);
                    ++n11;
                }
                n9 += this.pixelStride;
                ++n10;
            }
            n6 += this.scanlineStride;
            ++n8;
        }
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5 * this.numBands];
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = 0;
                while (n11 < this.numBands) {
                    nArray2[n7++] = dataBuffer.getElem(this.bankIndices[n11], n9 + this.bandOffsets[n11]);
                    ++n11;
                }
                n9 += this.pixelStride;
                ++n10;
            }
            n6 += this.scanlineStride;
            ++n8;
        }
        return nArray2;
    }

    public double getSampleDouble(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        double d2 = dataBuffer.getElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4]);
        return d2;
    }

    public float getSampleFloat(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        float f2 = dataBuffer.getElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4]);
        return f2;
    }

    public int getSample(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = dataBuffer.getElem(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4]);
        return n5;
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n5 = 0;
        while (n5 < this.numBands) {
            dataBuffer.setElem(this.bankIndices[n5], n4 + this.bandOffsets[n5], nArray[n5]);
            ++n5;
        }
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n4 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n5 = 0;
        while (n5 < this.numBands) {
            nArray2[n5] = dataBuffer.getElem(this.bankIndices[n5], n4 + this.bandOffsets[n5]);
            ++n5;
        }
        return nArray2;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int n4;
        int[] nArray;
        Object var3_3 = null;
        int n5 = this.bandOffsets[0];
        int n6 = this.bandOffsets[0];
        int n7 = 1;
        while (n7 < this.bandOffsets.length) {
            n5 = Math.min(n5, this.bandOffsets[n7]);
            n6 = Math.max(n6, this.bandOffsets[n7]);
            ++n7;
        }
        int n8 = this.bandOffsets.length;
        int n9 = Math.abs(this.pixelStride);
        int n10 = Math.abs(this.scanlineStride);
        int n11 = Math.abs(n6 -= n5);
        if (n9 > n10) {
            if (n9 > n11) {
                if (n10 > n11) {
                    nArray = new int[this.bandOffsets.length];
                    n4 = 0;
                    while (n4 < n8) {
                        nArray[n4] = this.bandOffsets[n4] - n5;
                        ++n4;
                    }
                    n10 = n11 + 1;
                    n9 = n10 * n3;
                } else {
                    nArray = this.orderBands(this.bandOffsets, n10 * n3);
                    n9 = n8 * n10 * n3;
                }
            } else {
                n9 = n10 * n3;
                nArray = this.orderBands(this.bandOffsets, n9 * n2);
            }
        } else if (n9 > n11) {
            nArray = new int[this.bandOffsets.length];
            n4 = 0;
            while (n4 < n8) {
                nArray[n4] = this.bandOffsets[n4] - n5;
                ++n4;
            }
            n9 = n11 + 1;
            n10 = n9 * n2;
        } else if (n10 > n11) {
            nArray = this.orderBands(this.bandOffsets, n9 * n2);
            n10 = n8 * n9 * n2;
        } else {
            n10 = n9 * n2;
            nArray = this.orderBands(this.bandOffsets, n10 * n3);
        }
        n4 = 0;
        if (this.scanlineStride < 0) {
            n4 += n10 * n3;
            n10 *= -1;
        }
        if (this.pixelStride < 0) {
            n4 += n9 * n2;
            n9 *= -1;
        }
        int n12 = 0;
        while (n12 < n8) {
            int n13 = n12++;
            nArray[n13] = nArray[n13] + n4;
        }
        return new ComponentSampleModel(this.dataType, n2, n3, n9, n10, this.bankIndices, nArray);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = this.bankIndices[nArray[n2]];
            nArray3[n2] = this.bandOffsets[nArray[n2]];
            ++n2;
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)object;
        return this.width == componentSampleModel.width && this.height == componentSampleModel.height && this.numBands == componentSampleModel.numBands && this.dataType == componentSampleModel.dataType && Arrays.equals(this.bandOffsets, componentSampleModel.bandOffsets) && Arrays.equals(this.bankIndices, componentSampleModel.bankIndices) && this.numBands == componentSampleModel.numBands && this.numBanks == componentSampleModel.numBanks && this.scanlineStride == componentSampleModel.scanlineStride && this.pixelStride == componentSampleModel.pixelStride;
    }

    public void setDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        switch (n4) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n7 = 0;
                while (n7 < n5) {
                    dataBuffer.setElem(this.bankIndices[n7], n6 + this.bandOffsets[n7], byArray[n7] & 0xFF);
                    ++n7;
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                int n8 = 0;
                while (n8 < n5) {
                    dataBuffer.setElem(this.bankIndices[n8], n6 + this.bandOffsets[n8], sArray[n8] & 0xFFFF);
                    ++n8;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n9 = 0;
                while (n9 < n5) {
                    dataBuffer.setElem(this.bankIndices[n9], n6 + this.bandOffsets[n9], nArray[n9]);
                    ++n9;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                int n10 = 0;
                while (n10 < n5) {
                    dataBuffer.setElemFloat(this.bankIndices[n10], n6 + this.bandOffsets[n10], fArray[n10]);
                    ++n10;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n11 = 0;
                while (n11 < n5) {
                    dataBuffer.setElemDouble(this.bankIndices[n11], n6 + this.bandOffsets[n11], dArray[n11]);
                    ++n11;
                }
                break;
            }
        }
    }

    public Object getDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        switch (n4) {
            case 0: {
                byte[] byArray = object == null ? new byte[n5] : (byte[])object;
                int n7 = 0;
                while (n7 < n5) {
                    byArray[n7] = (byte)dataBuffer.getElem(this.bankIndices[n7], n6 + this.bandOffsets[n7]);
                    ++n7;
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n5] : (short[])object;
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n8] = (short)dataBuffer.getElem(this.bankIndices[n8], n6 + this.bandOffsets[n8]);
                    ++n8;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n5] : (int[])object;
                int n9 = 0;
                while (n9 < n5) {
                    nArray[n9] = dataBuffer.getElem(this.bankIndices[n9], n6 + this.bandOffsets[n9]);
                    ++n9;
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n5] : (float[])object;
                int n10 = 0;
                while (n10 < n5) {
                    fArray[n10] = dataBuffer.getElemFloat(this.bankIndices[n10], n6 + this.bandOffsets[n10]);
                    ++n10;
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n5] : (double[])object;
                int n11 = 0;
                while (n11 < n5) {
                    dArray[n11] = dataBuffer.getElemDouble(this.bankIndices[n11], n6 + this.bandOffsets[n11]);
                    ++n11;
                }
                object = dArray;
            }
        }
        return object;
    }
}

