/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ReplicateScaleFilter;

public class AreaAveragingScaleFilter
extends ReplicateScaleFilter {
    private static final ColorModel rgbmodel = ColorModel.getRGBdefault();
    private static final int neededHints = 6;
    private boolean passthrough;
    private float[] reds;
    private float[] greens;
    private float[] blues;
    private float[] alphas;
    private int savedy;
    private int savedyrem;

    private void makeAccumBuffers() {
        this.reds = new float[this.destWidth];
        this.greens = new float[this.destWidth];
        this.blues = new float[this.destWidth];
        this.alphas = new float[this.destWidth];
    }

    private int[] calcRow() {
        float f2 = (float)this.srcWidth * (float)this.srcHeight;
        if (this.outpixbuf == null || !(this.outpixbuf instanceof int[])) {
            this.outpixbuf = new int[this.destWidth];
        }
        int[] nArray = (int[])this.outpixbuf;
        int n2 = 0;
        while (n2 < this.destWidth) {
            float f3 = f2;
            int n3 = Math.round(this.alphas[n2] / f3);
            if (n3 <= 0) {
                n3 = 0;
            } else if (n3 >= 255) {
                n3 = 255;
            } else {
                f3 = this.alphas[n2] / 255.0f;
            }
            int n4 = Math.round(this.reds[n2] / f3);
            int n5 = Math.round(this.greens[n2] / f3);
            int n6 = Math.round(this.blues[n2] / f3);
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 255) {
                n5 = 255;
            }
            if (n6 < 0) {
                n6 = 0;
            } else if (n6 > 255) {
                n6 = 255;
            }
            nArray[n2] = n3 << 24 | n4 << 16 | n5 << 8 | n6;
            ++n2;
        }
        return nArray;
    }

    public void setHints(int n2) {
        this.passthrough = (n2 & 6) != 6;
        super.setHints(n2);
    }

    public AreaAveragingScaleFilter(int n2, int n3) {
        super(n2, n3);
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        if (this.passthrough) {
            super.setPixels(n2, n3, n4, n5, colorModel, byArray, n6, n7);
        } else {
            this.accumPixels(n2, n3, n4, n5, colorModel, byArray, n6, n7);
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        if (this.passthrough) {
            super.setPixels(n2, n3, n4, n5, colorModel, nArray, n6, n7);
        } else {
            this.accumPixels(n2, n3, n4, n5, colorModel, nArray, n6, n7);
        }
    }

    private void accumPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, Object object, int n6, int n7) {
        int n8;
        int n9;
        if (this.reds == null) {
            this.makeAccumBuffers();
        }
        int n10 = n3;
        int n11 = this.destHeight;
        if (n10 == 0) {
            n9 = 0;
            n8 = 0;
        } else {
            n9 = this.savedy;
            n8 = this.savedyrem;
        }
        while (n10 < n3 + n5) {
            int n12;
            if (n8 == 0) {
                n12 = 0;
                while (n12 < this.destWidth) {
                    this.blues[n12] = 0.0f;
                    this.greens[n12] = 0.0f;
                    this.reds[n12] = 0.0f;
                    this.alphas[n12] = 0.0f;
                    ++n12;
                }
                n8 = this.srcHeight;
            }
            int n13 = n11 < n8 ? n11 : n8;
            n12 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = this.srcWidth;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            while (n12 < n4) {
                float f6;
                int n17;
                if (n15 == 0) {
                    n15 = this.destWidth;
                    n17 = object instanceof byte[] ? ((byte[])object)[n6 + n12] & 0xFF : ((int[])object)[n6 + n12];
                    n17 = colorModel.getRGB(n17);
                    f2 = n17 >>> 24;
                    f3 = n17 >> 16 & 0xFF;
                    f4 = n17 >> 8 & 0xFF;
                    f5 = n17 & 0xFF;
                    if (f2 != 255.0f) {
                        f6 = f2 / 255.0f;
                        f3 *= f6;
                        f4 *= f6;
                        f5 *= f6;
                    }
                }
                n17 = n15 < n16 ? n15 : n16;
                f6 = (float)n17 * (float)n13;
                int n18 = n14;
                this.alphas[n18] = this.alphas[n18] + f6 * f2;
                int n19 = n14;
                this.reds[n19] = this.reds[n19] + f6 * f3;
                int n20 = n14;
                this.greens[n20] = this.greens[n20] + f6 * f4;
                int n21 = n14;
                this.blues[n21] = this.blues[n21] + f6 * f5;
                if ((n15 -= n17) == 0) {
                    ++n12;
                }
                if ((n16 -= n17) != 0) continue;
                ++n14;
                n16 = this.srcWidth;
            }
            if ((n8 -= n13) == 0) {
                int[] nArray = this.calcRow();
                do {
                    this.consumer.setPixels(0, n9, this.destWidth, 1, rgbmodel, nArray, 0, this.destWidth);
                    ++n9;
                } while ((n11 -= n13) >= n13 && n13 == this.srcHeight);
            } else {
                n11 -= n13;
            }
            if (n11 != 0) continue;
            n11 = this.destHeight;
            ++n10;
            n6 += n7;
        }
        this.savedyrem = n8;
        this.savedy = n9;
    }
}

