/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import sun.awt.font.Decoration;
import sun.awt.font.FontResolver;

final class StyledParagraph {
    private int length;
    private Decoration decoration;
    private Object font;
    private Vector decorations;
    int[] decorationStarts;
    private Vector fonts;
    int[] fontStarts;
    private static int INITIAL_SIZE = 8;

    public int getRunLimit(int n2) {
        int n3;
        if (n2 < 0 || n2 >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        int n4 = this.length;
        if (this.decorations != null) {
            n3 = StyledParagraph.findRunContaining(n2, this.decorationStarts);
            n4 = this.decorationStarts[n3 + 1];
        }
        n3 = this.length;
        if (this.fonts != null) {
            int n5 = StyledParagraph.findRunContaining(n2, this.fontStarts);
            n3 = this.fontStarts[n5 + 1];
        }
        return Math.min(n4, n3);
    }

    private static int findRunContaining(int n2, int[] nArray) {
        int n3 = 1;
        while (nArray[n3] <= n2) {
            ++n3;
        }
        return n3 - 1;
    }

    private static void deleteFrom(int n2, int[] nArray, int n3) {
        while (nArray[--n3] > n2) {
            int n4 = n3;
            nArray[n4] = nArray[n4] - 1;
        }
    }

    private static void insertInto(int n2, int[] nArray, int n3) {
        while (nArray[--n3] > n2) {
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
        }
    }

    public Object getFontOrGraphicAt(int n2) {
        if (n2 < 0 || n2 >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.fonts == null) {
            return this.font;
        }
        int n3 = StyledParagraph.findRunContaining(n2, this.fontStarts);
        return this.fonts.elementAt(n3);
    }

    private void addFont(Object object, int n2) {
        if (this.fonts != null) {
            this.fontStarts = StyledParagraph.addToVector(object, n2, this.fonts, this.fontStarts);
        } else if (this.font == null) {
            this.font = object;
        } else if (!this.font.equals(object)) {
            this.fonts = new Vector(INITIAL_SIZE);
            this.fonts.addElement(this.font);
            this.fonts.addElement(object);
            this.fontStarts = new int[INITIAL_SIZE];
            this.fontStarts[0] = 0;
            this.fontStarts[1] = n2;
        }
    }

    public StyledParagraph(AttributedCharacterIterator attributedCharacterIterator, char[] cArray) {
        int n2;
        int n3 = attributedCharacterIterator.getBeginIndex();
        int n4 = attributedCharacterIterator.getEndIndex();
        this.length = n4 - n3;
        int n5 = n3;
        attributedCharacterIterator.first();
        do {
            n2 = attributedCharacterIterator.getRunLimit();
            int n6 = n5 - n3;
            Map map = attributedCharacterIterator.getAttributes();
            map = StyledParagraph.addInputMethodAttrs(map);
            Decoration decoration = Decoration.getDecoration(map);
            this.addDecoration(decoration, n6);
            Object object = StyledParagraph.getGraphicOrFont(map);
            if (object == null) {
                this.addFonts(cArray, map, n6, n2 - n3);
            } else {
                this.addFont(object, n6);
            }
            attributedCharacterIterator.setIndex(n2);
        } while ((n5 = n2) < n4);
        if (this.decorations != null) {
            this.decorationStarts = StyledParagraph.addToVector(this, this.length, this.decorations, this.decorationStarts);
        }
        if (this.fonts != null) {
            this.fontStarts = StyledParagraph.addToVector(this, this.length, this.fonts, this.fontStarts);
        }
    }

    private void addFonts(char[] cArray, Map map, int n2, int n3) {
        FontResolver fontResolver = FontResolver.getInstance();
        do {
            int n4 = n2;
            int n5 = fontResolver.getFontIndex(cArray[n2]);
            ++n2;
            while (n2 < n3) {
                if (fontResolver.getFontIndex(cArray[n2]) != n5) break;
                ++n2;
            }
            this.addFont(fontResolver.getFont(n5, map), n4);
        } while (n2 < n3);
    }

    public Decoration getDecorationAt(int n2) {
        if (n2 < 0 || n2 >= this.length) {
            throw new IllegalArgumentException("index out of range");
        }
        if (this.decorations == null) {
            return this.decoration;
        }
        int n3 = StyledParagraph.findRunContaining(n2, this.decorationStarts);
        return (Decoration)this.decorations.elementAt(n3);
    }

    private void addDecoration(Decoration decoration, int n2) {
        if (this.decorations != null) {
            this.decorationStarts = StyledParagraph.addToVector(decoration, n2, this.decorations, this.decorationStarts);
        } else if (this.decoration == null) {
            this.decoration = decoration;
        } else if (!this.decoration.equals(decoration)) {
            this.decorations = new Vector(INITIAL_SIZE);
            this.decorations.addElement(this.decoration);
            this.decorations.addElement(decoration);
            this.decorationStarts = new int[INITIAL_SIZE];
            this.decorationStarts[0] = 0;
            this.decorationStarts[1] = n2;
        }
    }

    private static Object getGraphicOrFont(Map map) {
        Object object = map.get(TextAttribute.CHAR_REPLACEMENT);
        if (object != null) {
            return object;
        }
        object = map.get(TextAttribute.FONT);
        if (object != null) {
            return object;
        }
        if (map.get(TextAttribute.FAMILY) != null) {
            return Font.getFont(map);
        }
        return null;
    }

    static Map addInputMethodAttrs(Map map) {
        block7: {
            Object object = map.get(TextAttribute.INPUT_METHOD_HIGHLIGHT);
            try {
                Object object2;
                if (object == null) break block7;
                if (object instanceof Annotation) {
                    object = ((Annotation)object).getValue();
                }
                InputMethodHighlight inputMethodHighlight = (InputMethodHighlight)object;
                Map map2 = null;
                try {
                    map2 = inputMethodHighlight.getStyle();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                if (map2 == null) {
                    object2 = Toolkit.getDefaultToolkit();
                    map2 = ((Toolkit)object2).mapInputMethodHighlight(inputMethodHighlight);
                }
                if (map2 != null) {
                    object2 = new Hashtable(5, 0.9f);
                    ((Hashtable)object2).putAll(map);
                    ((Hashtable)object2).putAll(map2);
                    return object2;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        return map;
    }

    private static int[] addToVector(Object object, int n2, Vector vector, int[] nArray) {
        if (!vector.lastElement().equals(object)) {
            vector.addElement(object);
            int n3 = vector.size();
            if (nArray.length == n3) {
                int[] nArray2 = new int[nArray.length * 2];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
            }
            nArray[n3 - 1] = n2;
        }
        return nArray;
    }

    public static StyledParagraph deleteChar(AttributedCharacterIterator attributedCharacterIterator, char[] cArray, int n2, StyledParagraph styledParagraph) {
        n2 -= attributedCharacterIterator.getBeginIndex();
        if (styledParagraph.decorations == null && styledParagraph.fonts == null) {
            --styledParagraph.length;
            return styledParagraph;
        }
        if (styledParagraph.getRunLimit(n2) == n2 + 1 && (n2 == 0 || styledParagraph.getRunLimit(n2 - 1) == n2)) {
            return new StyledParagraph(attributedCharacterIterator, cArray);
        }
        --styledParagraph.length;
        if (styledParagraph.decorations != null) {
            StyledParagraph.deleteFrom(n2, styledParagraph.decorationStarts, styledParagraph.decorations.size());
        }
        if (styledParagraph.fonts != null) {
            StyledParagraph.deleteFrom(n2, styledParagraph.fontStarts, styledParagraph.fonts.size());
        }
        return styledParagraph;
    }

    public static StyledParagraph insertChar(AttributedCharacterIterator attributedCharacterIterator, char[] cArray, int n2, StyledParagraph styledParagraph) {
        char c2 = attributedCharacterIterator.setIndex(n2);
        int n3 = Math.max(n2 - attributedCharacterIterator.getBeginIndex() - 1, 0);
        Map map = StyledParagraph.addInputMethodAttrs(attributedCharacterIterator.getAttributes());
        Decoration decoration = Decoration.getDecoration(map);
        if (!styledParagraph.getDecorationAt(n3).equals(decoration)) {
            return new StyledParagraph(attributedCharacterIterator, cArray);
        }
        Object object = StyledParagraph.getGraphicOrFont(map);
        if (object == null) {
            FontResolver fontResolver = FontResolver.getInstance();
            int n4 = fontResolver.getFontIndex(c2);
            object = fontResolver.getFont(n4, map);
        }
        if (!styledParagraph.getFontOrGraphicAt(n3).equals(object)) {
            return new StyledParagraph(attributedCharacterIterator, cArray);
        }
        ++styledParagraph.length;
        if (styledParagraph.decorations != null) {
            StyledParagraph.insertInto(n3, styledParagraph.decorationStarts, styledParagraph.decorations.size());
        }
        if (styledParagraph.fonts != null) {
            StyledParagraph.insertInto(n3, styledParagraph.fontStarts, styledParagraph.fonts.size());
        }
        return styledParagraph;
    }
}

