/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;

abstract class TexturePaintContext
implements PaintContext {
    public static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    public static ColorModel argbmodel = ColorModel.getRGBdefault();
    ColorModel colorModel;
    int bWidth;
    int bHeight;
    int maxWidth;
    WritableRaster outRas;
    double xOrg;
    double yOrg;
    double incXAcross;
    double incYAcross;
    double incXDown;
    double incYDown;
    int colincx;
    int colincy;
    int colincxerr;
    int colincyerr;
    int rowincx;
    int rowincy;
    int rowincxerr;
    int rowincyerr;
    private static WeakReference xrgbRasRef;
    private static WeakReference argbRasRef;
    private static WeakReference byteRasRef;

    public void dispose() {
        TexturePaintContext.dropRaster(this.colorModel, this.outRas);
    }

    static int fractAsInt(double d2) {
        return (int)(d2 % 1.0 * 2.147483647E9);
    }

    static double mod(double d2, double d3) {
        if ((d2 %= d3) < 0.0 && (d2 += d3) >= d3) {
            d2 = 0.0;
        }
        return d2;
    }

    public abstract void setRaster(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static boolean isMaskOK(int n2, boolean bl2) {
        if (bl2 && n2 == 0) {
            return true;
        }
        return n2 == 255 || n2 == 65280 || n2 == 0xFF0000 || n2 == -16777216;
    }

    public static int blend(int[] nArray, int n2, int n3) {
        n2 >>>= 19;
        n3 >>>= 19;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < 4) {
            int n9;
            int n10 = nArray[n8];
            n2 = 4096 - n2;
            if ((n8 & 1) == 0) {
                n3 = 4096 - n3;
            }
            if ((n9 = n2 * n3) != 0) {
                n7 += (n10 >>> 24) * n9;
                n6 += (n10 >>> 16 & 0xFF) * n9;
                n5 += (n10 >>> 8 & 0xFF) * n9;
                n4 += (n10 & 0xFF) * n9;
            }
            ++n8;
        }
        return n7 + 0x800000 >>> 24 << 24 | n6 + 0x800000 >>> 24 << 16 | n5 + 0x800000 >>> 24 << 8 | n4 + 0x800000 >>> 24;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public static boolean isFilterableDCM(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            return TexturePaintContext.isMaskOK(directColorModel.getAlphaMask(), true) && TexturePaintContext.isMaskOK(directColorModel.getRedMask(), false) && TexturePaintContext.isMaskOK(directColorModel.getGreenMask(), false) && TexturePaintContext.isMaskOK(directColorModel.getBlueMask(), false);
        }
        return false;
    }

    public static boolean isFilterableICM(ColorModel colorModel) {
        IndexColorModel indexColorModel;
        return colorModel instanceof IndexColorModel && (indexColorModel = (IndexColorModel)colorModel).getMapSize() <= 256;
    }

    public Raster getRaster(int n2, int n3, int n4, int n5) {
        if (this.outRas == null || this.outRas.getWidth() < n4 || this.outRas.getHeight() < n5) {
            this.outRas = this.makeRaster(n5 == 1 ? Math.max(n4, this.maxWidth) : n4, n5);
        }
        double d2 = TexturePaintContext.mod(this.xOrg + (double)n2 * this.incXAcross + (double)n3 * this.incXDown, this.bWidth);
        double d3 = TexturePaintContext.mod(this.yOrg + (double)n2 * this.incYAcross + (double)n3 * this.incYDown, this.bHeight);
        this.setRaster((int)d2, (int)d3, TexturePaintContext.fractAsInt(d2), TexturePaintContext.fractAsInt(d3), n4, n5, this.bWidth, this.bHeight, this.colincx, this.colincxerr, this.colincy, this.colincyerr, this.rowincx, this.rowincxerr, this.rowincy, this.rowincyerr);
        return this.outRas;
    }

    static synchronized void dropByteRaster(Raster raster) {
        if (raster == null) {
            return;
        }
        byteRasRef = new WeakReference(raster);
    }

    public abstract WritableRaster makeRaster(int var1, int var2);

    TexturePaintContext(ColorModel colorModel, AffineTransform affineTransform, int n2, int n3, int n4) {
        this.colorModel = TexturePaintContext.getInternedColorModel(colorModel);
        this.bWidth = n2;
        this.bHeight = n3;
        this.maxWidth = n4;
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform.setToScale(0.0, 0.0);
        }
        this.incXAcross = TexturePaintContext.mod(affineTransform.getScaleX(), n2);
        this.incYAcross = TexturePaintContext.mod(affineTransform.getShearY(), n3);
        this.incXDown = TexturePaintContext.mod(affineTransform.getShearX(), n2);
        this.incYDown = TexturePaintContext.mod(affineTransform.getScaleY(), n3);
        this.xOrg = affineTransform.getTranslateX();
        this.yOrg = affineTransform.getTranslateY();
        this.colincx = (int)this.incXAcross;
        this.colincy = (int)this.incYAcross;
        this.colincxerr = TexturePaintContext.fractAsInt(this.incXAcross);
        this.colincyerr = TexturePaintContext.fractAsInt(this.incYAcross);
        this.rowincx = (int)this.incXDown;
        this.rowincy = (int)this.incYDown;
        this.rowincxerr = TexturePaintContext.fractAsInt(this.incXDown);
        this.rowincyerr = TexturePaintContext.fractAsInt(this.incYDown);
    }

    public static ColorModel getInternedColorModel(ColorModel colorModel) {
        if (xrgbmodel == colorModel || xrgbmodel.equals(colorModel)) {
            return xrgbmodel;
        }
        if (argbmodel == colorModel || argbmodel.equals(colorModel)) {
            return argbmodel;
        }
        return colorModel;
    }

    static synchronized void dropRaster(ColorModel colorModel, Raster raster) {
        if (raster == null) {
            return;
        }
        if (xrgbmodel == colorModel) {
            xrgbRasRef = new WeakReference(raster);
        } else if (argbmodel == colorModel) {
            argbRasRef = new WeakReference(raster);
        }
    }

    static synchronized WritableRaster makeByteRaster(Raster raster, int n2, int n3) {
        WritableRaster writableRaster;
        if (byteRasRef != null && (writableRaster = (WritableRaster)byteRasRef.get()) != null && writableRaster.getWidth() >= n2 && writableRaster.getHeight() >= n3) {
            byteRasRef = null;
            return writableRaster;
        }
        if (n2 <= 32 && n3 <= 32) {
            n3 = 32;
            n2 = 32;
        }
        return raster.createCompatibleWritableRaster(n2, n3);
    }

    static synchronized WritableRaster makeRaster(ColorModel colorModel, Raster raster, int n2, int n3) {
        if (xrgbmodel == colorModel) {
            WritableRaster writableRaster;
            if (xrgbRasRef != null && (writableRaster = (WritableRaster)xrgbRasRef.get()) != null && writableRaster.getWidth() >= n2 && writableRaster.getHeight() >= n3) {
                xrgbRasRef = null;
                return writableRaster;
            }
            if (n2 <= 32 && n3 <= 32) {
                n3 = 32;
                n2 = 32;
            }
        } else if (argbmodel == colorModel) {
            WritableRaster writableRaster;
            if (argbRasRef != null && (writableRaster = (WritableRaster)argbRasRef.get()) != null && writableRaster.getWidth() >= n2 && writableRaster.getHeight() >= n3) {
                argbRasRef = null;
                return writableRaster;
            }
            if (n2 <= 32 && n3 <= 32) {
                n3 = 32;
                n2 = 32;
            }
        }
        if (raster != null) {
            return raster.createCompatibleWritableRaster(n2, n3);
        }
        return colorModel.createCompatibleWritableRaster(n2, n3);
    }

    public static PaintContext getContext(BufferedImage bufferedImage, AffineTransform affineTransform, RenderingHints renderingHints, Rectangle rectangle) {
        ByteInterleavedRaster byteInterleavedRaster;
        boolean bl2;
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n2 = rectangle.width;
        Object object = renderingHints.get(RenderingHints.KEY_INTERPOLATION);
        boolean bl3 = object == null ? renderingHints.get(RenderingHints.KEY_RENDERING) == RenderingHints.VALUE_RENDER_QUALITY : (bl2 = object != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        if (writableRaster instanceof IntegerInterleavedRaster && (!bl2 || TexturePaintContext.isFilterableDCM(colorModel))) {
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)writableRaster;
            if (integerInterleavedRaster.getNumDataElements() == 1 && integerInterleavedRaster.getPixelStride() == 1) {
                return new Int(integerInterleavedRaster, colorModel, affineTransform, n2, bl2);
            }
        } else if (writableRaster instanceof ByteInterleavedRaster && (byteInterleavedRaster = (ByteInterleavedRaster)writableRaster).getNumDataElements() == 1 && byteInterleavedRaster.getPixelStride() == 1) {
            if (bl2) {
                if (TexturePaintContext.isFilterableICM(colorModel)) {
                    return new ByteFilter(byteInterleavedRaster, colorModel, affineTransform, n2);
                }
            } else {
                return new Byte(byteInterleavedRaster, colorModel, affineTransform, n2);
            }
        }
        return new Any(writableRaster, colorModel, affineTransform, n2, bl2);
    }

    static class Any
    extends TexturePaintContext {
        WritableRaster srcRas;
        boolean filter;

        public void setRaster(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
            Object object = null;
            int n18 = n2;
            int n19 = n3;
            int n20 = n4;
            int n21 = n5;
            WritableRaster writableRaster = this.srcRas;
            WritableRaster writableRaster2 = this.outRas;
            int[] nArray = this.filter ? new int[4] : null;
            int n22 = 0;
            while (n22 < n7) {
                n2 = n18;
                n3 = n19;
                n4 = n20;
                n5 = n21;
                int n23 = 0;
                while (n23 < n6) {
                    object = writableRaster.getDataElements(n2, n3, object);
                    if (this.filter) {
                        int n24;
                        int n25 = n2 + 1;
                        if (n25 >= n8) {
                            n25 = 0;
                        }
                        if ((n24 = n3 + 1) >= n9) {
                            n24 = 0;
                        }
                        nArray[0] = this.colorModel.getRGB(object);
                        object = writableRaster.getDataElements(n25, n3, object);
                        nArray[1] = this.colorModel.getRGB(object);
                        object = writableRaster.getDataElements(n2, n24, object);
                        nArray[2] = this.colorModel.getRGB(object);
                        object = writableRaster.getDataElements(n25, n24, object);
                        nArray[3] = this.colorModel.getRGB(object);
                        int n26 = TexturePaintContext.blend(nArray, n4, n5);
                        object = this.colorModel.getDataElements(n26, object);
                    }
                    writableRaster2.setDataElements(n23, n22, object);
                    if ((n4 += n11) < 0) {
                        n4 &= Integer.MAX_VALUE;
                        ++n2;
                    }
                    if ((n2 += n10) >= n8) {
                        n2 -= n8;
                    }
                    if ((n5 += n13) < 0) {
                        n5 &= Integer.MAX_VALUE;
                        ++n3;
                    }
                    if ((n3 += n12) >= n9) {
                        n3 -= n9;
                    }
                    ++n23;
                }
                if ((n20 += n15) < 0) {
                    n20 &= Integer.MAX_VALUE;
                    ++n18;
                }
                if ((n18 += n14) >= n8) {
                    n18 -= n8;
                }
                if ((n21 += n17) < 0) {
                    n21 &= Integer.MAX_VALUE;
                    ++n19;
                }
                if ((n19 += n16) >= n9) {
                    n19 -= n9;
                }
                ++n22;
            }
        }

        public WritableRaster makeRaster(int n2, int n3) {
            return TexturePaintContext.makeRaster(this.colorModel, this.srcRas, n2, n3);
        }

        public Any(WritableRaster writableRaster, ColorModel colorModel, AffineTransform affineTransform, int n2, boolean bl2) {
            super(colorModel, affineTransform, writableRaster.getWidth(), writableRaster.getHeight(), n2);
            this.srcRas = writableRaster;
            this.filter = bl2;
        }
    }

    static class Byte
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        byte[] inData;
        int inOff;
        int inSpan;
        byte[] outData;
        int outOff;
        int outSpan;

        public void dispose() {
            TexturePaintContext.dropByteRaster(this.outRas);
        }

        public void setRaster(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
            byte[] byArray = this.inData;
            byte[] byArray2 = this.outData;
            int n18 = this.outOff;
            int n19 = this.inSpan;
            int n20 = this.inOff;
            int n21 = this.outSpan;
            boolean bl2 = n10 == 1 && n11 == 0 && n12 == 0 && n13 == 0;
            int n22 = n2;
            int n23 = n3;
            int n24 = n4;
            int n25 = n5;
            if (bl2) {
                n21 -= n6;
            }
            int n26 = 0;
            while (n26 < n7) {
                int n27;
                if (bl2) {
                    int n28;
                    n27 = n20 + n23 * n19 + n8;
                    n2 = n8 - n22;
                    n18 += n6;
                    if (n8 >= 32) {
                        n28 = n6;
                        while (n28 > 0) {
                            int n29 = n28 < n2 ? n28 : n2;
                            System.arraycopy(byArray, n27 - n2, byArray2, n18 - n28, n29);
                            n28 -= n29;
                            if ((n2 -= n29) != 0) continue;
                            n2 = n8;
                        }
                    } else {
                        n28 = n6;
                        while (n28 > 0) {
                            byArray2[n18 - n28] = byArray[n27 - n2];
                            if (--n2 == 0) {
                                n2 = n8;
                            }
                            --n28;
                        }
                    }
                } else {
                    n2 = n22;
                    n3 = n23;
                    n4 = n24;
                    n5 = n25;
                    n27 = 0;
                    while (n27 < n6) {
                        byArray2[n18 + n27] = byArray[n20 + n3 * n19 + n2];
                        if ((n4 += n11) < 0) {
                            n4 &= Integer.MAX_VALUE;
                            ++n2;
                        }
                        if ((n2 += n10) >= n8) {
                            n2 -= n8;
                        }
                        if ((n5 += n13) < 0) {
                            n5 &= Integer.MAX_VALUE;
                            ++n3;
                        }
                        if ((n3 += n12) >= n9) {
                            n3 -= n9;
                        }
                        ++n27;
                    }
                }
                if ((n24 += n15) < 0) {
                    n24 &= Integer.MAX_VALUE;
                    ++n22;
                }
                if ((n22 += n14) >= n8) {
                    n22 -= n8;
                }
                if ((n25 += n17) < 0) {
                    n25 &= Integer.MAX_VALUE;
                    ++n23;
                }
                if ((n23 += n16) >= n9) {
                    n23 -= n9;
                }
                n18 += n21;
                ++n26;
            }
        }

        public WritableRaster makeRaster(int n2, int n3) {
            WritableRaster writableRaster = TexturePaintContext.makeByteRaster(this.srcRas, n2, n3);
            ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)writableRaster;
            this.outData = byteInterleavedRaster.getDataStorage();
            this.outSpan = byteInterleavedRaster.getScanlineStride();
            this.outOff = byteInterleavedRaster.getDataOffset(0);
            return writableRaster;
        }

        public Byte(ByteInterleavedRaster byteInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n2) {
            super(colorModel, affineTransform, byteInterleavedRaster.getWidth(), byteInterleavedRaster.getHeight(), n2);
            this.srcRas = byteInterleavedRaster;
            this.inData = byteInterleavedRaster.getDataStorage();
            this.inSpan = byteInterleavedRaster.getScanlineStride();
            this.inOff = byteInterleavedRaster.getDataOffset(0);
        }
    }

    static class ByteFilter
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        int[] inPalette = new int[256];
        byte[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;

        public void setRaster(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
            byte[] byArray = this.inData;
            int[] nArray = this.outData;
            int n18 = this.outOff;
            int n19 = this.inSpan;
            int n20 = this.inOff;
            int n21 = this.outSpan;
            int n22 = n2;
            int n23 = n3;
            int n24 = n4;
            int n25 = n5;
            int[] nArray2 = new int[4];
            int n26 = 0;
            while (n26 < n7) {
                n2 = n22;
                n3 = n23;
                n4 = n24;
                n5 = n25;
                int n27 = 0;
                while (n27 < n6) {
                    int n28;
                    int n29 = n2 + 1;
                    if (n29 >= n8) {
                        n29 = 0;
                    }
                    if ((n28 = n3 + 1) >= n9) {
                        n28 = 0;
                    }
                    nArray2[0] = this.inPalette[0xFF & byArray[n20 + n2 + n19 * n3]];
                    nArray2[1] = this.inPalette[0xFF & byArray[n20 + n29 + n19 * n3]];
                    nArray2[2] = this.inPalette[0xFF & byArray[n20 + n2 + n19 * n28]];
                    nArray2[3] = this.inPalette[0xFF & byArray[n20 + n29 + n19 * n28]];
                    nArray[n18 + n27] = TexturePaintContext.blend(nArray2, n4, n5);
                    if ((n4 += n11) < 0) {
                        n4 &= Integer.MAX_VALUE;
                        ++n2;
                    }
                    if ((n2 += n10) >= n8) {
                        n2 -= n8;
                    }
                    if ((n5 += n13) < 0) {
                        n5 &= Integer.MAX_VALUE;
                        ++n3;
                    }
                    if ((n3 += n12) >= n9) {
                        n3 -= n9;
                    }
                    ++n27;
                }
                if ((n24 += n15) < 0) {
                    n24 &= Integer.MAX_VALUE;
                    ++n22;
                }
                if ((n22 += n14) >= n8) {
                    n22 -= n8;
                }
                if ((n25 += n17) < 0) {
                    n25 &= Integer.MAX_VALUE;
                    ++n23;
                }
                if ((n23 += n16) >= n9) {
                    n23 -= n9;
                }
                n18 += n21;
                ++n26;
            }
        }

        public WritableRaster makeRaster(int n2, int n3) {
            WritableRaster writableRaster = TexturePaintContext.makeRaster(this.colorModel, null, n2, n3);
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)writableRaster;
            this.outData = integerInterleavedRaster.getDataStorage();
            this.outSpan = integerInterleavedRaster.getScanlineStride();
            this.outOff = integerInterleavedRaster.getDataOffset(0);
            return writableRaster;
        }

        public ByteFilter(ByteInterleavedRaster byteInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n2) {
            super(colorModel.getTransparency() == 1 ? xrgbmodel : argbmodel, affineTransform, byteInterleavedRaster.getWidth(), byteInterleavedRaster.getHeight(), n2);
            ((IndexColorModel)colorModel).getRGBs(this.inPalette);
            this.srcRas = byteInterleavedRaster;
            this.inData = byteInterleavedRaster.getDataStorage();
            this.inSpan = byteInterleavedRaster.getScanlineStride();
            this.inOff = byteInterleavedRaster.getDataOffset(0);
        }
    }

    static class Int
    extends TexturePaintContext {
        IntegerInterleavedRaster srcRas;
        int[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;
        boolean filter;

        public void setRaster(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
            int[] nArray = this.inData;
            int[] nArray2 = this.outData;
            int n18 = this.outOff;
            int n19 = this.inSpan;
            int n20 = this.inOff;
            int n21 = this.outSpan;
            boolean bl2 = this.filter;
            boolean bl3 = n10 == 1 && n11 == 0 && n12 == 0 && n13 == 0 && !bl2;
            int n22 = n2;
            int n23 = n3;
            int n24 = n4;
            int n25 = n5;
            if (bl3) {
                n21 -= n6;
            }
            int[] nArray3 = bl2 ? new int[4] : null;
            int n26 = 0;
            while (n26 < n7) {
                int n27;
                int n28;
                int n29;
                if (bl3) {
                    n29 = n20 + n23 * n19 + n8;
                    n2 = n8 - n22;
                    n18 += n6;
                    if (n8 >= 32) {
                        n28 = n6;
                        while (n28 > 0) {
                            n27 = n28 < n2 ? n28 : n2;
                            System.arraycopy(nArray, n29 - n2, nArray2, n18 - n28, n27);
                            n28 -= n27;
                            if ((n2 -= n27) != 0) continue;
                            n2 = n8;
                        }
                    } else {
                        n28 = n6;
                        while (n28 > 0) {
                            nArray2[n18 - n28] = nArray[n29 - n2];
                            if (--n2 == 0) {
                                n2 = n8;
                            }
                            --n28;
                        }
                    }
                } else {
                    n2 = n22;
                    n3 = n23;
                    n4 = n24;
                    n5 = n25;
                    n29 = 0;
                    while (n29 < n6) {
                        if (bl2) {
                            n28 = n2 + 1;
                            if (n28 >= n8) {
                                n28 = 0;
                            }
                            if ((n27 = n3 + 1) >= n9) {
                                n27 = 0;
                            }
                            nArray3[0] = nArray[n20 + n3 * n19 + n2];
                            nArray3[1] = nArray[n20 + n3 * n19 + n28];
                            nArray3[2] = nArray[n20 + n27 * n19 + n2];
                            nArray3[3] = nArray[n20 + n27 * n19 + n28];
                            nArray2[n18 + n29] = TexturePaintContext.blend(nArray3, n4, n5);
                        } else {
                            nArray2[n18 + n29] = nArray[n20 + n3 * n19 + n2];
                        }
                        if ((n4 += n11) < 0) {
                            n4 &= Integer.MAX_VALUE;
                            ++n2;
                        }
                        if ((n2 += n10) >= n8) {
                            n2 -= n8;
                        }
                        if ((n5 += n13) < 0) {
                            n5 &= Integer.MAX_VALUE;
                            ++n3;
                        }
                        if ((n3 += n12) >= n9) {
                            n3 -= n9;
                        }
                        ++n29;
                    }
                }
                if ((n24 += n15) < 0) {
                    n24 &= Integer.MAX_VALUE;
                    ++n22;
                }
                if ((n22 += n14) >= n8) {
                    n22 -= n8;
                }
                if ((n25 += n17) < 0) {
                    n25 &= Integer.MAX_VALUE;
                    ++n23;
                }
                if ((n23 += n16) >= n9) {
                    n23 -= n9;
                }
                n18 += n21;
                ++n26;
            }
        }

        public WritableRaster makeRaster(int n2, int n3) {
            WritableRaster writableRaster = TexturePaintContext.makeRaster(this.colorModel, this.srcRas, n2, n3);
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)writableRaster;
            this.outData = integerInterleavedRaster.getDataStorage();
            this.outSpan = integerInterleavedRaster.getScanlineStride();
            this.outOff = integerInterleavedRaster.getDataOffset(0);
            return writableRaster;
        }

        public Int(IntegerInterleavedRaster integerInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n2, boolean bl2) {
            super(colorModel, affineTransform, integerInterleavedRaster.getWidth(), integerInterleavedRaster.getHeight(), n2);
            this.srcRas = integerInterleavedRaster;
            this.inData = integerInterleavedRaster.getDataStorage();
            this.inSpan = integerInterleavedRaster.getScanlineStride();
            this.inOff = integerInterleavedRaster.getDataOffset(0);
            this.filter = bl2;
        }
    }
}

