/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Choice
extends Component
implements ItemSelectable,
Accessible {
    Vector pItems;
    int selectedIndex = -1;
    transient ItemListener itemListener;
    private static final String base = "choice";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -4075310674757313071L;
    private int choiceSerializedDataVersion = 1;
    static Class class$java$awt$event$ItemListener;

    public int countItems() {
        return this.pItems.size();
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Choice() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.pItems = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createChoice(this);
            }
            super.addNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Choice choice = this;
        synchronized (choice) {
            if (this.peer != null) {
                ((ChoicePeer)this.peer).removeAll();
            }
            this.pItems.removeAllElements();
            this.selectedIndex = -1;
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n2) {
        Choice choice = this;
        synchronized (choice) {
            this.removeNoInvalidate(n2);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    private void removeNoInvalidate(int n2) {
        this.pItems.removeElementAt(n2);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.remove(n2);
        }
        if (this.pItems.size() == 0) {
            this.selectedIndex = -1;
        } else if (this.selectedIndex == n2) {
            this.select(0);
        } else if (this.selectedIndex > n2) {
            this.select(this.selectedIndex - 1);
        }
    }

    public synchronized void select(int n2) {
        if (n2 >= this.pItems.size() || n2 < 0) {
            throw new IllegalArgumentException("illegal Choice item position: " + n2);
        }
        if (this.pItems.size() > 0) {
            this.selectedIndex = n2;
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            if (choicePeer != null) {
                choicePeer.select(n2);
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = Choice.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex >= 0) {
            Object[] objectArray = new Object[]{this.getItem(this.selectedIndex)};
            return objectArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex >= 0 ? this.getItem(this.selectedIndex) : null;
    }

    protected String paramString() {
        return super.paramString() + ",current=" + this.getSelectedItem();
    }

    public String getItem(int n2) {
        return this.getItemImpl(n2);
    }

    final String getItemImpl(int n2) {
        return (String)this.pItems.elementAt(n2);
    }

    public void add(String string) {
        this.addItem(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(String string) {
        Choice choice = this;
        synchronized (choice) {
            this.addItemNoInvalidate(string);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    private void addItemNoInvalidate(String string) {
        if (string == null) {
            throw new NullPointerException("cannot add null item to Choice");
        }
        this.pItems.addElement(string);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.addItem(string, this.pItems.size() - 1);
        }
        if (this.selectedIndex < 0) {
            this.select(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        Choice choice = this;
        synchronized (choice) {
            int n2 = this.pItems.indexOf(string);
            if (n2 < 0) {
                throw new IllegalArgumentException("item " + string + " not found in choice");
            }
            this.removeNoInvalidate(n2);
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public synchronized void select(String string) {
        int n2 = this.pItems.indexOf(string);
        if (n2 >= 0) {
            this.select(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String string, int n2) {
        Choice choice = this;
        synchronized (choice) {
            if (n2 < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n3 = this.getItemCount();
            Vector vector = new Vector();
            int n4 = n2;
            while (n4 < n3) {
                vector.addElement(this.getItem(n2));
                this.removeNoInvalidate(n2);
                ++n4;
            }
            this.addItemNoInvalidate(string);
            int n5 = 0;
            while (n5 < vector.size()) {
                this.addItemNoInvalidate((String)vector.elementAt(n5));
                ++n5;
            }
        }
        if (this.valid) {
            this.invalidate();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice(this);
        }
        return this.accessibleContext;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        ItemListener itemListener = null;
        if (clazz != (class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = Choice.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener)) {
            return super.getListeners(clazz);
        }
        itemListener = this.itemListener;
        return AWTEventMulticaster.getListeners(itemListener, clazz);
    }

    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        private final Choice this$0;

        public int getAccessibleActionCount() {
            return 0;
        }

        public boolean doAccessibleAction(int n2) {
            return false;
        }

        public AccessibleAWTChoice(Choice choice) {
            this.this$0 = choice;
            super(choice);
        }

        public String getAccessibleActionDescription(int n2) {
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }
    }
}

