/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ButtonPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

public class Button
extends Component
implements Accessible {
    String label;
    String actionCommand;
    transient ActionListener actionListener;
    private static final String base = "button";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -8774683716313001058L;
    private int buttonSerializedDataVersion = 1;
    static Class class$java$awt$event$ActionListener;

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Button.initIDs();
        }
    }

    public Button() throws HeadlessException {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createButton(this);
            }
            super.addNotify();
        }
    }

    private static native void initIDs();

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = Button.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public String getActionCommand() {
        return this.actionCommand == null ? this.label : this.actionCommand;
    }

    public String getLabel() {
        return this.label;
    }

    protected String paramString() {
        return super.paramString() + ",label=" + this.label;
    }

    public Button(String string) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.label = string;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String string) {
        boolean bl2 = false;
        Button button = this;
        synchronized (button) {
            if (!(string == this.label || this.label != null && this.label.equals(string))) {
                this.label = string;
                ButtonPeer buttonPeer = (ButtonPeer)this.peer;
                if (buttonPeer != null) {
                    buttonPeer.setLabel(string);
                }
                bl2 = true;
            }
        }
        if (bl2 && this.valid) {
            this.invalidate();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTButton(this);
        }
        return this.accessibleContext;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        ActionListener actionListener = null;
        if (clazz != (class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = Button.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener)) {
            return super.getListeners(clazz);
        }
        actionListener = this.actionListener;
        return AWTEventMulticaster.getListeners(actionListener, clazz);
    }

    protected class AccessibleAWTButton
    extends Component.AccessibleAWTComponent
    implements AccessibleAction,
    AccessibleValue {
        private final Button this$0;

        public int getAccessibleActionCount() {
            return 1;
        }

        public boolean doAccessibleAction(int n2) {
            if (n2 == 0) {
                Toolkit.getEventQueue().postEvent(new ActionEvent(this.this$0, 1001, this.this$0.getActionCommand()));
                return true;
            }
            return false;
        }

        protected AccessibleAWTButton(Button button) {
            this.this$0 = button;
            super(button);
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.this$0.getLabel() == null) {
                return super.getAccessibleName();
            }
            return this.this$0.getLabel();
        }

        public String getAccessibleActionDescription(int n2) {
            if (n2 == 0) {
                return new String("click");
            }
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }
    }
}

