/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class AWTKeyStroke
implements Serializable {
    private static Map cache;
    private static AWTKeyStroke cacheKey;
    private static Class subclass;
    private static Map modifierKeywords;
    private static Map vkMap;
    private char keyChar = (char)65535;
    private int keyCode = 0;
    private int modifiers;
    private boolean onKeyRelease;
    static Class class$java$awt$AWTKeyStroke;
    static Class class$java$awt$event$KeyEvent;

    public final char getKeyChar() {
        return this.keyChar;
    }

    public final int getKeyCode() {
        return this.keyCode;
    }

    public final int getKeyEventType() {
        if (this.keyCode == 0) {
            return 400;
        }
        return this.onKeyRelease ? 402 : 401;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public int hashCode() {
        return (this.keyChar + '\u0001') * (2 * (this.keyCode + 1)) * (this.modifiers + 1) + (this.onKeyRelease ? 1 : 2);
    }

    static {
        subclass = class$java$awt$AWTKeyStroke == null ? (class$java$awt$AWTKeyStroke = AWTKeyStroke.class$("java.awt.AWTKeyStroke")) : class$java$awt$AWTKeyStroke;
        Toolkit.loadLibraries();
    }

    protected AWTKeyStroke() {
    }

    public final boolean isOnKeyRelease() {
        return this.onKeyRelease;
    }

    protected AWTKeyStroke(char c2, int n2, int n3, boolean bl2) {
        this.keyChar = c2;
        this.keyCode = n2;
        this.modifiers = n3;
        this.onKeyRelease = bl2;
    }

    private static int mapNewModifiers(int n2) {
        if ((n2 & 0x40) != 0) {
            n2 |= 1;
        }
        if ((n2 & 0x200) != 0) {
            n2 |= 8;
        }
        if ((n2 & 0x2000) != 0) {
            n2 |= 0x20;
        }
        if ((n2 & 0x80) != 0) {
            n2 |= 2;
        }
        if ((n2 & 0x100) != 0) {
            n2 |= 4;
        }
        return n2;
    }

    private static int mapOldModifiers(int n2) {
        if ((n2 & 1) != 0) {
            n2 |= 0x40;
        }
        if ((n2 & 8) != 0) {
            n2 |= 0x200;
        }
        if ((n2 & 0x20) != 0) {
            n2 |= 0x2000;
        }
        if ((n2 & 2) != 0) {
            n2 |= 0x80;
        }
        if ((n2 & 4) != 0) {
            n2 |= 0x100;
        }
        if ((n2 & 0x10) != 0) {
            n2 |= 0x400;
        }
        return n2 &= 0x3FC0;
    }

    public static AWTKeyStroke getAWTKeyStroke(char c2) {
        return AWTKeyStroke.getCachedStroke(c2, 0, 0, false);
    }

    private static synchronized AWTKeyStroke getCachedStroke(char c2, int n2, int n3, boolean bl2) {
        if (cache == null) {
            cache = new HashMap();
        }
        if (cacheKey == null) {
            try {
                cacheKey = AWTKeyStroke.allocateNewInstance(subclass);
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        AWTKeyStroke.cacheKey.keyChar = c2;
        AWTKeyStroke.cacheKey.keyCode = n2;
        AWTKeyStroke.cacheKey.modifiers = AWTKeyStroke.mapNewModifiers(AWTKeyStroke.mapOldModifiers(n3));
        AWTKeyStroke.cacheKey.onKeyRelease = bl2;
        AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)cache.get(cacheKey);
        if (aWTKeyStroke == null) {
            aWTKeyStroke = cacheKey;
            cache.put(aWTKeyStroke, aWTKeyStroke);
            cacheKey = null;
        }
        return aWTKeyStroke;
    }

    public static AWTKeyStroke getAWTKeyStroke(int n2, int n3) {
        return AWTKeyStroke.getCachedStroke('\uffff', n2, n3, false);
    }

    public static AWTKeyStroke getAWTKeyStroke(int n2, int n3, boolean bl2) {
        return AWTKeyStroke.getCachedStroke('\uffff', n2, n3, bl2);
    }

    private void copy(AWTKeyStroke aWTKeyStroke) {
        this.keyChar = aWTKeyStroke.keyChar;
        this.keyCode = aWTKeyStroke.keyCode;
        this.modifiers = aWTKeyStroke.modifiers;
        this.onKeyRelease = aWTKeyStroke.onKeyRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerSubclass(Class clazz) {
        Serializable serializable;
        if (clazz == null) {
            throw new IllegalArgumentException("subclass cannot be null");
        }
        if (subclass.equals(clazz)) {
            return;
        }
        if (!(class$java$awt$AWTKeyStroke == null ? (class$java$awt$AWTKeyStroke = AWTKeyStroke.class$("java.awt.AWTKeyStroke")) : class$java$awt$AWTKeyStroke).isAssignableFrom(clazz)) {
            throw new ClassCastException("subclass is not derived from AWTKeyStroke");
        }
        String string = "subclass could not be instantiated";
        try {
            serializable = AWTKeyStroke.allocateNewInstance(clazz);
            if (serializable == null) {
                throw new IllegalArgumentException(string);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IllegalArgumentException(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new IllegalArgumentException(string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(string);
        }
        serializable = class$java$awt$AWTKeyStroke == null ? (class$java$awt$AWTKeyStroke = AWTKeyStroke.class$("java.awt.AWTKeyStroke")) : class$java$awt$AWTKeyStroke;
        synchronized (serializable) {
            subclass = clazz;
            cache = null;
            cacheKey = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readResolve() throws ObjectStreamException {
        Class clazz = class$java$awt$AWTKeyStroke == null ? (class$java$awt$AWTKeyStroke = AWTKeyStroke.class$("java.awt.AWTKeyStroke")) : class$java$awt$AWTKeyStroke;
        synchronized (clazz) {
            Class clazz2 = this.getClass();
            if (!clazz2.equals(subclass)) {
                AWTKeyStroke.registerSubclass(clazz2);
            }
            return AWTKeyStroke.getCachedStroke(this.keyChar, this.keyCode, this.modifiers, this.onKeyRelease);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof AWTKeyStroke) {
            AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)object;
            return aWTKeyStroke.keyChar == this.keyChar && aWTKeyStroke.keyCode == this.keyCode && aWTKeyStroke.onKeyRelease == this.onKeyRelease && aWTKeyStroke.modifiers == this.modifiers;
        }
        return false;
    }

    public String toString() {
        if (this.keyCode == 0) {
            return "keyChar " + KeyEvent.getKeyModifiersText(this.modifiers) + this.keyChar;
        }
        return "keyCode " + KeyEvent.getKeyModifiersText(this.modifiers) + KeyEvent.getKeyText(this.keyCode) + (this.onKeyRelease ? "-R" : "-P");
    }

    private static int getVKValue(String string) {
        Integer n2;
        if (vkMap == null) {
            vkMap = Collections.synchronizedMap(new HashMap());
        }
        if ((n2 = (Integer)vkMap.get(string)) == null) {
            int n3 = 0;
            try {
                n3 = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = AWTKeyStroke.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField(string).getInt(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = AWTKeyStroke.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalArgumentException("String formatted incorrectly");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("String formatted incorrectly");
            }
            n2 = new Integer(n3);
            vkMap.put(string, n2);
        }
        return n2;
    }

    public static AWTKeyStroke getAWTKeyStrokeForEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        switch (n2) {
            case 401: 
            case 402: {
                return AWTKeyStroke.getCachedStroke('\uffff', keyEvent.getKeyCode(), keyEvent.getModifiers(), n2 == 402);
            }
            case 400: {
                return AWTKeyStroke.getCachedStroke(keyEvent.getKeyChar(), 0, keyEvent.getModifiers(), false);
            }
        }
        return null;
    }

    public static AWTKeyStroke getAWTKeyStroke(Character c2, int n2) {
        if (c2 == null) {
            throw new IllegalArgumentException("keyChar cannot be null");
        }
        return AWTKeyStroke.getCachedStroke(c2.charValue(), 0, n2, false);
    }

    private static native AWTKeyStroke allocateNewInstance(Class var0) throws InstantiationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AWTKeyStroke getAWTKeyStroke(String string) {
        if (string == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (modifierKeywords == null) {
            Class clazz = class$java$awt$AWTKeyStroke == null ? (class$java$awt$AWTKeyStroke = AWTKeyStroke.class$("java.awt.AWTKeyStroke")) : class$java$awt$AWTKeyStroke;
            synchronized (clazz) {
                if (modifierKeywords == null) {
                    HashMap hashMap = new HashMap(8, 1.0f);
                    hashMap.put("shift", new Integer(65));
                    hashMap.put("control", new Integer(130));
                    hashMap.put("ctrl", new Integer(130));
                    hashMap.put("meta", new Integer(260));
                    hashMap.put("alt", new Integer(520));
                    hashMap.put("altGraph", new Integer(8224));
                    hashMap.put("button1", new Integer(1024));
                    hashMap.put("button2", new Integer(2048));
                    hashMap.put("button3", new Integer(4096));
                    modifierKeywords = Collections.synchronizedMap(hashMap);
                }
            }
        }
        int n3 = stringTokenizer.countTokens();
        int n4 = 1;
        while (n4 <= n3) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (bl3) {
                if (string2.length() != 1 || n4 != n3) {
                    throw new IllegalArgumentException("String formatted incorrectly");
                }
                return AWTKeyStroke.getCachedStroke(string2.charAt(0), 0, n2, false);
            }
            if (bl4 || bl2 || n4 == n3) {
                if (n4 != n3) {
                    throw new IllegalArgumentException("String formatted incorrectly");
                }
                object = "VK_" + string2;
                int n5 = AWTKeyStroke.getVKValue((String)object);
                return AWTKeyStroke.getCachedStroke('\uffff', n5, n2, bl2);
            }
            if (string2.equals("released")) {
                bl2 = true;
            } else if (string2.equals("pressed")) {
                bl4 = true;
            } else if (string2.equals("typed")) {
                bl3 = true;
            } else {
                object = (Integer)modifierKeywords.get(string2);
                if (object != null) {
                    n2 |= ((Integer)object).intValue();
                } else {
                    throw new IllegalArgumentException("String formatted incorrectly");
                }
            }
            ++n4;
        }
        throw new IllegalArgumentException("String formatted incorrectly");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

