/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;

public class KeyStoreLoginModule
implements LoginModule {
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.AuthResources");
    private static final int UNINITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int AUTHENTICATED = 2;
    private static final int LOGGED_IN = 3;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private char[] keyStorePassword;
    private char[] privateKeyPassword;
    private String keyStoreURL;
    private String keyStoreType;
    private String keyStoreProvider;
    private String keyStoreAlias;
    private String keyStorePasswordURL;
    private String privateKeyPasswordURL;
    private boolean debug;
    private X500Principal principal;
    private Certificate[] fromKeyStore;
    private CertPath certP = null;
    private X500PrivateCredential privateCredential;
    private int status = 0;

    private void getAliasAndPassword() throws LoginException {
        if (this.callbackHandler == null) {
            InputStream inputStream;
            if (this.keyStoreAlias == null) {
                throw new LoginException("Need to specify an alias option to use KeyStoreLoginModule non-interactively.");
            }
            if (this.keyStorePasswordURL == null) {
                throw new LoginException("Need to specify passwordFile option to use KeyStoreLoginModule non-interactively.");
            }
            try {
                inputStream = new URL(this.keyStorePasswordURL).openStream();
                this.keyStorePassword = this.readPassword(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new LoginException("Problem accessing keystore password \"" + this.keyStorePasswordURL + "\": " + iOException);
            }
            if (this.privateKeyPasswordURL == null) {
                this.privateKeyPassword = this.keyStorePassword;
            } else {
                try {
                    inputStream = new URL(this.privateKeyPasswordURL).openStream();
                    this.privateKeyPassword = this.readPassword(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new LoginException("Problem accessing private key password \"" + this.privateKeyPasswordURL + "\": " + iOException);
                }
            }
        } else {
            TextOutputCallback textOutputCallback = new TextOutputCallback(0, rb.getString("Please login to keystore"));
            NameCallback nameCallback = this.keyStoreAlias == null || this.keyStoreAlias.length() == 0 ? new NameCallback(rb.getString("Keystore alias: ")) : new NameCallback(rb.getString("Keystore alias: "), this.keyStoreAlias);
            PasswordCallback passwordCallback = new PasswordCallback(rb.getString("Keystore password: "), false);
            PasswordCallback passwordCallback2 = new PasswordCallback(rb.getString("Private key password (optional): "), false);
            ConfirmationCallback confirmationCallback = new ConfirmationCallback(0, 2, 3);
            try {
                this.callbackHandler.handle(new Callback[]{textOutputCallback, nameCallback, passwordCallback, passwordCallback2, confirmationCallback});
            }
            catch (IOException iOException) {
                throw new LoginException("Exception while getting keystore alias and password: " + iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " is not available to retrieve authentication " + " information from the user");
            }
            int n2 = confirmationCallback.getSelectedIndex();
            if (n2 == 2) {
                throw new LoginException("Login cancelled");
            }
            this.keyStoreAlias = nameCallback.getName();
            char[] cArray = passwordCallback.getPassword();
            if (cArray == null) {
                cArray = new char[]{};
            }
            this.keyStorePassword = new char[cArray.length];
            System.arraycopy(cArray, 0, this.keyStorePassword, 0, cArray.length);
            passwordCallback.clearPassword();
            cArray = passwordCallback2.getPassword();
            if (cArray == null || cArray.length == 0) {
                this.privateKeyPassword = this.keyStorePassword;
            } else {
                this.privateKeyPassword = new char[cArray.length];
                System.arraycopy(cArray, 0, this.privateKeyPassword, 0, cArray.length);
                int n3 = 0;
                while (n3 < cArray.length) {
                    cArray[0] = 32;
                    ++n3;
                }
                cArray = null;
                passwordCallback2.clearPassword();
            }
            if (this.debug) {
                this.debugPrint("alias=" + this.keyStoreAlias);
            }
        }
    }

    private void getKeyStoreInfo() throws LoginException {
        Object object;
        KeyStore keyStore;
        try {
            keyStore = this.keyStoreProvider == null ? KeyStore.getInstance(this.keyStoreType) : KeyStore.getInstance(this.keyStoreType, this.keyStoreProvider);
        }
        catch (KeyStoreException keyStoreException) {
            throw new LoginException("The specified keystore type was not available: " + keyStoreException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new LoginException("The specified keystore provider was not available: " + noSuchProviderException);
        }
        try {
            object = new URL(this.keyStoreURL).openStream();
            keyStore.load((InputStream)object, this.keyStorePassword);
            ((InputStream)object).close();
        }
        catch (MalformedURLException malformedURLException) {
            throw new LoginException("Incorrect keyStoreURL option: " + malformedURLException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new LoginException("Error initializing keystore: " + generalSecurityException);
        }
        catch (IOException iOException) {
            throw new LoginException("Error initializing keystore: " + iOException);
        }
        try {
            this.fromKeyStore = keyStore.getCertificateChain(this.keyStoreAlias);
            if (this.fromKeyStore == null || this.fromKeyStore.length == 0 || !(this.fromKeyStore[0] instanceof X509Certificate)) {
                throw new FailedLoginException("Unable to find X.509 certificate chain in keystore");
            }
            object = new LinkedList();
            int n2 = 0;
            while (n2 < this.fromKeyStore.length) {
                ((LinkedList)object).add(this.fromKeyStore[n2]);
                ++n2;
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            this.certP = certificateFactory.generateCertPath((List)object);
        }
        catch (KeyStoreException keyStoreException) {
            throw new LoginException("Error using keystore: " + keyStoreException);
        }
        catch (CertificateException certificateException) {
            throw new LoginException("Error: X.509 Certificate type unavailable: " + certificateException);
        }
        try {
            object = (X509Certificate)this.fromKeyStore[0];
            this.principal = new X500Principal(((X509Certificate)object).getSubjectDN().getName());
            Key key = keyStore.getKey(this.keyStoreAlias, this.privateKeyPassword);
            if (key == null || !(key instanceof PrivateKey)) {
                throw new FailedLoginException("Unable to recover key from keystore");
            }
            this.privateCredential = new X500PrivateCredential((X509Certificate)object, (PrivateKey)key, this.keyStoreAlias);
        }
        catch (KeyStoreException keyStoreException) {
            throw new LoginException("Error using keystore: " + keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new LoginException("Error using keystore: " + noSuchAlgorithmException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new FailedLoginException("Unable to recover key from keystore: " + unrecoverableKeyException);
        }
        if (this.debug) {
            this.debugPrint("principal=" + this.principal + "\n certificate=" + this.privateCredential.getCertificate() + "\n alias =" + this.privateCredential.getAlias());
        }
    }

    private void logoutInternal() throws LoginException {
        if (this.debug) {
            this.debugPrint("Entering logoutInternal");
        }
        Arrays.fill(this.keyStorePassword, '\u0000');
        this.keyStorePassword = null;
        Arrays.fill(this.privateKeyPassword, '\u0000');
        this.privateKeyPassword = null;
        if (this.subject.isReadOnly()) {
            this.principal = null;
            this.certP = null;
            this.status = 1;
            Iterator iterator = this.subject.getPrivateCredentials().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!this.privateCredential.equals(object)) continue;
                this.privateCredential = null;
                try {
                    ((Destroyable)object).destroy();
                    if (!this.debug) break;
                    this.debugPrint("Destroyed private credential, " + object.getClass().getName());
                    break;
                }
                catch (DestroyFailedException destroyFailedException) {
                    throw new LoginException("Unable to destroy private credential, " + object.getClass().getName() + ": " + destroyFailedException.getMessage());
                }
            }
            throw new LoginException("Unable to remove Principal (X500Principal ) and public credential (certificatepath) from read-only Subject");
        }
        if (this.principal != null) {
            this.subject.getPrincipals().remove(this.principal);
            this.principal = null;
        }
        if (this.certP != null) {
            this.subject.getPublicCredentials().remove(this.certP);
            this.certP = null;
        }
        if (this.privateCredential != null) {
            this.subject.getPrivateCredentials().remove(this.privateCredential);
            this.privateCredential = null;
        }
        this.status = 1;
    }

    private void processOptions() {
        this.keyStoreURL = (String)this.options.get("keyStoreURL");
        if (this.keyStoreURL == null) {
            this.keyStoreURL = "file:" + System.getProperty("user.home").replace(File.separatorChar, '/') + '/' + ".keystore";
        }
        this.keyStoreType = (String)this.options.get("keyStoreType");
        if (this.keyStoreType == null) {
            this.keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStoreProvider = (String)this.options.get("keyStoreProvider");
        this.keyStoreAlias = (String)this.options.get("keyStoreAlias");
        this.keyStorePasswordURL = (String)this.options.get("keyStorePasswordURL");
        this.privateKeyPasswordURL = (String)this.options.get("privateKeyPasswordURL");
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug) {
            this.debugPrint("keyStoreURL=" + this.keyStoreURL + " keyStoreAlias=" + this.keyStoreAlias + " keyStorePasswordURL=" + this.keyStorePasswordURL + " privateKeyPasswordURL=" + this.privateKeyPasswordURL);
        }
    }

    public boolean abort() throws LoginException {
        switch (this.status) {
            default: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                this.logoutInternal();
                return true;
            }
            case 3: 
        }
        this.logoutInternal();
        return true;
    }

    public boolean commit() throws LoginException {
        switch (this.status) {
            default: {
                throw new LoginException("The login module is not initialized");
            }
            case 1: {
                this.logoutInternal();
                throw new LoginException("Authentication failed");
            }
            case 2: {
                if (this.commitInternal()) {
                    return true;
                }
                this.logoutInternal();
                throw new LoginException("Unable to retrieve certificates");
            }
            case 3: 
        }
        return true;
    }

    private boolean commitInternal() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is set readonly");
        }
        this.subject.getPrincipals().add(this.principal);
        this.subject.getPublicCredentials().add(this.certP);
        this.subject.getPrivateCredentials().add(this.privateCredential);
        this.status = 3;
        return true;
    }

    public boolean login() throws LoginException {
        switch (this.status) {
            default: {
                throw new LoginException("The login module is not initialized");
            }
            case 1: 
            case 2: {
                this.getAliasAndPassword();
                this.getKeyStoreInfo();
                this.status = 2;
                return true;
            }
            case 3: 
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug) {
            this.debugPrint("Entering logout " + this.status);
        }
        switch (this.status) {
            case 0: {
                throw new LoginException("The login module is not initialized");
            }
            default: {
                return false;
            }
            case 3: 
        }
        this.logoutInternal();
        return true;
    }

    private char[] readPassword(InputStream inputStream) throws IOException {
        char[] cArray;
        char[] cArray2 = cArray = new char[128];
        int n2 = cArray2.length;
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2) {
            int n4 = inputStream.read();
            switch (n4) {
                case -1: 
                case 10: {
                    bl2 = true;
                    break;
                }
                case 13: {
                    int n5 = inputStream.read();
                    if (n5 != 10 && n5 != -1) {
                        if (!(inputStream instanceof PushbackInputStream)) {
                            inputStream = new PushbackInputStream(inputStream);
                        }
                        ((PushbackInputStream)inputStream).unread(n5);
                    } else {
                        bl2 = true;
                        break;
                    }
                }
                default: {
                    if (--n2 < 0) {
                        cArray2 = new char[n3 + 128];
                        n2 = cArray2.length - n3 - 1;
                        System.arraycopy(cArray, 0, cArray2, 0, n3);
                        Arrays.fill(cArray, ' ');
                        cArray = cArray2;
                    }
                    cArray2[n3++] = (char)n4;
                }
            }
        }
        if (n3 == 0) {
            return null;
        }
        char[] cArray3 = new char[n3];
        System.arraycopy(cArray2, 0, cArray3, 0, n3);
        Arrays.fill(cArray2, ' ');
        return cArray3;
    }

    private void debugPrint(String string) {
        System.err.println("Debug KeyStoreLoginModule: " + string);
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.processOptions();
        this.status = 1;
    }
}

