/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunFileReader;
import com.sun.media.sound.WaveFileFormat;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFileReader
extends SunFileReader {
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        AudioFileFormat audioFileFormat = null;
        AudioFormat audioFormat = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        audioFormat = this.getFMT(bufferedInputStream, audioFileFormat.getFormat());
        audioFileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, audioFileFormat.getByteLength(), audioFormat, -1);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFormat audioFormat = null;
        WaveFileFormat waveFileFormat = null;
        int n2 = 12;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(n2);
        n3 = dataInputStream.readInt();
        n4 = this.rllong(dataInputStream);
        n6 = dataInputStream.readInt();
        if (n4 <= 0) {
            n4 = -1;
            n5 = -1;
        } else {
            n5 = n4 + 8;
        }
        if (n3 != 1380533830 || n6 != 1463899717) {
            dataInputStream.reset();
            throw new UnsupportedAudioFileException("not a WAVE file");
        }
        audioFormat = new AudioFormat(-1.0f, -1, -1, true, false);
        waveFileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, n5, audioFormat, -1);
        dataInputStream.reset();
        return waveFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        AudioFileFormat audioFileFormat = null;
        AudioFormat audioFormat = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        audioFormat = this.getFMT(bufferedInputStream, audioFileFormat.getFormat());
        audioFileFormat = new WaveFileFormat(AudioFileFormat.Type.WAVE, audioFileFormat.getByteLength(), audioFormat, -1);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        int n2;
        DataInputStream dataInputStream = null;
        int n3 = 0;
        AudioFileFormat audioFileFormat = null;
        AudioFormat audioFormat = null;
        audioFileFormat = this.getAudioFileFormat(inputStream);
        dataInputStream = new DataInputStream(inputStream);
        audioFormat = this.getFMT(dataInputStream, audioFileFormat.getFormat());
        try {
            while (true) {
                int n4 = dataInputStream.readInt();
                n3 += 4;
                if (n4 != 1684108385) {
                    n2 = this.rllong(dataInputStream);
                    n3 += 4;
                    if (n2 % 2 > 0) {
                        ++n2;
                    }
                    n3 += dataInputStream.skipBytes(n2);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        n2 = this.rllong(dataInputStream);
        n3 += 4;
        return new AudioInputStream(dataInputStream, audioFormat, n2 / audioFormat.getFrameSize());
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    private AudioFormat getFMT(InputStream inputStream, AudioFormat audioFormat) throws UnsupportedAudioFileException, IOException {
        int n2 = 0;
        int n3 = 0;
        short s2 = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        try {
            while (true) {
                int n4 = dataInputStream.readInt();
                n2 += 4;
                if (n4 != 1718449184) {
                    n3 = this.rllong(dataInputStream);
                    n2 += 4;
                    if (n3 % 2 > 0) {
                        ++n3;
                    }
                    n2 += dataInputStream.skipBytes(n3);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        n3 = this.rllong(dataInputStream);
        int n5 = (n2 += 4) + n3;
        s2 = this.rlshort(dataInputStream);
        n2 += 2;
        if (s2 == 1) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (s2 == 6) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (s2 == 7) {
            encoding = AudioFormat.Encoding.ULAW;
        } else {
            throw new UnsupportedAudioFileException("Not a supported WAV file");
        }
        short s3 = this.rlshort(dataInputStream);
        n2 += 2;
        long l2 = this.rllong(dataInputStream);
        n2 += 4;
        long l3 = this.rllong(dataInputStream);
        n2 += 4;
        short s4 = this.rlshort(dataInputStream);
        n2 += 2;
        short s5 = this.rlshort(dataInputStream);
        n2 += 2;
        if (s5 == 8 && encoding == AudioFormat.Encoding.PCM_SIGNED) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (n3 % 2 != 0) {
            ++n3;
        }
        if (n5 > n2) {
            n2 += dataInputStream.skipBytes(n5 - n2);
        }
        return new AudioFormat(encoding, l2, s5, s3, s5 * s3 / 8, l2, false);
    }
}

