/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class UlawCodec
extends SunCodec {
    static final byte[] ULAW_TABH = new byte[256];
    static final byte[] ULAW_TABL = new byte[256];
    private static final boolean ulawEncodes = true;
    private static final boolean ulawDecodes = true;
    private static final AudioFormat.Encoding[] ulawEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW, AudioFormat.Encoding.PCM_SIGNED};
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    static {
        int n2 = 0;
        while (n2 < 256) {
            int n3 = ~n2;
            int n4 = (((n3 &= 0xFF) & 0xF) << 3) + 132;
            n4 = (n3 & 0x80) != 0 ? 132 - n4 : (n4 <<= (n3 & 0x70) >> 4) - 132;
            UlawCodec.ULAW_TABL[n2] = (byte)(n4 & 0xFF);
            UlawCodec.ULAW_TABH[n2] = (byte)(n4 >> 8 & 0xFF);
            ++n2;
        }
    }

    public UlawCodec() {
        super(ulawEncodings, ulawEncodings);
    }

    static short[] access$100() {
        return seg_end;
    }

    static byte[] access$000(UlawCodec ulawCodec) {
        return ulawCodec.tempBuffer;
    }

    private AudioFormat[] getOutputFormats(AudioFormat audioFormat) {
        AudioFormat audioFormat2;
        Vector vector = new Vector();
        if (audioFormat.getSampleSizeInBits() == 16 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.ULAW, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getFrameSize() / 2, audioFormat.getFrameRate(), false);
            vector.addElement(audioFormat2);
        }
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), false);
            vector.addElement(audioFormat2);
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), true);
            vector.addElement(audioFormat2);
        }
        AudioFormat[] audioFormatArray = new AudioFormat[vector.size()];
        int n2 = 0;
        while (n2 < audioFormatArray.length) {
            audioFormatArray[n2] = (AudioFormat)vector.elementAt(n2);
            ++n2;
        }
        return audioFormatArray;
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (audioFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW) || encoding.equals(AudioFormat.Encoding.ULAW) && audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return this.getOutputFormats(audioFormat);
        }
        return new AudioFormat[0];
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return this.getConvertedStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioInputStream audioInputStream2 = null;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (audioFormat2.matches(audioFormat)) {
            audioInputStream2 = audioInputStream;
        } else {
            audioInputStream2 = new UlawCodecStream(this, audioInputStream, audioFormat);
            this.tempBuffer = new byte[64];
        }
        return audioInputStream2;
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat.getEncoding();
        if (encoding2.equals(encoding)) {
            return audioInputStream;
        }
        AudioFormat audioFormat2 = null;
        if (!this.isConversionSupported(encoding, audioInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        if (encoding2.equals(AudioFormat.Encoding.ULAW) && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        } else if (encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.ULAW)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() / 2, audioFormat.getChannels(), audioFormat.getFrameSize() / 2, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    class UlawCodecStream
    extends AudioInputStream {
        boolean encode;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1;
        byte[] tabByte2;
        int highByte;
        int lowByte;
        private final UlawCodec this$0;

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, byArray.length);
        }

        private short search(short s2, short[] sArray, short s3) {
            short s4 = 0;
            while (s4 < s3) {
                if (s2 <= sArray[s4]) {
                    return s4;
                }
                s4 = (short)(s4 + 1);
            }
            return s3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (n3 % this.frameSize != 0) {
                n3 -= n3 % this.frameSize;
            }
            if (this.encode) {
                int n4 = 132;
                int n5 = 0;
                int n6 = n2;
                int n7 = n3 * 2;
                int n8 = n7 > 64 ? 64 : n7;
                while ((n5 = super.read(UlawCodec.access$000(this.this$0), 0, n8)) > 0) {
                    int n9 = 0;
                    while (n9 < n5) {
                        byte by;
                        int n10;
                        short s2 = (short)(UlawCodec.access$000(this.this$0)[n9 + this.highByte] << 8 & 0xFF00);
                        if ((s2 = (short)(s2 | (short)((short)UlawCodec.access$000(this.this$0)[n9 + this.lowByte] & 0xFF))) < 0) {
                            s2 = (short)(n4 - s2);
                            n10 = 127;
                        } else {
                            s2 = (short)(s2 + n4);
                            n10 = 255;
                        }
                        short s3 = this.search(s2, UlawCodec.access$100(), (short)8);
                        if (s3 >= 8) {
                            by = (byte)(0x7F ^ n10);
                        } else {
                            by = (byte)(s3 << 4 | s2 >> s3 + 3 & 0xF);
                            by = (byte)(by ^ n10);
                        }
                        byArray[n6] = by;
                        ++n6;
                        n9 += 2;
                    }
                    int n11 = n8 = (n7 -= n5) > 64 ? 64 : n7;
                }
                if (n6 == n2 && n5 < 0) {
                    return n5;
                }
                return n6 - n2;
            }
            int n12 = n2 + n3 / 2;
            int n13 = n3 / 2;
            int n14 = super.read(byArray, n12, n13);
            if (n14 < 0) {
                return n14;
            }
            int n15 = n2;
            while (n15 < n2 + n14 * 2) {
                byArray[n15] = this.tabByte1[byArray[n12] & 0xFF];
                byArray[n15 + 1] = this.tabByte2[byArray[n12] & 0xFF];
                ++n12;
                n15 += 2;
            }
            return n15 - n2;
        }

        UlawCodecStream(UlawCodec ulawCodec, AudioInputStream audioInputStream, AudioFormat audioFormat) {
            this.this$0 = ulawCodec;
            super(audioInputStream, audioFormat, -1L);
            this.encode = false;
            this.tabByte1 = null;
            this.tabByte2 = null;
            this.highByte = 0;
            this.lowByte = 1;
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            if (!ulawCodec.isConversionSupported(audioFormat, audioFormat2)) {
                throw new IllegalArgumentException("Unsupported conversion: " + audioFormat2.toString() + " to " + audioFormat.toString());
            }
            if (audioFormat2.getEncoding() == AudioFormat.Encoding.ULAW) {
                this.encode = false;
                this.encodeFormat = audioFormat2;
                this.decodeFormat = audioFormat;
            } else {
                this.encode = true;
                this.encodeFormat = audioFormat;
                this.decodeFormat = audioFormat2;
            }
            if (this.decodeFormat.isBigEndian()) {
                this.tabByte1 = ULAW_TABH;
                this.tabByte2 = ULAW_TABL;
            } else {
                this.tabByte1 = ULAW_TABL;
                this.tabByte2 = ULAW_TABH;
            }
            if (this.encodeFormat.isBigEndian()) {
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (audioInputStream instanceof AudioInputStream) {
                long l2;
                this.frameLength = l2 = audioInputStream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = audioFormat2.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }
    }
}

