/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Toolkit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class MixerSourceLine
extends AbstractDataLine
implements SourceDataLine {
    private CircularBuffer circularBuffer = null;
    private byte[] dataBuffer = null;
    private long id;
    private int finalPosition = 0;
    private boolean implStarted = false;
    MixerSourceLineGainControl gainControl = new MixerSourceLineGainControl(this, null);

    public float getLevel() {
        return this.id != 0L ? this.nGetLevel(this.id) : -1.0f;
    }

    public int available() {
        return this.circularBuffer.bytesAvailableToWrite();
    }

    public int getFramePosition() {
        return this.id != 0L ? (int)this.nGetPosition(this.id) : this.finalPosition;
    }

    long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamActive() {
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.setActive(true);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamDestroy() {
        this.finalPosition = this.getFramePosition();
        this.id = 0L;
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.notifyAll();
        }
    }

    private void callbackStreamEOM() {
        this.setActive(false);
        this.setEOM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamInactive() {
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.setActive(false);
            this.notifyAll();
        }
    }

    private void callbackStreamStart() {
        this.setActive(true);
        this.setStarted(true);
    }

    private void callbackStreamStop() {
        this.setActive(false);
        this.setStarted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        this.circularBuffer.drain();
        if (!this.isActive()) {
            this.nDrain(this.id);
        }
        int n2 = 40;
        while (this.isActive() && n2-- > 0) {
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void flush() {
        this.circularBuffer.flush();
        this.nFlush(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implClose() {
        this.nClose(this.id);
        while (this.id != 0L) {
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void implStart() {
        if (!this.implStarted) {
            this.nStart(this.id);
            this.implStarted = true;
        } else {
            this.nResume(this.id);
        }
    }

    void implStop() {
        this.nPause(this.id);
    }

    private native long nOpen(int var1, int var2, float var3, int var4) throws LineUnavailableException;

    private native float nGetLevel(long var1);

    private native long nGetPosition(long var1);

    private native void nClose(long var1);

    private native void nDrain(long var1);

    private native void nFlush(long var1);

    private native void nPause(long var1);

    private native void nResume(long var1);

    private native void nStart(long var1);

    protected native float nSetLinearGain(long var1, float var3);

    protected native float nSetPan(long var1, float var3);

    protected native int nSetSampleRate(long var1, int var3);

    private synchronized int callbackStreamGetData(byte[] byArray, int n2) {
        int n3 = this.getFormat().getFrameSize();
        int n4 = n2 * n3;
        int n5 = this.circularBuffer.read(byArray, 0, n4 = Math.min(n4, byArray.length));
        n5 = n5 > 0 ? n5 / n3 : n5;
        this.notifyAll();
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            this.circularBuffer.markEnd();
            return 0;
        }
        int n4 = n3;
        if (n3 % this.getFormat().getFrameSize() != 0) {
            throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n3 + " bytes )");
        }
        int n5 = 0;
        int n6 = 0;
        while (this.isOpen() && this.isStartedRunning() && n5 < n4) {
            n6 = this.circularBuffer.write(byArray, n2, n4 - n5);
            n2 += n6;
            if ((n5 += n6) >= n4) continue;
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return n5;
    }

    static long access$400(MixerSourceLine mixerSourceLine) {
        return mixerSourceLine.id;
    }

    private static int calculateBufferSizeInBytes(AudioFormat audioFormat) {
        int n2 = (int)audioFormat.getFrameRate() / 2;
        int n3 = 1;
        while (n2 > n3) {
            n3 *= 2;
        }
        return n3 * audioFormat.getFrameSize();
    }

    void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        if (audioFormat.getSampleRate() == -1.0f) {
            audioFormat = new AudioFormat(audioFormat.getEncoding(), this.mixer.getFormat().getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
        }
        if (n2 == -1 || n2 < audioFormat.getFrameSize()) {
            n2 = MixerSourceLine.calculateBufferSizeInBytes(audioFormat);
        }
        HeadspaceMixer cfr_ignored_0 = (HeadspaceMixer)this.mixer;
        int n3 = 0x100000 * audioFormat.getFrameSize() * 2;
        while (n2 > n3) {
            n2 /= 2;
        }
        n2 -= n2 % audioFormat.getFrameSize();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getFormat().getSampleSizeInBits() == 8 && this.getFormat().getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            bl2 = true;
        }
        if (this.getFormat().getSampleSizeInBits() > 8 && this.getFormat().isBigEndian() != Platform.isBigEndian()) {
            bl3 = true;
        }
        if (this.circularBuffer == null || this.circularBuffer.getByteLength() != n2) {
            this.circularBuffer = new CircularBuffer(n2, bl2, bl3);
        }
        if (this.dataBuffer == null || this.dataBuffer.length != n2) {
            this.dataBuffer = new byte[n2];
        }
        this.id = this.nOpen(this.getFormat().getSampleSizeInBits(), this.getFormat().getChannels(), this.getFormat().getSampleRate(), n2);
        this.format = audioFormat;
        this.bufferSize = n2;
        if (this.id == 0L) {
            throw new LineUnavailableException("Failed to allocate native stream.");
        }
    }

    MixerSourceLine(DataLine.Info info, HeadspaceMixer headspaceMixer, AudioFormat audioFormat, int n2) throws LineUnavailableException {
        super(info, headspaceMixer, new Control[4], audioFormat, n2);
        this.controls[0] = this.gainControl;
        this.controls[1] = new MixerSourceLineMuteControl(this, null);
        this.controls[2] = new MixerSourceLinePanControl(this, null);
        this.controls[3] = new MixerSourceLineSampleRateControl(this, null);
    }

    class 1 {
    }

    private class MixerSourceLineApplyReverbControl
    extends BooleanControl {
        private final MixerSourceLine this$0;

        public void setValue(boolean bl2) {
            if (!this.this$0.isOpen()) {
                return;
            }
            if (bl2 == this.getValue() || MixerSourceLine.access$400(this.this$0) != 0L) {
                // empty if block
            }
            super.setValue(bl2);
        }

        private MixerSourceLineApplyReverbControl(MixerSourceLine mixerSourceLine) {
            this.this$0 = mixerSourceLine;
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }
    }

    private class MixerSourceLineGainControl
    extends FloatControl {
        private float linearGain;
        private final MixerSourceLine this$0;

        public void setValue(float f2) {
            if (!this.this$0.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            float f3 = Toolkit.dBToLinear(f2 = Math.max(f2, this.getMinimum()));
            if (f3 != this.linearGain && MixerSourceLine.access$400(this.this$0) != 0L) {
                f3 = this.this$0.nSetLinearGain(MixerSourceLine.access$400(this.this$0), f3);
            }
            this.linearGain = f3;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }

        private MixerSourceLineGainControl(MixerSourceLine mixerSourceLine) {
            this.this$0 = mixerSourceLine;
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Math.abs(Toolkit.linearToDB(5.0f) - Toolkit.linearToDB(0.0f)) / 128.0f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
            this.linearGain = 1.0f;
        }

        MixerSourceLineGainControl(MixerSourceLine mixerSourceLine, 1 var2_2) {
            this(mixerSourceLine);
        }
    }

    private class MixerSourceLineMuteControl
    extends BooleanControl {
        private final MixerSourceLine this$0;

        public void setValue(boolean bl2) {
            if (!this.this$0.isOpen()) {
                return;
            }
            if (bl2 && !this.getValue() && MixerSourceLine.access$400(this.this$0) != 0L) {
                this.this$0.nSetLinearGain(MixerSourceLine.access$400(this.this$0), 0.0f);
            } else if (!bl2 && this.getValue() && MixerSourceLine.access$400(this.this$0) != 0L) {
                float f2 = Toolkit.dBToLinear(this.this$0.gainControl.getValue());
                this.this$0.nSetLinearGain(MixerSourceLine.access$400(this.this$0), f2);
            }
            super.setValue(bl2);
        }

        private MixerSourceLineMuteControl(MixerSourceLine mixerSourceLine) {
            this.this$0 = mixerSourceLine;
            super(BooleanControl.Type.MUTE, false, "True", "False");
        }

        MixerSourceLineMuteControl(MixerSourceLine mixerSourceLine, 1 var2_2) {
            this(mixerSourceLine);
        }
    }

    private class MixerSourceLinePanControl
    extends FloatControl {
        private final MixerSourceLine this$0;

        public void setValue(float f2) {
            if (!this.this$0.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            if ((f2 = Math.max(f2, this.getMinimum())) != this.getValue() && MixerSourceLine.access$400(this.this$0) != 0L) {
                f2 = -1.0f * this.this$0.nSetPan(MixerSourceLine.access$400(this.this$0), -1.0f * f2);
            }
            super.setValue(f2);
        }

        private MixerSourceLinePanControl(MixerSourceLine mixerSourceLine) {
            this.this$0 = mixerSourceLine;
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        MixerSourceLinePanControl(MixerSourceLine mixerSourceLine, 1 var2_2) {
            this(mixerSourceLine);
        }
    }

    private class MixerSourceLineSampleRateControl
    extends FloatControl {
        private final MixerSourceLine this$0;

        private void update() {
            super.setValue(this.this$0.getFormat().getFrameRate());
        }

        public void setValue(float f2) {
            if (!this.this$0.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            if ((f2 = Math.max(f2, this.getMinimum())) != this.getValue() && MixerSourceLine.access$400(this.this$0) != 0L) {
                f2 = this.this$0.nSetSampleRate(MixerSourceLine.access$400(this.this$0), (int)f2);
            }
            super.setValue(f2);
        }

        private MixerSourceLineSampleRateControl(MixerSourceLine mixerSourceLine) {
            this.this$0 = mixerSourceLine;
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, mixerSourceLine.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }

        MixerSourceLineSampleRateControl(MixerSourceLine mixerSourceLine, 1 var2_2) {
            this(mixerSourceLine);
        }
    }
}

