/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractPlayer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

class MixerSequencer
extends AbstractPlayer
implements Sequencer {
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int MIDI_TYPE_2 = 2;
    static final MixerSequencerInfo info = new MixerSequencerInfo(null);
    private static Sequencer.SyncMode[] masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static Sequencer.SyncMode[] slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
    private static Sequencer.SyncMode masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
    private static Sequencer.SyncMode slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
    private long timeStamp = -1L;
    private Sequence sequence = null;
    private byte[] midiData = null;
    private boolean runningInEngine = false;
    private boolean newSequenceStarted = false;
    private long tick = -1L;
    private float tempoInBPM = -1.0f;
    private float tempoInMPQ = -1.0f;
    private boolean running = false;
    private boolean recording = false;
    private boolean sequenceChanged = false;
    private long startTime = 0L;
    private long startMillisecondTime = 0L;
    private long lastTempoChangeTime = 0L;
    private long lastTempoChangeTick = 0L;
    private long recordTempoInMPQ = 500000L;
    private long startTick = 0L;
    private float divisionType = 0.0f;
    private int resolution = 0;
    private SequencerReceiver sequencerReceiver = null;
    private Vector recordingTracks = new Vector();
    private Vector metaEventListeners = new Vector();
    private Vector controllerEventListeners = new Vector();

    public float getTempoFactor() {
        if (this.id == 0L) {
            return 0.0f;
        }
        return this.nGetMasterTempo(this.id);
    }

    public float getTempoInBPM() {
        if (this.id == 0L) {
            return 0.0f;
        }
        if (!this.newSequenceStarted && this.tempoInBPM != -1.0f) {
            return this.tempoInBPM;
        }
        return this.nGetTempoInBPM(this.id);
    }

    public float getTempoInMPQ() {
        if (this.id == 0L) {
            return 0.0f;
        }
        if (!this.newSequenceStarted && this.tempoInMPQ != -1.0f) {
            return this.tempoInMPQ;
        }
        return this.nGetTempoInMPQ(this.id);
    }

    public long getMicrosecondLength() {
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequenceMicrosecondLength(this.id);
    }

    public long getMicrosecondPosition() {
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequencerMicrosecondPosition(this.id);
    }

    public long getTickLength() {
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequenceTickLength(this.id);
    }

    public synchronized long getTickPosition() {
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequencerTickPosition(this.id) / 64L;
    }

    public long getTimeStamp() {
        return this.getMicrosecondPosition();
    }

    protected MixerSequencer() throws MidiUnavailableException {
        super(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void callbackSongEnd() {
        this.implStop();
        this.runningInEngine = false;
        MixerSequencer mixerSequencer = this;
        synchronized (mixerSequencer) {
            this.notifyAll();
        }
        MetaMessage metaMessage = new MetaMessage();
        try {
            metaMessage.setMessage(47, new byte[0], 0);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        this.sendMetaEvents(metaMessage);
    }

    private void callbackSongStart() {
    }

    private void callbackSongStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void implClose() {
        this.implStop();
        super.implClose();
        this.sequence = null;
        this.running = false;
        this.newSequenceStarted = false;
        while (this.runningInEngine) {
            MixerSequencer mixerSequencer = this;
            synchronized (mixerSequencer) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void implOpen() throws MidiUnavailableException {
        this.openInternalSynth();
    }

    protected void implStop() {
        this.nPauseSequencer(this.id);
        this.running = false;
    }

    public synchronized void start() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        if (this.id == 0L) {
            return;
        }
        if (this.running) {
            return;
        }
        if (this.sequenceChanged) {
            try {
                this.setSequence(this.sequence);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
            this.sequenceChanged = false;
        }
        this.running = true;
        if (!this.newSequenceStarted) {
            this.nStartSequencer(this.id);
            this.newSequenceStarted = true;
            if (this.tick != -1L) {
                this.setTickPosition(this.tick);
            }
            if (this.tempoInBPM != -1.0f) {
                this.setTempoInBPM(this.tempoInBPM);
            }
            if (this.tempoInMPQ != -1.0f) {
                this.setTempoInMPQ(this.tempoInMPQ);
            }
        } else {
            if (this.tick != -1L) {
                this.setTickPosition(this.tick);
            } else if (!this.runningInEngine) {
                this.setMicrosecondPosition(0L);
            }
            this.nResumeSequencer(this.id);
        }
        this.runningInEngine = true;
        this.callbackSongStart();
    }

    public void startRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.recording = true;
        this.divisionType = this.sequence.getDivisionType();
        this.resolution = this.sequence.getResolution();
        this.startTime = System.currentTimeMillis();
        this.startMillisecondTime = this.getMicrosecondPosition() / 1000L;
        this.startTick = 0L;
        this.lastTempoChangeTime = 0L;
        this.lastTempoChangeTick = this.startTick;
        this.recordTempoInMPQ = (long)this.getTempoInMPQ();
        this.start();
        this.startMillisecondTime = this.getMicrosecondPosition() / 1000L;
    }

    public synchronized void stop() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.stopRecording();
        if (this.id == 0L) {
            return;
        }
        if (!this.running) {
            return;
        }
        this.implStop();
        this.callbackSongStop();
    }

    public void stopRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        if (this.recording) {
            this.sequenceChanged = true;
        }
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setTempoFactor(float f2) {
        if (this.id == 0L) {
            return;
        }
        this.nSetMasterTempo(this.id, f2);
    }

    public void setTempoInBPM(float f2) {
        if (this.id == 0L) {
            return;
        }
        if (!this.newSequenceStarted) {
            this.tempoInBPM = f2;
            this.tempoInMPQ = 6.0E7f / f2;
        } else {
            this.nSetTempoInBPM(this.id, (int)f2);
            this.tempoInBPM = -1.0f;
            this.tempoInMPQ = -1.0f;
        }
    }

    public void setTempoInMPQ(float f2) {
        if (this.id == 0L) {
            return;
        }
        if (!this.newSequenceStarted) {
            this.tempoInMPQ = f2;
            this.tempoInBPM = 6.0E7f / f2;
        } else {
            this.nSetTempoInMPQ(this.id, (int)f2);
            this.tempoInBPM = -1.0f;
            this.tempoInMPQ = -1.0f;
        }
    }

    public boolean getTrackMute(int n2) {
        if (this.id == 0L) {
            return false;
        }
        return this.nGetTrackMute(this.id, n2);
    }

    public boolean getTrackSolo(int n2) {
        if (this.id == 0L) {
            return false;
        }
        return this.nGetTrackSolo(this.id, n2);
    }

    private void callbackControllerEvent(int n2, int n3, int n4, int n5) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(176 + n2, n4, n5);
            this.sendControllerEvents(shortMessage, n4);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {}
    }

    private void callbackMetaEvent(int n2, int n3, int n4, byte[] byArray) {
        MetaMessage metaMessage = new MetaMessage();
        try {
            metaMessage.setMessage(n2, byArray, n3);
            this.sendMetaEvents(metaMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {}
    }

    public void setTrackMute(int n2, boolean bl2) {
        if (this.id == 0L) {
            return;
        }
        this.nSetTrackMute(this.id, n2, bl2);
    }

    public void setTrackSolo(int n2, boolean bl2) {
        if (this.id == 0L) {
            return;
        }
        this.nSetTrackSolo(this.id, n2, bl2);
    }

    protected native float nGetMasterTempo(long var1);

    protected native int nGetTempoInBPM(long var1);

    protected native int nGetTempoInMPQ(long var1);

    private long calculateTickPosition(long l2) {
        if (this.divisionType == 0.0f) {
            long l3 = l2 - this.lastTempoChangeTime;
            long l4 = l3 >= 0L ? this.lastTempoChangeTick + l3 * (long)this.resolution * 1000L / this.recordTempoInMPQ : l2 * (long)this.resolution * 1000L / this.recordTempoInMPQ;
            return l4;
        }
        return (long)((float)l2 * this.divisionType * (float)this.resolution / 1000.0f);
    }

    protected native long nGetSequenceMicrosecondLength(long var1);

    protected native long nGetSequenceTickLength(long var1);

    protected native long nGetSequencerMicrosecondPosition(long var1);

    protected native long nGetSequencerTickPosition(long var1);

    protected native void nPauseSequencer(long var1);

    protected native void nResumeSequencer(long var1);

    protected native void nStartSequencer(long var1);

    public void setMicrosecondPosition(long l2) {
        if (this.id == 0L) {
            return;
        }
        this.nSetSequencerMicrosecondPosition(this.id, l2);
        this.tick = -1L;
    }

    public synchronized void setTickPosition(long l2) {
        if (this.id == 0L) {
            return;
        }
        if (!this.running) {
            this.tick = l2 * 64L;
        } else {
            this.nSetSequencerTickPosition(this.id, l2 * 64L);
            this.tick = -1L;
        }
    }

    public void setTimeStamp(long l2) {
    }

    protected native float nSetMasterTempo(long var1, float var3);

    protected native int nSetTempoInBPM(long var1, int var3);

    protected native int nSetTempoInMPQ(long var1, int var3);

    protected native void nAddControllerEventCallback(long var1, int var3);

    protected native boolean nGetTrackMute(long var1, int var3);

    protected native boolean nGetTrackSolo(long var1, int var3);

    protected native void nSetTrackMute(long var1, int var3, boolean var4);

    protected native void nSetTrackSolo(long var1, int var3, boolean var4);

    protected native long nSetSequencerMicrosecondPosition(long var1, long var3);

    protected native long nSetSequencerTickPosition(long var1, long var3);

    protected native long nOpenMidiSequencer(byte[] var1, int var2);

    protected native long nOpenRmfSequencer(byte[] var1, int var2);

    static long access$800(MixerSequencer mixerSequencer) {
        return mixerSequencer.startMillisecondTime;
    }

    static long access$900(MixerSequencer mixerSequencer) {
        return mixerSequencer.startTime;
    }

    static boolean access$500(MixerSequencer mixerSequencer) {
        return mixerSequencer.recording;
    }

    static boolean access$600(MixerSequencer mixerSequencer) {
        return mixerSequencer.running;
    }

    static long access$700(MixerSequencer mixerSequencer, long l2) {
        return mixerSequencer.calculateTickPosition(l2);
    }

    public synchronized void setSequence(InputStream inputStream) throws IOException, InvalidMidiDataException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot set sequence until sequencer has been opened");
        }
        MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(inputStream);
        int n2 = midiFileFormat.getType();
        if (n2 == 2) {
            throw new InvalidMidiDataException("Unsupported file type: " + n2 + ". Only type 0 and type 1 MIDI files are supported.");
        }
        if (this.id != 0L) {
            this.stop();
            this.implClose();
            try {
                this.implOpen();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        this.midiData = this.getBytesFromFileStream(inputStream, midiFileFormat);
        if (this.midiData == null || this.midiData.length == 0) {
            throw new IOException("Failed to read data from stream.");
        }
        if (n2 == 0 || n2 == 1) {
            this.id = this.nOpenMidiSequencer(this.midiData, this.midiData.length);
            if (this.id == 0L) {
                this.id = this.nOpenRmfSequencer(this.midiData, this.midiData.length);
            }
        }
        if (this.id == 0L) {
            throw new InvalidMidiDataException("Failed to load sequence");
        }
        int n3 = 0;
        while (n3 < this.channels.length) {
            this.channels[n3].setId(this.id);
            ++n3;
        }
        this.connectToInternalSynth();
        n3 = 0;
        while (n3 < this.controllerEventListeners.size()) {
            ControllerVectorElement controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n3);
            int n4 = 0;
            while (n4 < controllerVectorElement.controllers.length) {
                this.nAddControllerEventCallback(this.id, controllerVectorElement.controllers[n4]);
                ++n4;
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] addControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            ControllerVectorElement controllerVectorElement = null;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.controllerEventListeners.size()) {
                controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n2);
                if (controllerVectorElement.listener.equals(controllerEventListener)) {
                    ControllerVectorElement.access$100(controllerVectorElement, nArray);
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                controllerVectorElement = new ControllerVectorElement(this, controllerEventListener, nArray, null);
                this.controllerEventListeners.addElement(controllerVectorElement);
            }
            if (this.id != 0L) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    this.nAddControllerEventCallback(this.id, nArray[n3]);
                    ++n3;
                }
            }
            return ControllerVectorElement.access$300(controllerVectorElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] removeControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            ControllerVectorElement controllerVectorElement = null;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.controllerEventListeners.size()) {
                controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n2);
                if (controllerVectorElement.listener.equals(controllerEventListener)) {
                    ControllerVectorElement.access$400(controllerVectorElement, nArray);
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                return new int[0];
            }
            if (nArray == null) {
                this.controllerEventListeners.removeElement(controllerVectorElement);
                return new int[0];
            }
            return ControllerVectorElement.access$300(controllerVectorElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaEventListener(MetaEventListener metaEventListener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            this.metaEventListeners.removeElement(metaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMetaEventListener(MetaEventListener metaEventListener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            if (!this.metaEventListeners.contains(metaEventListener)) {
                this.metaEventListeners.addElement(metaEventListener);
            }
            return true;
        }
    }

    protected void sendMetaEvents(MetaMessage metaMessage) {
        AbstractMidiDevice.eventDispatcher.sendAudioEvents(metaMessage, this.metaEventListeners);
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        if (this.sequencerReceiver == null) {
            this.sequencerReceiver = new SequencerReceiver(this);
        }
        return this.sequencerReceiver;
    }

    public Sequence getSequence() {
        block3: {
            if (this.sequence != null || this.midiData == null || this.midiData.length <= 0) break block3;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.midiData);
            try {
                this.sequence = MidiSystem.getSequence(byteArrayInputStream);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
            }
            catch (IOException iOException) {}
        }
        return this.sequence;
    }

    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot set sequence until sequencer has been opened");
        }
        int[] nArray = MidiSystem.getMidiFileTypes(sequence);
        if (nArray.length == 0) {
            throw new InvalidMidiDataException("Unsupported sequence: " + sequence);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            MidiSystem.write(sequence, nArray[0], byteArrayOutputStream);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Unable to get file stream from sequence: " + sequence);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.setSequence(byteArrayInputStream);
            this.sequence = sequence;
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Failed to load sequence: " + sequence);
        }
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        return masterSyncMode;
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        return slaveSyncMode;
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, syncModeArray, 0, masterSyncModes.length);
        return syncModeArray;
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, syncModeArray, 0, slaveSyncModes.length);
        return syncModeArray;
    }

    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
    }

    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
    }

    protected void sendControllerEvents(ShortMessage shortMessage, int n2) {
        Vector vector = new Vector();
        int n3 = 0;
        while (n3 < this.controllerEventListeners.size()) {
            ControllerVectorElement controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n3);
            int n4 = 0;
            while (n4 < controllerVectorElement.controllers.length) {
                if (controllerVectorElement.controllers[n4] == n2) {
                    vector.addElement(controllerVectorElement.listener);
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        AbstractMidiDevice.eventDispatcher.sendAudioEvents(shortMessage, vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordDisable(Track track) {
        Vector vector = this.recordingTracks;
        synchronized (vector) {
            RecordingTrack recordingTrack = RecordingTrack.get(this.recordingTracks, track);
            if (recordingTrack != null) {
                this.recordingTracks.removeElement(recordingTrack);
            }
        }
    }

    private boolean findTrack(Track track) {
        boolean bl2 = false;
        if (this.sequence != null) {
            Track[] trackArray = this.sequence.getTracks();
            int n2 = 0;
            while (n2 < trackArray.length) {
                if (track == trackArray[n2]) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEnable(Track track, int n2) {
        if (!this.findTrack(track)) {
            throw new IllegalArgumentException("Track does not exist in the current sequence");
        }
        Vector vector = this.recordingTracks;
        synchronized (vector) {
            RecordingTrack recordingTrack = RecordingTrack.get(this.recordingTracks, track);
            if (recordingTrack != null) {
                recordingTrack.channel = n2;
            } else {
                this.recordingTracks.addElement(new RecordingTrack(track, n2));
            }
        }
    }

    static Vector access$1000(MixerSequencer mixerSequencer) {
        return mixerSequencer.recordingTracks;
    }

    protected byte[] getBytesFromFileStream(InputStream inputStream, MidiFileFormat midiFileFormat) throws IOException {
        byte[] byArray;
        if (inputStream == null) {
            throw new IOException("Stream is null");
        }
        long l2 = midiFileFormat.getByteLength();
        if (l2 != -1L) {
            byArray = new byte[(int)l2];
            if ((long)inputStream.read(byArray) != l2) {
                throw new IOException("Read failure: expected " + l2 + " bytes");
            }
        } else {
            int n2 = 2048;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n3 = n2;
            byte[] byArray2 = new byte[n3];
            int n4 = 0;
            int n5 = 0;
            while (true) {
                if ((n5 = inputStream.read(byArray2, 0, n3)) == -1) {
                    if (n4 != 0) break;
                    throw new IOException("No data found in stream");
                }
                dataOutputStream.write(byArray2, 0, n5);
                n4 += n5;
                Thread.currentThread();
                Thread.yield();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    class 1 {
    }

    private class ControllerVectorElement {
        int[] controllers;
        ControllerEventListener listener;
        private final MixerSequencer this$0;

        private int[] getControllers() {
            int[] nArray = new int[this.controllers.length];
            int n2 = 0;
            while (n2 < this.controllers.length) {
                nArray[n2] = this.controllers[n2];
                ++n2;
            }
            return nArray;
        }

        private void addControllers(int[] nArray) {
            int n2;
            if (nArray == null) {
                return;
            }
            int[] nArray2 = new int[this.controllers.length + nArray.length];
            int n3 = 0;
            while (n3 < this.controllers.length) {
                nArray2[n3] = this.controllers[n3];
                ++n3;
            }
            int n4 = this.controllers.length;
            int n5 = 0;
            while (n5 < nArray.length) {
                boolean bl2 = false;
                n2 = 0;
                while (n2 < this.controllers.length) {
                    if (nArray[n5] == this.controllers[n2]) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl2) {
                    nArray2[n4++] = nArray[n5];
                }
                ++n5;
            }
            int[] nArray3 = new int[n4];
            n2 = 0;
            while (n2 < n4) {
                nArray3[n2] = nArray2[n2];
                ++n2;
            }
            this.controllers = nArray3;
        }

        private void removeControllers(int[] nArray) {
            if (nArray == null) {
                this.controllers = new int[0];
            } else {
                int n2;
                int[] nArray2 = new int[this.controllers.length];
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.controllers.length) {
                    boolean bl2 = false;
                    n2 = 0;
                    while (n2 < nArray.length) {
                        if (this.controllers[n4] == nArray[n2]) {
                            bl2 = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl2) {
                        nArray2[n3++] = this.controllers[n4];
                    }
                    ++n4;
                }
                int[] nArray3 = new int[n3];
                n2 = 0;
                while (n2 < n3) {
                    nArray3[n2] = nArray2[n2];
                    ++n2;
                }
                this.controllers = nArray3;
            }
        }

        static int[] access$300(ControllerVectorElement controllerVectorElement) {
            return controllerVectorElement.getControllers();
        }

        static void access$100(ControllerVectorElement controllerVectorElement, int[] nArray) {
            controllerVectorElement.addControllers(nArray);
        }

        static void access$400(ControllerVectorElement controllerVectorElement, int[] nArray) {
            controllerVectorElement.removeControllers(nArray);
        }

        private ControllerVectorElement(MixerSequencer mixerSequencer, ControllerEventListener controllerEventListener, int[] nArray) {
            this.this$0 = mixerSequencer;
            this.listener = controllerEventListener;
            this.controllers = nArray;
        }

        ControllerVectorElement(MixerSequencer mixerSequencer, ControllerEventListener controllerEventListener, int[] nArray, 1 var4_4) {
            this(mixerSequencer, controllerEventListener, nArray);
        }
    }

    private static class MixerSequencerInfo
    extends MidiDevice.Info {
        private static final String name = "Java Sound Sequencer";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software sequencer / synthesizer module";
        private static final String version = "Version 1.0";

        private MixerSequencerInfo() {
            super(name, vendor, description, version);
        }

        MixerSequencerInfo(1 var1_1) {
            this();
        }
    }

    static class RecordingTrack {
        Track track;
        int channel;

        RecordingTrack(Track track, int n2) {
            this.track = track;
            this.channel = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Vector get(Vector vector, int n2) {
            Vector vector2 = new Vector();
            Vector vector3 = vector;
            synchronized (vector3) {
                int n3 = vector.size();
                int n4 = 0;
                while (n4 < n3) {
                    RecordingTrack recordingTrack = (RecordingTrack)vector.elementAt(n4);
                    if (recordingTrack.channel == n2 || recordingTrack.channel == -1) {
                        vector2.addElement(recordingTrack.track);
                    }
                    ++n4;
                }
            }
            return vector2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RecordingTrack get(Vector vector, Track track) {
            Vector vector2 = vector;
            synchronized (vector2) {
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    RecordingTrack recordingTrack = (RecordingTrack)vector.elementAt(n3);
                    if (recordingTrack.track == track) {
                        return recordingTrack;
                    }
                    ++n3;
                }
            }
            return null;
        }
    }

    class SequencerReceiver
    extends AbstractPlayer.PlayerReceiver {
        private final MixerSequencer this$0;

        SequencerReceiver(MixerSequencer mixerSequencer) {
            this.this$0 = mixerSequencer;
            super(mixerSequencer);
        }

        public void send(MidiMessage midiMessage, long l2) {
            super.send(midiMessage, l2);
            if (MixerSequencer.access$500(this.this$0)) {
                Vector vector = null;
                long l3 = l2 < 0L ? (MixerSequencer.access$600(this.this$0) ? MixerSequencer.access$700(this.this$0, this.this$0.getMicrosecondPosition() / 1000L) : MixerSequencer.access$700(this.this$0, MixerSequencer.access$800(this.this$0) + (System.currentTimeMillis() - MixerSequencer.access$900(this.this$0)))) : MixerSequencer.access$700(this.this$0, l2);
                MidiEvent midiEvent = new MidiEvent(midiMessage, l3);
                vector = midiMessage instanceof ShortMessage ? RecordingTrack.get(MixerSequencer.access$1000(this.this$0), ((ShortMessage)midiMessage).getChannel()) : RecordingTrack.get(MixerSequencer.access$1000(this.this$0), 0);
                int n2 = 0;
                while (n2 < vector.size()) {
                    ((Track)vector.elementAt(n2)).add(midiEvent);
                    ++n2;
                }
            }
        }
    }
}

