/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AuFileFormat;
import com.sun.media.sound.SunFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AuFileReader
extends SunFileReader {
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.AU};

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        AudioFileFormat audioFileFormat = null;
        Object var5_5 = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFormat audioFormat = null;
        AuFileFormat auFileFormat = null;
        int n2 = 28;
        boolean bl2 = false;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(n2);
        n3 = dataInputStream.readInt();
        if (n3 != 779316836 || n3 == 779314176 || n3 == 1684960046 || n3 == 6583086) {
            dataInputStream.reset();
            throw new UnsupportedAudioFileException("not an AU file");
        }
        if (n3 == 779316836 || n3 == 779314176) {
            bl2 = true;
        }
        n4 = bl2 ? dataInputStream.readInt() : this.rllong(dataInputStream);
        n13 += 4;
        n5 = bl2 ? dataInputStream.readInt() : this.rllong(dataInputStream);
        n13 += 4;
        n6 = bl2 ? dataInputStream.readInt() : this.rllong(dataInputStream);
        n13 += 4;
        n7 = bl2 ? dataInputStream.readInt() : this.rllong(dataInputStream);
        n13 += 4;
        n10 = bl2 ? dataInputStream.readInt() : this.rllong(dataInputStream);
        n13 += 4;
        n8 = n7;
        switch (n6) {
            case 1: {
                encoding = AudioFormat.Encoding.ULAW;
                n11 = 8;
                break;
            }
            case 27: {
                encoding = AudioFormat.Encoding.ALAW;
                n11 = 8;
                break;
            }
            case 2: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                n11 = 8;
                break;
            }
            case 3: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                n11 = 16;
                break;
            }
            case 4: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                n11 = 24;
                break;
            }
            case 5: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                n11 = 32;
                break;
            }
            default: {
                dataInputStream.reset();
                throw new UnsupportedAudioFileException("not a valid AU file");
            }
        }
        n9 = n11 / 8 * n10;
        n12 = n5 / n9;
        if (n12 <= 0) {
            n12 = -1;
        }
        audioFormat = new AudioFormat(encoding, n7, n11, n10, n9, n8, bl2);
        auFileFormat = new AuFileFormat(AudioFileFormat.Type.AU, n5 + n4, audioFormat, n12);
        dataInputStream.reset();
        return auFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        AudioFileFormat audioFileFormat = null;
        Object var5_5 = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        DataInputStream dataInputStream = null;
        AudioFileFormat audioFileFormat = null;
        AudioFormat audioFormat = null;
        audioFileFormat = this.getAudioFileFormat(inputStream);
        audioFormat = audioFileFormat.getFormat();
        dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readInt();
        int n2 = audioFormat.isBigEndian() ? dataInputStream.readInt() : this.rllong(dataInputStream);
        dataInputStream.skipBytes(n2 - 8);
        return new AudioInputStream(dataInputStream, audioFormat, audioFileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }
}

