/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AlawCodec
extends SunCodec {
    static final byte[] ALAW_TABH = new byte[256];
    static final byte[] ALAW_TABL = new byte[256];
    private static final boolean alawEncodes = true;
    private static final boolean alawDecodes = true;
    private static final AudioFormat.Encoding[] alawEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW, AudioFormat.Encoding.PCM_SIGNED};
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    static {
        int n2 = 0;
        while (n2 < 256) {
            int n3 = n2 ^ 0x55;
            int n4 = (n3 & 0xF) << 4;
            int n5 = (n3 & 0x70) >> 4;
            int n6 = n4 + 8;
            if (n5 >= 1) {
                n6 += 256;
            }
            if (n5 > 1) {
                n6 <<= n5 - 1;
            }
            if ((n3 & 0x80) == 0) {
                n6 = -n6;
            }
            AlawCodec.ALAW_TABL[n2] = (byte)n6;
            AlawCodec.ALAW_TABH[n2] = (byte)(n6 >> 8);
            ++n2;
        }
    }

    public AlawCodec() {
        super(alawEncodings, alawEncodings);
    }

    static short[] access$100() {
        return seg_end;
    }

    static byte[] access$000(AlawCodec alawCodec) {
        return alawCodec.tempBuffer;
    }

    private AudioFormat[] getOutputFormats(AudioFormat audioFormat) {
        AudioFormat audioFormat2;
        Vector vector = new Vector();
        if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.ALAW, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getFrameSize() / 2, audioFormat.getFrameRate(), false);
            vector.addElement(audioFormat2);
        }
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), false);
            vector.addElement(audioFormat2);
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), true);
            vector.addElement(audioFormat2);
        }
        AudioFormat[] audioFormatArray = new AudioFormat[vector.size()];
        int n2 = 0;
        while (n2 < audioFormatArray.length) {
            audioFormatArray[n2] = (AudioFormat)vector.elementAt(n2);
            ++n2;
        }
        return audioFormatArray;
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (audioFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW) || encoding.equals(AudioFormat.Encoding.ALAW) && audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return this.getOutputFormats(audioFormat);
        }
        return new AudioFormat[0];
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return this.getConvertedStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioInputStream audioInputStream2 = null;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (audioFormat2.matches(audioFormat)) {
            audioInputStream2 = audioInputStream;
        } else {
            audioInputStream2 = new AlawCodecStream(this, audioInputStream, audioFormat);
            this.tempBuffer = new byte[64];
        }
        return audioInputStream2;
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat.getEncoding();
        if (encoding2.equals(encoding)) {
            return audioInputStream;
        }
        AudioFormat audioFormat2 = null;
        if (!this.isConversionSupported(encoding, audioInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        if (encoding2.equals(AudioFormat.Encoding.ALAW) && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        } else if (encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.ALAW)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() / 2, audioFormat.getChannels(), audioFormat.getFrameSize() / 2, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    class AlawCodecStream
    extends AudioInputStream {
        boolean encode;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1;
        byte[] tabByte2;
        int highByte;
        int lowByte;
        private final AlawCodec this$0;

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, byArray.length);
        }

        private short search(short s2, short[] sArray, short s3) {
            short s4 = 0;
            while (s4 < s3) {
                if (s2 <= sArray[s4]) {
                    return s4;
                }
                s4 = (short)(s4 + 1);
            }
            return s3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (n3 % this.frameSize != 0) {
                n3 -= n3 % this.frameSize;
            }
            if (this.encode) {
                int n4 = 15;
                int n5 = 4;
                int n6 = 0;
                int n7 = n2;
                int n8 = n3 * 2;
                int n9 = n8 > 64 ? 64 : n8;
                while ((n6 = super.read(AlawCodec.access$000(this.this$0), 0, n9)) > 0) {
                    int n10 = 0;
                    while (n10 < n6) {
                        byte by;
                        int n11;
                        short s2 = (short)(AlawCodec.access$000(this.this$0)[n10 + this.highByte] << 8 & 0xFF00);
                        if ((s2 = (short)(s2 | (short)(AlawCodec.access$000(this.this$0)[n10 + this.lowByte] & 0xFF))) >= 0) {
                            n11 = 213;
                        } else {
                            n11 = 85;
                            s2 = (short)(-s2 - 8);
                        }
                        short s3 = this.search(s2, AlawCodec.access$100(), (short)8);
                        if (s3 >= 8) {
                            by = (byte)(0x7F ^ n11);
                        } else {
                            by = (byte)(s3 << n5);
                            by = s3 < 2 ? (byte)(by | (byte)(s2 >> 4 & n4)) : (byte)(by | (byte)(s2 >> s3 + 3 & n4));
                            by = (byte)(by ^ n11);
                        }
                        byArray[n7] = by;
                        ++n7;
                        n10 += 2;
                    }
                    int n12 = n9 = (n8 -= n6) > 64 ? 64 : n8;
                }
                if (n7 == n2 && n6 < 0) {
                    return n6;
                }
                return n7 - n2;
            }
            int n13 = n3 / 2;
            int n14 = n2 + n3 / 2;
            int n15 = super.read(byArray, n14, n13);
            int n16 = n2;
            while (n16 < n2 + n15 * 2) {
                byArray[n16] = this.tabByte1[byArray[n14] & 0xFF];
                byArray[n16 + 1] = this.tabByte2[byArray[n14] & 0xFF];
                ++n14;
                n16 += 2;
            }
            if (n15 < 0) {
                return n15;
            }
            return n16 - n2;
        }

        AlawCodecStream(AlawCodec alawCodec, AudioInputStream audioInputStream, AudioFormat audioFormat) {
            this.this$0 = alawCodec;
            super(audioInputStream, audioFormat, -1L);
            this.encode = false;
            this.tabByte1 = null;
            this.tabByte2 = null;
            this.highByte = 0;
            this.lowByte = 1;
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            if (!alawCodec.isConversionSupported(audioFormat, audioFormat2)) {
                throw new IllegalArgumentException("Unsupported conversion: " + audioFormat2.toString() + " to " + audioFormat.toString());
            }
            if (audioFormat2.getEncoding() == AudioFormat.Encoding.ALAW) {
                this.encode = false;
                this.encodeFormat = audioFormat2;
                this.decodeFormat = audioFormat;
            } else {
                this.encode = true;
                this.encodeFormat = audioFormat;
                this.decodeFormat = audioFormat2;
            }
            if (this.decodeFormat.isBigEndian()) {
                this.tabByte1 = ALAW_TABH;
                this.tabByte2 = ALAW_TABL;
            } else {
                this.tabByte1 = ALAW_TABL;
                this.tabByte2 = ALAW_TABH;
            }
            if (this.encodeFormat.isBigEndian()) {
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (audioInputStream instanceof AudioInputStream) {
                long l2;
                this.frameLength = l2 = audioInputStream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = audioFormat2.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }
    }
}

