/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.corba;

import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ConfigurationException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CorbaUtils {
    private static Method toStubMethod = null;
    private static Method connectMethod = null;
    private static Class corbaStubClass = null;
    static Class class$com$sun$jndi$toolkit$corba$CorbaUtils;
    static Class class$org$omg$CORBA$ORB;
    static Class class$java$rmi$Remote;

    private static void initMethodHandles() throws ClassNotFoundException {
        corbaStubClass = Class.forName("javax.rmi.CORBA.Stub");
        try {
            connectMethod = corbaStubClass.getMethod("connect", new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = CorbaUtils.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)");
        }
        Class clazz = Class.forName("javax.rmi.PortableRemoteObject");
        try {
            toStubMethod = clazz.getMethod("toStub", new Class[]{class$java$rmi$Remote == null ? (class$java$rmi$Remote = CorbaUtils.class$("java.rmi.Remote")) : class$java$rmi$Remote});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ORB getOrb(String string, int n2, Hashtable hashtable) {
        java.lang.Object object;
        Properties properties;
        if (hashtable != null) {
            if (hashtable instanceof Properties) {
                properties = (Properties)hashtable.clone();
            } else {
                properties = new Properties();
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    java.lang.Object object2 = hashtable.get(string2);
                    if (!(object2 instanceof String)) continue;
                    properties.put(string2, object2);
                }
            }
        } else {
            properties = new Properties();
        }
        if (string != null) {
            properties.put("org.omg.CORBA.ORBInitialHost", string);
        }
        if (n2 >= 0) {
            properties.put("org.omg.CORBA.ORBInitialPort", "" + n2);
        }
        object = null;
        if (hashtable != null) {
            object = (Applet)hashtable.get("java.naming.applet");
        }
        if (object != null) {
            return ORB.init((Applet)object, properties);
        }
        return ORB.init(new String[0], properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object remoteToCorba(Remote remote, ORB oRB) throws ClassNotFoundException, ConfigurationException {
        java.lang.Object object;
        Class clazz = class$com$sun$jndi$toolkit$corba$CorbaUtils == null ? (class$com$sun$jndi$toolkit$corba$CorbaUtils = CorbaUtils.class$("com.sun.jndi.toolkit.corba.CorbaUtils")) : class$com$sun$jndi$toolkit$corba$CorbaUtils;
        synchronized (clazz) {
            if (toStubMethod == null) {
                CorbaUtils.initMethodHandles();
            }
        }
        try {
            object = toStubMethod.invoke(null, new java.lang.Object[]{remote});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ConfigurationException configurationException = new ConfigurationException("Problem with PortableRemoteObject.toStub(); object not exported or stub not found");
            configurationException.setRootCause(throwable);
            throw configurationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
            configurationException.setRootCause(illegalAccessException);
            throw configurationException;
        }
        if (!corbaStubClass.isInstance(object)) {
            return null;
        }
        try {
            connectMethod.invoke(object, new java.lang.Object[]{oRB});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!(throwable instanceof RemoteException)) {
                ConfigurationException configurationException = new ConfigurationException("Problem invoking javax.rmi.CORBA.Stub.connect()");
                configurationException.setRootCause(throwable);
                throw configurationException;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.CORBA.Stub.connect()");
            configurationException.setRootCause(illegalAccessException);
            throw configurationException;
        }
        return (Object)object;
    }
}

