/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.rmi.registry;

import com.sun.jndi.rmi.registry.RegistryContext;
import com.sun.jndi.url.rmi.rmiURLContextFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

public class RegistryContextFactory
implements ObjectFactory,
InitialContextFactory {
    public static final String ADDRESS_TYPE = "URL";
    static Class class$com$sun$jndi$rmi$registry$RegistryContextFactory;

    private static boolean isRegistryRef(Object object) {
        if (!(object instanceof Reference)) {
            return false;
        }
        String string = (class$com$sun$jndi$rmi$registry$RegistryContextFactory == null ? (class$com$sun$jndi$rmi$registry$RegistryContextFactory = RegistryContextFactory.class$("com.sun.jndi.rmi.registry.RegistryContextFactory")) : class$com$sun$jndi$rmi$registry$RegistryContextFactory).getName();
        Reference reference = (Reference)object;
        return string.equals(reference.getFactoryClassName());
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getInitCtxURL(Hashtable hashtable) {
        String string = null;
        if (hashtable != null) {
            string = (String)hashtable.get("java.naming.provider.url");
        }
        return string != null ? string : "rmi:";
    }

    private static String[] getURLs(Reference reference) throws NamingException {
        String[] stringArray;
        int n2 = 0;
        String[] stringArray2 = new String[reference.size()];
        Enumeration enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!(stringArray instanceof StringRefAddr) || !stringArray.getType().equals(ADDRESS_TYPE)) continue;
            stringArray2[n2++] = (String)stringArray.getContent();
        }
        if (n2 == 0) {
            throw new ConfigurationException("Reference contains no valid addresses");
        }
        if (n2 == reference.size()) {
            return stringArray2;
        }
        stringArray = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        return stringArray;
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        if (hashtable != null) {
            hashtable = (Hashtable)hashtable.clone();
        }
        return RegistryContextFactory.URLToContext(RegistryContextFactory.getInitCtxURL(hashtable), hashtable);
    }

    private static Object URLsToObject(String[] stringArray, Hashtable hashtable) throws NamingException {
        rmiURLContextFactory rmiURLContextFactory2 = new rmiURLContextFactory();
        return rmiURLContextFactory2.getObjectInstance(stringArray, null, null, hashtable);
    }

    private static Context URLToContext(String string, Hashtable hashtable) throws NamingException {
        rmiURLContextFactory rmiURLContextFactory2 = new rmiURLContextFactory();
        Object object = rmiURLContextFactory2.getObjectInstance(string, null, null, hashtable);
        if (object instanceof Context) {
            return (Context)object;
        }
        throw new NotContextException(string);
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        if (!RegistryContextFactory.isRegistryRef(object)) {
            return null;
        }
        Object object2 = RegistryContextFactory.URLsToObject(RegistryContextFactory.getURLs((Reference)object), hashtable);
        if (object2 instanceof RegistryContext) {
            RegistryContext registryContext = (RegistryContext)object2;
            registryContext.reference = (Reference)object;
        }
        return object2;
    }
}

