/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.ServiceLocator;
import com.sun.jndi.url.ldap.ldapURLContextFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

public final class LdapCtxFactory
implements ObjectFactory,
InitialContextFactory {
    public static final String ADDRESS_TYPE = "URL";
    static Class class$com$sun$jndi$ldap$LdapCtxFactory;

    private static boolean isLdapRef(Object object) {
        if (!(object instanceof Reference)) {
            return false;
        }
        String string = (class$com$sun$jndi$ldap$LdapCtxFactory == null ? (class$com$sun$jndi$ldap$LdapCtxFactory = LdapCtxFactory.class$("com.sun.jndi.ldap.LdapCtxFactory")) : class$com$sun$jndi$ldap$LdapCtxFactory).getName();
        Reference reference = (Reference)object;
        return string.equals(reference.getFactoryClassName());
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String[] getURLs(Reference reference) throws NamingException {
        String[] stringArray;
        int n2 = 0;
        String[] stringArray2 = new String[reference.size()];
        Enumeration enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!(stringArray instanceof StringRefAddr) || !stringArray.getType().equals(ADDRESS_TYPE)) continue;
            stringArray2[n2++] = (String)stringArray.getContent();
        }
        if (n2 == 0) {
            throw new ConfigurationException("Reference contains no valid addresses");
        }
        if (n2 == reference.size()) {
            return stringArray2;
        }
        stringArray = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        return stringArray;
    }

    private static void getClassesAux(Class clazz, Vector vector) {
        if (!vector.contains(clazz.getName())) {
            vector.addElement(clazz.getName());
        }
        clazz = clazz.getSuperclass();
        while (clazz != null) {
            LdapCtxFactory.getTypeNames(clazz, vector);
            clazz = clazz.getSuperclass();
        }
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        try {
            String string;
            String string2 = string = hashtable != null ? (String)hashtable.get("java.naming.provider.url") : null;
            if (string == null) {
                return new LdapCtx("", "localhost", 389, hashtable);
            }
            String[] stringArray = LdapURL.fromList(string);
            if (stringArray.length == 0) {
                throw new ConfigurationException("java.naming.provider.url property does not contain a URL");
            }
            return LdapCtxFactory.getLdapCtxInstance(stringArray, hashtable);
        }
        catch (LdapReferralException ldapReferralException) {
            if (hashtable != null && "throw".equals(hashtable.get("java.naming.referral"))) {
                throw ldapReferralException;
            }
            Control[] controlArray = hashtable != null ? (Control[])hashtable.get("java.naming.ldap.control.connect") : null;
            return (LdapCtx)ldapReferralException.getReferralContext(hashtable, controlArray);
        }
    }

    public static Attribute createTypeNameAttr(Class clazz) {
        Vector vector = new Vector(10);
        String[] stringArray = LdapCtxFactory.getTypeNames(clazz, vector);
        if (stringArray.length > 0) {
            BasicAttribute basicAttribute = new BasicAttribute(Obj.JAVA_ATTRIBUTES[6]);
            int n2 = 0;
            while (n2 < stringArray.length) {
                basicAttribute.add(stringArray[n2]);
                ++n2;
            }
            return basicAttribute;
        }
        return null;
    }

    private static String[] getTypeNames(Class clazz, Vector vector) {
        LdapCtxFactory.getClassesAux(clazz, vector);
        Class[] classArray = clazz.getInterfaces();
        int n2 = 0;
        while (n2 < classArray.length) {
            LdapCtxFactory.getClassesAux(classArray[n2], vector);
            ++n2;
        }
        String[] stringArray = new String[vector.size()];
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n3++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static DirContext getLdapCtxInstance(Object object, Hashtable hashtable) throws NamingException {
        if (object instanceof String) {
            return LdapCtxFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return LdapCtxFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new IllegalArgumentException("argument must be an LDAP URL String or array of them");
    }

    private static DirContext getUsingURL(String string, Hashtable hashtable) throws NamingException {
        String[] stringArray;
        DirContext dirContext = null;
        LdapURL ldapURL = new LdapURL(string);
        String string2 = ldapURL.getDN();
        String string3 = ldapURL.getHost();
        int n2 = ldapURL.getPort();
        String string4 = null;
        if (string3 == null && n2 == -1 && string2 != null && (string4 = ServiceLocator.mapDnToDomainName(string2)) != null && (stringArray = ServiceLocator.getLdapService(string4, hashtable)) != null) {
            String[] stringArray2 = new String[stringArray.length];
            String string5 = ldapURL.getQuery();
            String string6 = ldapURL.getPath() + (string5 != null ? string5 : "");
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray2[n3] = "ldap://" + stringArray[n3] + string6;
                ++n3;
            }
            dirContext = LdapCtxFactory.getUsingURLs(stringArray2, hashtable);
            ((LdapCtx)dirContext).setDomainName(string4);
        } else {
            dirContext = new LdapCtx(string2, string3, n2, hashtable);
            ((LdapCtx)dirContext).setProviderUrl(string);
        }
        return dirContext;
    }

    private static DirContext getUsingURLs(String[] stringArray, Hashtable hashtable) throws NamingException {
        NamingException namingException = null;
        Object var3_3 = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                return LdapCtxFactory.getUsingURL(stringArray[n2], hashtable);
            }
            catch (NamingException namingException2) {
                namingException = namingException2;
                ++n2;
            }
        }
        throw namingException;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (!LdapCtxFactory.isLdapRef(object)) {
            return null;
        }
        ldapURLContextFactory ldapURLContextFactory2 = new ldapURLContextFactory();
        String[] stringArray = LdapCtxFactory.getURLs((Reference)object);
        return ldapURLContextFactory2.getObjectInstance(stringArray, name, context, hashtable);
    }
}

