/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.ResourceRecord;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingException;

class ResourceRecords {
    Vector question = new Vector();
    Vector answer = new Vector();
    Vector authority = new Vector();
    Vector additional = new Vector();
    boolean zoneXfer;

    int getFirstAnsType() {
        if (this.answer.size() == 0) {
            return -1;
        }
        return ((ResourceRecord)this.answer.firstElement()).getType();
    }

    int getLastAnsType() {
        if (this.answer.size() == 0) {
            return -1;
        }
        return ((ResourceRecord)this.answer.lastElement()).getType();
    }

    void add(byte[] byArray, int n2, Header header) throws NamingException {
        int n3 = 12;
        try {
            ResourceRecord resourceRecord;
            int n4 = 0;
            while (n4 < header.numQuestions) {
                resourceRecord = new ResourceRecord(byArray, n2, n3, true, false);
                if (!this.zoneXfer) {
                    this.question.addElement(resourceRecord);
                }
                n3 += resourceRecord.size();
                ++n4;
            }
            int n5 = 0;
            while (n5 < header.numAnswers) {
                resourceRecord = new ResourceRecord(byArray, n2, n3, false, !this.zoneXfer);
                this.answer.addElement(resourceRecord);
                n3 += resourceRecord.size();
                ++n5;
            }
            if (this.zoneXfer) {
                return;
            }
            int n6 = 0;
            while (n6 < header.numAuthorities) {
                resourceRecord = new ResourceRecord(byArray, n2, n3, false, true);
                this.authority.addElement(resourceRecord);
                n3 += resourceRecord.size();
                ++n6;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CommunicationException("DNS error: corrupted message");
        }
    }

    ResourceRecords(byte[] byArray, int n2, Header header, boolean bl2) throws NamingException {
        if (bl2) {
            this.answer.ensureCapacity(8192);
        }
        this.zoneXfer = bl2;
        this.add(byArray, n2, header);
    }
}

