/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsButtonListener;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsButtonUI
extends BasicButtonUI {
    private static final WindowsButtonUI windowsButtonUI = new WindowsButtonUI();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean defaults_initialized = false;

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            String string = this.getPropertyPrefix();
            this.dashedRectGapX = UIManager.getInt(string + "dashedRectGapX");
            this.dashedRectGapY = UIManager.getInt(string + "dashedRectGapY");
            this.dashedRectGapWidth = UIManager.getInt(string + "dashedRectGapWidth");
            this.dashedRectGapHeight = UIManager.getInt(string + "dashedRectGapHeight");
            this.focusColor = UIManager.getColor(string + "focus");
            this.defaults_initialized = true;
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton.isFocusPainted()) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.setTextShiftOffset();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsButtonUI;
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new WindowsButtonListener(abstractButton);
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        WindowsGraphicsUtils.paintText(graphics, abstractButton, rectangle, string, this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.getParent() instanceof JToolBar) {
            return;
        }
        int n2 = abstractButton.getWidth();
        int n3 = abstractButton.getHeight();
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, n2 - this.dashedRectGapWidth, n3 - this.dashedRectGapHeight);
    }
}

