/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class MarkerSegment
implements Cloneable {
    protected static final int LENGTH_SIZE = 2;
    int tag;
    int length;
    byte[] data = null;
    boolean unknown = false;

    void print() {
        this.printTag("Unknown");
        if (this.length > 10) {
            System.out.print("First 5 bytes:");
            int n2 = 0;
            while (n2 < 5) {
                System.out.print(" Ox" + Integer.toHexString(this.data[n2]));
                ++n2;
            }
            System.out.print("\nLast 5 bytes:");
            int n3 = this.data.length - 5;
            while (n3 < this.data.length) {
                System.out.print(" Ox" + Integer.toHexString(this.data[n3]));
                ++n3;
            }
        } else {
            System.out.print("Data:");
            int n4 = 0;
            while (n4 < this.data.length) {
                System.out.print(" Ox" + Integer.toHexString(this.data[n4]));
                ++n4;
            }
        }
        System.out.println();
    }

    MarkerSegment(int n2) {
        this.tag = n2;
        this.length = 0;
    }

    MarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        jPEGBuffer.loadBuf(3);
        this.tag = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.length = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.length |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.length -= 2;
        jPEGBuffer.bufAvail -= 3;
        jPEGBuffer.loadBuf(this.length);
    }

    void loadData(JPEGBuffer jPEGBuffer) throws IOException {
        this.data = new byte[this.length];
        jPEGBuffer.readData(this.data);
    }

    protected Object clone() {
        MarkerSegment markerSegment = null;
        try {
            markerSegment = (MarkerSegment)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.data != null) {
            markerSegment.data = (byte[])this.data.clone();
        }
        return markerSegment;
    }

    void printTag(String string) {
        System.out.println(string + " marker segment - marker = 0x" + Integer.toHexString(this.tag));
        System.out.println("length: " + this.length);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("unknown");
        iIOMetadataNode.setAttribute("MarkerTag", Integer.toString(this.tag));
        iIOMetadataNode.setUserObject(this.data);
        return iIOMetadataNode;
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
        this.length = 2 + (this.data != null ? this.data.length : 0);
        this.writeTag(imageOutputStream);
        if (this.data != null) {
            imageOutputStream.write(this.data);
        }
    }

    void writeTag(ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.write(255);
        imageOutputStream.write(this.tag);
        MarkerSegment.write2bytes(imageOutputStream, this.length);
    }

    static void write2bytes(ImageOutputStream imageOutputStream, int n2) throws IOException {
        imageOutputStream.write(n2 >> 8 & 0xFF);
        imageOutputStream.write(n2 & 0xFF);
    }

    MarkerSegment(Node node) throws IIOInvalidTreeException {
        this.tag = MarkerSegment.getAttributeValue(node, null, "MarkerTag", 0, 255, true);
        this.length = 0;
        if (node instanceof IIOMetadataNode) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
            try {
                this.data = (byte[])iIOMetadataNode.getUserObject();
            }
            catch (Exception exception) {
                IIOInvalidTreeException iIOInvalidTreeException = new IIOInvalidTreeException("Can't get User Object", node);
                iIOInvalidTreeException.initCause(exception);
                throw iIOInvalidTreeException;
            }
        } else {
            throw new IIOInvalidTreeException("Node must have User Object", node);
        }
    }

    static int getAttributeValue(Node node, NamedNodeMap namedNodeMap, String string, int n2, int n3, boolean bl2) throws IIOInvalidTreeException {
        if (namedNodeMap == null) {
            namedNodeMap = node.getAttributes();
        }
        String string2 = namedNodeMap.getNamedItem(string).getNodeValue();
        int n4 = -1;
        if (string2 == null) {
            if (bl2) {
                throw new IIOInvalidTreeException(string + " attribute not found", node);
            }
        } else {
            n4 = Integer.parseInt(string2);
            if (n4 < n2 || n4 > n3) {
                throw new IIOInvalidTreeException(string + " attribute out of range", node);
            }
        }
        return n4;
    }
}

