/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.ObjectStreamClass;
import com.sun.corba.se.internal.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.ValueHandlerImpl;
import com.sun.corba.se.internal.util.RepositoryId;
import com.sun.org.omg.CORBA.AttributeDescription;
import com.sun.org.omg.CORBA.Initializer;
import com.sun.org.omg.CORBA.OperationDescription;
import com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.sun.org.omg.CORBA._IDLTypeStub;
import com.sun.org.omg.SendingContext.CodeBase;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Stack;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;

public class ValueUtility {
    public static final short PRIVATE_MEMBER = 0;
    public static final short PUBLIC_MEMBER = 1;
    private static final String[] primitiveConstants = new String[]{null, null, "S", "I", "S", "I", "F", "D", "Z", "C", "B", null, null, null, null, null, null, null, null, null, null, null, null, "J", "J", "D", "C", null, null, null, null, null, null};
    static Class class$java$rmi$Remote;
    static Class class$java$io$Serializable;
    static Class class$java$lang$String;
    static Class class$org$omg$CORBA$Object;

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static boolean exists(String string, String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getSignature(ValueMember valueMember) throws ClassNotFoundException {
        if (valueMember.type.kind().value() == 30 || valueMember.type.kind().value() == 29 || valueMember.type.kind().value() == 14) {
            Class clazz = RepositoryId.cache.getId(valueMember.id).getClassFromType();
            return ObjectStreamClass.getSignature(clazz);
        }
        return primitiveConstants[valueMember.type.kind().value()];
    }

    public static boolean isAssignableFrom(String string, FullValueDescription fullValueDescription, CodeBase codeBase) {
        if (ValueUtility.exists(string, fullValueDescription.supported_interfaces)) {
            return true;
        }
        if (string.equals(fullValueDescription.id)) {
            return true;
        }
        if (fullValueDescription.base_value != null && !fullValueDescription.base_value.equals("")) {
            FullValueDescription fullValueDescription2 = codeBase.meta(fullValueDescription.base_value);
            return ValueUtility.isAssignableFrom(string, fullValueDescription2, codeBase);
        }
        return false;
    }

    public static FullValueDescription translate(ORB oRB, ObjectStreamClass objectStreamClass, ValueHandler valueHandler) {
        FullValueDescription fullValueDescription = new FullValueDescription();
        Class clazz = objectStreamClass.forClass();
        ValueHandlerImpl valueHandlerImpl = (ValueHandlerImpl)valueHandler;
        String string = valueHandlerImpl.createForAnyType(clazz);
        fullValueDescription.name = valueHandlerImpl.getUnqualifiedName(string);
        if (fullValueDescription.name == null) {
            fullValueDescription.name = "";
        }
        fullValueDescription.id = valueHandlerImpl.getRMIRepositoryID(clazz);
        if (fullValueDescription.id == null) {
            fullValueDescription.id = "";
        }
        fullValueDescription.is_abstract = ObjectStreamClassCorbaExt.isAbstractInterface(clazz);
        fullValueDescription.is_custom = objectStreamClass.isCustomMarshaled();
        fullValueDescription.defined_in = valueHandlerImpl.getDefinedInId(string);
        if (fullValueDescription.defined_in == null) {
            fullValueDescription.defined_in = "";
        }
        fullValueDescription.version = valueHandlerImpl.getSerialVersionUID(string);
        if (fullValueDescription.version == null) {
            fullValueDescription.version = "";
        }
        fullValueDescription.operations = new OperationDescription[0];
        fullValueDescription.attributes = new AttributeDescription[0];
        IdentityKeyValueStack identityKeyValueStack = new IdentityKeyValueStack(null);
        fullValueDescription.members = ValueUtility.translateMembers(oRB, objectStreamClass, valueHandler, identityKeyValueStack);
        fullValueDescription.initializers = new Initializer[0];
        Class[] classArray = objectStreamClass.forClass().getInterfaces();
        int n2 = 0;
        fullValueDescription.supported_interfaces = new String[classArray.length];
        int n3 = 0;
        while (n3 < classArray.length) {
            fullValueDescription.supported_interfaces[n3] = valueHandlerImpl.createForAnyType(classArray[n3]);
            if (!(class$java$rmi$Remote == null ? ValueUtility.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(classArray[n3]) || !Modifier.isPublic(classArray[n3].getModifiers())) {
                ++n2;
            }
            ++n3;
        }
        fullValueDescription.abstract_base_values = new String[n2];
        int n4 = 0;
        while (n4 < classArray.length) {
            if (!(class$java$rmi$Remote == null ? ValueUtility.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(classArray[n4]) || !Modifier.isPublic(classArray[n4].getModifiers())) {
                fullValueDescription.abstract_base_values[n4] = valueHandlerImpl.createForAnyType(classArray[n4]);
            }
            ++n4;
        }
        fullValueDescription.is_truncatable = false;
        Class clazz2 = objectStreamClass.forClass().getSuperclass();
        fullValueDescription.base_value = (class$java$io$Serializable == null ? (class$java$io$Serializable = ValueUtility.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz2) ? valueHandlerImpl.getRMIRepositoryID(clazz2) : "";
        fullValueDescription.type = oRB.get_primitive_tc(TCKind.tk_value);
        return fullValueDescription;
    }

    public static TypeCode createTypeCodeForClass(ORB oRB, Class clazz, ValueHandler valueHandler) {
        IdentityKeyValueStack identityKeyValueStack = new IdentityKeyValueStack(null);
        TypeCode typeCode = ValueUtility.createTypeCodeForClassInternal(oRB, clazz, valueHandler, identityKeyValueStack);
        return typeCode;
    }

    public static TypeCode getPrimitiveTypeCodeForClass(ORB oRB, Class clazz, ValueHandler valueHandler) {
        if (clazz == Integer.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_long);
        }
        if (clazz == Byte.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_octet);
        }
        if (clazz == Long.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_longlong);
        }
        if (clazz == Float.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_float);
        }
        if (clazz == Double.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_double);
        }
        if (clazz == Short.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_short);
        }
        if (clazz == Character.TYPE) {
            return oRB.get_primitive_tc(((ValueHandlerImpl)valueHandler).getJavaCharTCKind());
        }
        if (clazz == Boolean.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_boolean);
        }
        return oRB.get_primitive_tc(TCKind.tk_any);
    }

    private static TypeCode createTypeCodeForClassInternal(ORB oRB, Class clazz, ValueHandler valueHandler, IdentityKeyValueStack identityKeyValueStack) {
        TypeCode typeCode = null;
        String string = (String)identityKeyValueStack.get(clazz);
        if (string != null) {
            return oRB.create_recursive_tc(string);
        }
        string = valueHandler.getRMIRepositoryID(clazz);
        if (string == null) {
            string = "";
        }
        identityKeyValueStack.push(clazz, string);
        typeCode = ValueUtility.createTypeCodeInternal(oRB, clazz, valueHandler, string, identityKeyValueStack);
        identityKeyValueStack.pop();
        return typeCode;
    }

    private static ValueMember[] translateMembers(ORB oRB, ObjectStreamClass objectStreamClass, ValueHandler valueHandler, IdentityKeyValueStack identityKeyValueStack) {
        ValueHandlerImpl valueHandlerImpl = (ValueHandlerImpl)valueHandler;
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
        int n2 = objectStreamFieldArray.length;
        ValueMember[] valueMemberArray = new ValueMember[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            String string = valueHandlerImpl.getRMIRepositoryID(objectStreamFieldArray[n3].getClazz());
            valueMemberArray[n3] = new ValueMember();
            valueMemberArray[n3].name = objectStreamFieldArray[n3].getName();
            valueMemberArray[n3].id = string;
            valueMemberArray[n3].defined_in = valueHandlerImpl.getDefinedInId(string);
            valueMemberArray[n3].version = "1.0";
            valueMemberArray[n3].type_def = new _IDLTypeStub();
            valueMemberArray[n3].access = objectStreamFieldArray[n3].getField() == null ? (short)0 : (Modifier.isPublic(n4 = objectStreamFieldArray[n3].getField().getModifiers()) ? (short)1 : 0);
            switch (objectStreamFieldArray[n3].getTypeCode()) {
                case 'B': {
                    valueMemberArray[n3].type = oRB.get_primitive_tc(TCKind.tk_octet);
                    break;
                }
                case 'C': {
                    valueMemberArray[n3].type = oRB.get_primitive_tc(valueHandlerImpl.getJavaCharTCKind());
                    break;
                }
                case 'F': {
                    valueMemberArray[n3].type = oRB.get_primitive_tc(TCKind.tk_float);
                    break;
                }
                case 'D': {
                    valueMemberArray[n3].type = oRB.get_primitive_tc(TCKind.tk_double);
                    break;
                }
                case 'I': {
                    valueMemberArray[n3].type = oRB.get_primitive_tc(TCKind.tk_long);
                    break;
                }
                case 'J': {
                    valueMemberArray[n3].type = oRB.get_primitive_tc(TCKind.tk_longlong);
                    break;
                }
                case 'S': {
                    valueMemberArray[n3].type = oRB.get_primitive_tc(TCKind.tk_short);
                    break;
                }
                case 'Z': {
                    valueMemberArray[n3].type = oRB.get_primitive_tc(TCKind.tk_boolean);
                    break;
                }
                default: {
                    valueMemberArray[n3].type = ValueUtility.createTypeCodeForClassInternal(oRB, objectStreamFieldArray[n3].getClazz(), valueHandlerImpl, identityKeyValueStack);
                    valueMemberArray[n3].id = valueHandlerImpl.createForAnyType(objectStreamFieldArray[n3].getType());
                }
            }
            ++n3;
        }
        return valueMemberArray;
    }

    private static TypeCode createTypeCodeInternal(ORB oRB, Class clazz, ValueHandler valueHandler, String string, IdentityKeyValueStack identityKeyValueStack) {
        if (clazz.isArray()) {
            Class clazz2 = clazz.getComponentType();
            TypeCode typeCode = clazz2.isPrimitive() ? ValueUtility.getPrimitiveTypeCodeForClass(oRB, clazz2, valueHandler) : ValueUtility.createTypeCodeForClassInternal(oRB, clazz2, valueHandler, identityKeyValueStack);
            TypeCode typeCode2 = oRB.create_sequence_tc(0, typeCode);
            return oRB.create_value_box_tc(string, "Sequence", typeCode2);
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = ValueUtility.class$("java.lang.String")) : class$java$lang$String)) {
            TypeCode typeCode = oRB.create_string_tc(0);
            return oRB.create_value_box_tc(string, "StringValue", typeCode);
        }
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueUtility.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
            return oRB.get_primitive_tc(TCKind.tk_objref);
        }
        if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = ValueUtility.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz)) {
            return oRB.get_primitive_tc(TCKind.tk_objref);
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass == null) {
            return oRB.create_value_box_tc(string, "Value", oRB.get_primitive_tc(TCKind.tk_value));
        }
        short s2 = objectStreamClass.isCustomMarshaled() ? (short)1 : 0;
        TypeCode typeCode = null;
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 != null && (class$java$io$Serializable == null ? (class$java$io$Serializable = ValueUtility.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz3)) {
            typeCode = ValueUtility.createTypeCodeForClassInternal(oRB, clazz3, valueHandler, identityKeyValueStack);
        }
        ValueMember[] valueMemberArray = ValueUtility.translateMembers(oRB, objectStreamClass, valueHandler, identityKeyValueStack);
        return oRB.create_value_tc(string, clazz.getName(), s2, typeCode, valueMemberArray);
    }

    class 1 {
    }

    private static class IdentityKeyValueStack {
        Stack pairs = null;

        private IdentityKeyValueStack() {
        }

        void pop() {
            this.pairs.pop();
        }

        IdentityKeyValueStack(1 var1_1) {
            this();
        }

        Object get(Object object) {
            if (this.pairs == null) {
                return null;
            }
            Iterator iterator = this.pairs.iterator();
            while (iterator.hasNext()) {
                KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
                if (keyValuePair.key != object) continue;
                return keyValuePair.value;
            }
            return null;
        }

        void push(Object object, Object object2) {
            if (this.pairs == null) {
                this.pairs = new Stack();
            }
            this.pairs.push(new KeyValuePair(object, object2));
        }

        private static class KeyValuePair {
            Object key;
            Object value;

            boolean equals(KeyValuePair keyValuePair) {
                return keyValuePair.key == this.key;
            }

            KeyValuePair(Object object, Object object2) {
                this.key = object;
                this.value = object2;
            }
        }
    }
}

