/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.InputStreamHook;
import com.sun.corba.se.internal.io.ObjectStreamClass;
import com.sun.corba.se.internal.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.ValueHandlerImpl;
import com.sun.corba.se.internal.io.ValueUtility;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA_2_3.portable.InputStream;

public class IIOPInputStream
extends InputStreamHook {
    private ValueMember[] defaultReadObjectFVDMembers = null;
    private InputStream orbStream;
    private CodeBase cbSender;
    private ValueHandlerImpl vhandler;
    private Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private Class currentClass = null;
    private int recursionDepth = 0;
    private int simpleReadDepth = 0;
    ActiveRecursionManager activeRecursionMgr = new ActiveRecursionManager();
    private IOException abortIOException = null;
    private ClassNotFoundException abortClassNotFoundException = null;
    private Vector callbacks;
    ObjectStreamClass[] classdesc;
    Class[] classes;
    int spClass;
    private static final String kEmptyStr = "";
    public static final TypeCode kRemoteTypeCode = ORB.init().get_primitive_tc(TCKind.tk_objref);
    public static final TypeCode kValueTypeCode = ORB.init().get_primitive_tc(TCKind.tk_value);
    private static final boolean useFVDOnly = false;
    static Class class$java$lang$ClassNotFoundException;
    static Class class$java$io$IOException;
    static Class class$java$io$NotActiveException;
    static Class class$java$rmi$Remote;
    static Class class$org$omg$CORBA$Object;

    public final byte readByte() throws IOException {
        try {
            return this.orbStream.read_octet();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final char readChar() throws IOException {
        try {
            return this.orbStream.read_wchar();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final double readDouble() throws IOException {
        try {
            return this.orbStream.read_double();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final float readFloat() throws IOException {
        try {
            return this.orbStream.read_float();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final int available() throws IOException {
        return 0;
    }

    public final int decreaseRecursionDepth() {
        return --this.recursionDepth;
    }

    public final int read() throws IOException {
        try {
            return this.orbStream.read_octet() << 0 & 0xFF;
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final int readInt() throws IOException {
        try {
            return this.orbStream.read_long();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final int readUnsignedByte() throws IOException {
        try {
            return this.orbStream.read_octet() << 0 & 0xFF;
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final int readUnsignedShort() throws IOException {
        try {
            return this.orbStream.read_ushort() << 0 & 0xFFFF;
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final long readLong() throws IOException {
        try {
            return this.orbStream.read_longlong();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final short readShort() throws IOException {
        try {
            return this.orbStream.read_short();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public IIOPInputStream() throws IOException {
        this.resetStream();
    }

    public final void close() throws IOException {
    }

    public final void defaultReadObjectDelegate() {
        try {
            if (this.currentObject == null || this.currentClassDesc == null) {
                throw new NotActiveException("defaultReadObjectDelegate");
            }
            if (this.defaultReadObjectFVDMembers != null && this.defaultReadObjectFVDMembers.length > 0) {
                this.inputClassFields(this.currentObject, this.currentClass, this.currentClassDesc, this.defaultReadObjectFVDMembers, this.cbSender);
            } else {
                ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
                if (objectStreamFieldArray.length > 0) {
                    this.inputClassFields(this.currentObject, this.currentClass, objectStreamFieldArray, this.cbSender);
                }
            }
        }
        catch (NotActiveException notActiveException) {
            IIOPInputStream.throwExceptionType(class$java$io$NotActiveException == null ? (class$java$io$NotActiveException = IIOPInputStream.class$("java.io.NotActiveException")) : class$java$io$NotActiveException, notActiveException.getMessage());
        }
        catch (IOException iOException) {
            IIOPInputStream.throwExceptionType(class$java$io$IOException == null ? (class$java$io$IOException = IIOPInputStream.class$("java.io.IOException")) : class$java$io$IOException, iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            IIOPInputStream.throwExceptionType(class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = IIOPInputStream.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException, classNotFoundException.getMessage());
        }
    }

    public final void increaseRecursionDepth() {
        ++this.recursionDepth;
    }

    protected final void readStreamHeader() throws IOException, StreamCorruptedException {
    }

    public final void reset() throws IOException {
        try {
            this.orbStream.reset();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    private void resetStream() throws IOException {
        int n2;
        if (this.classes == null) {
            this.classes = new Class[20];
        } else {
            n2 = 0;
            while (n2 < this.classes.length) {
                this.classes[n2] = null;
                ++n2;
            }
        }
        if (this.classdesc == null) {
            this.classdesc = new ObjectStreamClass[20];
        } else {
            n2 = 0;
            while (n2 < this.classdesc.length) {
                this.classdesc[n2] = null;
                ++n2;
            }
        }
        this.spClass = 0;
        if (this.callbacks != null) {
            this.callbacks.setSize(0);
        }
    }

    public final boolean markSupported() {
        return this.orbStream.markSupported();
    }

    private final boolean mustUseRemoteValueMembers() {
        return this.defaultReadObjectFVDMembers != null;
    }

    public final boolean readBoolean() throws IOException {
        try {
            return this.orbStream.read_boolean();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final int skipBytes(int n2) throws IOException {
        try {
            byte[] byArray = new byte[n2];
            this.orbStream.read_octet_array(byArray, 0, n2);
            return n2;
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void mark(int n2) {
        this.orbStream.mark(n2);
    }

    public static void setTestFVDFlag(boolean bl2) {
    }

    public final boolean enableResolveObjectDelegate(boolean bl2) {
        return false;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.orbStream.read_octet_array(byArray, n2, n3);
            return n3;
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void readFully(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.orbStream.read_octet_array(byArray, n2, n3);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final CodeBase getSender() {
        return this.cbSender;
    }

    public final void setSender(CodeBase codeBase) {
        this.cbSender = codeBase;
    }

    public final synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n2) throws NotActiveException, InvalidObjectException {
        throw new Error("Method registerValidation not supported");
    }

    public final Object readObjectDelegate() throws IOException {
        try {
            return this.orbStream.read_abstract_interface();
        }
        catch (IndirectionException indirectionException) {
            return this.activeRecursionMgr.getObject(indirectionException.offset);
        }
    }

    protected final Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        return this.readObjectDelegate();
    }

    private static native void setByteFieldOpt(Object var0, long var1, byte var3);

    private static native void setCharFieldOpt(Object var0, long var1, char var3);

    private static native void setDoubleFieldOpt(Object var0, long var1, double var3);

    private static native void setFloatFieldOpt(Object var0, long var1, float var3);

    private static native void setIntFieldOpt(Object var0, long var1, int var3);

    private static native void setLongFieldOpt(Object var0, long var1, long var3);

    private static native void setShortFieldOpt(Object var0, long var1, short var3);

    private static native void setBooleanFieldOpt(Object var0, long var1, boolean var3);

    public final String readLine() throws IOException {
        throw new IOException("Method readLine not supported");
    }

    public final String readUTF() throws IOException {
        try {
            return this.internalReadUTF(this.orbStream);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    private final void inputCurrentClassFieldsForReadFields(Map map) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        int n2;
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        int n3 = objectStreamFieldArray.length - this.currentClassDesc.objFields;
        int n4 = 0;
        while (n4 < n3) {
            switch (objectStreamFieldArray[n4].getTypeCode()) {
                case 'B': {
                    n2 = this.orbStream.read_octet();
                    map.put(objectStreamFieldArray[n4].getName(), new Byte((byte)n2));
                    break;
                }
                case 'Z': {
                    boolean bl2 = this.orbStream.read_boolean();
                    map.put(objectStreamFieldArray[n4].getName(), new Boolean(bl2));
                    break;
                }
                case 'C': {
                    char c2 = this.orbStream.read_wchar();
                    map.put(objectStreamFieldArray[n4].getName(), new Character(c2));
                    break;
                }
                case 'S': {
                    short s2 = this.orbStream.read_short();
                    map.put(objectStreamFieldArray[n4].getName(), new Short(s2));
                    break;
                }
                case 'I': {
                    int n5 = this.orbStream.read_long();
                    map.put(objectStreamFieldArray[n4].getName(), new Integer(n5));
                    break;
                }
                case 'J': {
                    long l2 = this.orbStream.read_longlong();
                    map.put(objectStreamFieldArray[n4].getName(), new Long(l2));
                    break;
                }
                case 'F': {
                    float f2 = this.orbStream.read_float();
                    map.put(objectStreamFieldArray[n4].getName(), new Float(f2));
                    break;
                }
                case 'D': {
                    double d2 = this.orbStream.read_double();
                    map.put(objectStreamFieldArray[n4].getName(), new Double(d2));
                    break;
                }
                default: {
                    throw new InvalidClassException(this.currentClassDesc.getName());
                }
            }
            ++n4;
        }
        if (this.currentClassDesc.objFields > 0) {
            n2 = n3;
            while (n2 < objectStreamFieldArray.length) {
                Object object = null;
                try {
                    object = this.inputObjectField(objectStreamFieldArray[n2]);
                }
                catch (IndirectionException indirectionException) {
                    object = this.activeRecursionMgr.getObject(indirectionException.offset);
                }
                map.put(objectStreamFieldArray[n2].getName(), object);
                ++n2;
            }
        }
    }

    private final void inputRemoteMembersForReadFields(Map map) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        ValueMember[] valueMemberArray = this.defaultReadObjectFVDMembers;
        try {
            int n2 = 0;
            while (n2 < valueMemberArray.length) {
                switch (valueMemberArray[n2].type.kind().value()) {
                    case 10: {
                        byte by = this.orbStream.read_octet();
                        map.put(valueMemberArray[n2].name, new Byte(by));
                        break;
                    }
                    case 8: {
                        boolean bl2 = this.orbStream.read_boolean();
                        map.put(valueMemberArray[n2].name, new Boolean(bl2));
                        break;
                    }
                    case 9: 
                    case 26: {
                        char c2 = this.orbStream.read_wchar();
                        map.put(valueMemberArray[n2].name, new Character(c2));
                        break;
                    }
                    case 2: {
                        short s2 = this.orbStream.read_short();
                        map.put(valueMemberArray[n2].name, new Short(s2));
                        break;
                    }
                    case 3: {
                        int n3 = this.orbStream.read_long();
                        map.put(valueMemberArray[n2].name, new Integer(n3));
                        break;
                    }
                    case 23: {
                        long l2 = this.orbStream.read_longlong();
                        map.put(valueMemberArray[n2].name, new Long(l2));
                        break;
                    }
                    case 6: {
                        float f2 = this.orbStream.read_float();
                        map.put(valueMemberArray[n2].name, new Float(f2));
                        break;
                    }
                    case 7: {
                        double d2 = this.orbStream.read_double();
                        map.put(valueMemberArray[n2].name, new Double(d2));
                        break;
                    }
                    case 14: 
                    case 29: 
                    case 30: {
                        Object object = null;
                        try {
                            object = this.inputObjectField(valueMemberArray[n2], this.cbSender);
                        }
                        catch (IndirectionException indirectionException) {
                            object = this.activeRecursionMgr.getObject(indirectionException.offset);
                        }
                        map.put(valueMemberArray[n2].name, object);
                        break;
                    }
                    default: {
                        throw new StreamCorruptedException("Unknown kind: " + valueMemberArray[n2].type.kind().value());
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            throw new StreamCorruptedException(throwable.getMessage());
        }
    }

    void readFields(Map map) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (this.mustUseRemoteValueMembers()) {
            this.inputRemoteMembersForReadFields(map);
        } else {
            this.inputCurrentClassFieldsForReadFields(map);
        }
    }

    public final ValueHandler getValueHandler() {
        return this.vhandler;
    }

    public final void setValueHandler(ValueHandler valueHandler) {
        this.vhandler = (ValueHandlerImpl)valueHandler;
    }

    public final InputStream getOrbStream() {
        return this.orbStream;
    }

    public final void setOrbStream(InputStream inputStream) {
        this.orbStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void simpleSkipObject(String string, CodeBase codeBase) {
        Object object = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        ++this.simpleReadDepth;
        Object var5_5 = null;
        try {
            try {
                this.skipObjectUsingFVD(string, codeBase);
            }
            catch (ClassNotFoundException classNotFoundException) {
                IIOPInputStream.throwExceptionType(class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = IIOPInputStream.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException, classNotFoundException.getMessage());
                Object var9_7 = null;
                --this.simpleReadDepth;
                this.currentObject = object;
                this.currentClassDesc = objectStreamClass;
                return;
            }
            catch (IOException iOException) {
                IIOPInputStream.throwExceptionType(class$java$io$IOException == null ? (class$java$io$IOException = IIOPInputStream.class$("java.io.IOException")) : class$java$io$IOException, iOException.getMessage());
                Object var9_8 = null;
                --this.simpleReadDepth;
                this.currentObject = object;
                this.currentClassDesc = objectStreamClass;
                return;
            }
            Object var9_6 = null;
            --this.simpleReadDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            --this.simpleReadDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
            throw throwable;
        }
        IOException iOException = this.abortIOException;
        if (this.simpleReadDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            IIOPInputStream.throwExceptionType(class$java$io$IOException == null ? (class$java$io$IOException = IIOPInputStream.class$("java.io.IOException")) : class$java$io$IOException, iOException.getMessage());
            return;
        }
        ClassNotFoundException classNotFoundException = this.abortClassNotFoundException;
        if (this.simpleReadDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (classNotFoundException != null) {
            IIOPInputStream.throwExceptionType(class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = IIOPInputStream.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException, classNotFoundException.getMessage());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void throwAwayData(ValueMember[] var1_1, CodeBase var2_2) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        var3_3 = 0;
        while (var3_3 < var1_1.length) {
            try {
                switch (var1_1[var3_3].type.kind().value()) {
                    case 10: {
                        this.orbStream.read_octet();
                        break;
                    }
                    case 8: {
                        this.orbStream.read_boolean();
                        break;
                    }
                    case 9: 
                    case 26: {
                        this.orbStream.read_wchar();
                        break;
                    }
                    case 2: {
                        this.orbStream.read_short();
                        break;
                    }
                    case 3: {
                        this.orbStream.read_long();
                        break;
                    }
                    case 23: {
                        this.orbStream.read_longlong();
                        break;
                    }
                    case 6: {
                        this.orbStream.read_float();
                        break;
                    }
                    case 7: {
                        this.orbStream.read_double();
                        break;
                    }
                    case 14: 
                    case 29: 
                    case 30: {
                        var4_4 = null;
                        var5_6 = var1_1[var3_3].id;
                        try {
                            var4_4 = this.vhandler.getClassFromType(var5_6);
                        }
                        catch (ClassNotFoundException var6_8) {
                            var4_4 = null;
                        }
                        var6_7 = null;
                        if (var4_4 != null) {
                            var6_7 = ValueUtility.getSignature(var1_1[var3_3]);
                        }
                        try {
                            if (var6_7 != null && (var6_7.equals("Ljava/lang/Object;") || var6_7.equals("Ljava/io/Serializable;") || var6_7.equals("Ljava/io/Externalizable;"))) {
                                Util.readAny(this.orbStream);
                                ** break;
                            }
                            var7_9 = 2;
                            if (!this.vhandler.isSequence(var5_6)) {
                                var8_11 = var2_2.meta(var1_1[var3_3].id);
                                if (IIOPInputStream.kRemoteTypeCode == var1_1[var3_3].type) {
                                    var7_9 = 0;
                                } else if (var8_11.is_abstract) {
                                    var7_9 = 1;
                                }
                            }
                            switch (var7_9) {
                                case 0: {
                                    this.orbStream.read_Object();
                                    ** break;
                                }
                                case 1: {
                                    this.orbStream.read_abstract_interface();
                                    ** break;
                                }
                                case 2: {
                                    if (var4_4 != null) {
                                        this.orbStream.read_value(var4_4);
                                        ** break;
                                    }
                                    this.orbStream.read_value();
                                    ** break;
                                }
                            }
                            throw new StreamCorruptedException("Unknown callType: " + var7_9);
lbl79:
                            // 5 sources

                            break;
                        }
                        catch (IndirectionException var7_10) {
                            break;
                        }
                    }
                    default: {
                        throw new StreamCorruptedException("Unknown kind: " + var1_1[var3_3].type.kind().value());
                    }
                }
            }
            catch (IllegalArgumentException var4_5) {
                throw new ClassCastException("Assigning instance of class " + var1_1[var3_3].id + " to field " + this.currentClassDesc.getName() + '#' + var1_1[var3_3].name);
            }
            ++var3_3;
        }
    }

    protected final Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        throw new IOException("Method resolveClass not supported");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private int findNextClass(String string, Class[] classArray, int n2, int n3) {
        int n4 = n2;
        while (n4 > n3) {
            if (string.equals(classArray[n4].getName())) {
                return n4;
            }
            --n4;
        }
        return -1;
    }

    private Object inputObjectField(ObjectStreamField objectStreamField) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IndirectionException, IOException {
        if (ObjectStreamClassCorbaExt.isAny(objectStreamField.getTypeString())) {
            return Util.readAny(this.orbStream);
        }
        Object object = null;
        Class clazz = objectStreamField.getType();
        int n2 = 2;
        boolean bl2 = false;
        if (clazz.isInterface()) {
            boolean bl3 = false;
            if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = IIOPInputStream.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
                n2 = 0;
            } else if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = IIOPInputStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz)) {
                n2 = 0;
                bl3 = true;
            } else if (this.vhandler.isAbstractBase(clazz)) {
                n2 = 1;
                bl3 = true;
            } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                n2 = 1;
            }
            if (bl3) {
                try {
                    String string = Util.getCodebase(clazz);
                    String string2 = this.vhandler.createForAnyType(clazz);
                    clazz = Utility.loadStubClass(string2, string, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        }
        switch (n2) {
            case 0: {
                if (!bl2) {
                    object = this.orbStream.read_Object(clazz);
                    break;
                }
                object = Utility.readObjectAndNarrow(this.orbStream, clazz);
                break;
            }
            case 1: {
                if (!bl2) {
                    object = this.orbStream.read_abstract_interface(clazz);
                    break;
                }
                object = Utility.readAbstractAndNarrow(this.orbStream, clazz);
                break;
            }
            case 2: {
                object = this.orbStream.read_value(clazz);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown callType: " + n2);
            }
        }
        return object;
    }

    protected final Object resolveObject(Object object) throws IOException {
        throw new IOException("Method resolveObject not supported");
    }

    private static native void setObjectFieldOpt(Object var0, long var1, Object var3);

    private static native void throwExceptionType(Class var0, String var1);

    protected String internalReadUTF(org.omg.CORBA.portable.InputStream inputStream) {
        return inputStream.read_wstring();
    }

    private void inputPrimitiveField(Object object, Class clazz, ObjectStreamField objectStreamField) throws InvalidClassException, IOException {
        try {
            switch (objectStreamField.getTypeCode()) {
                case 'B': {
                    byte by = this.orbStream.read_octet();
                    IIOPInputStream.setByteFieldOpt(object, objectStreamField.getFieldID(clazz), by);
                    break;
                }
                case 'Z': {
                    boolean bl2 = this.orbStream.read_boolean();
                    IIOPInputStream.setBooleanFieldOpt(object, objectStreamField.getFieldID(clazz), bl2);
                    break;
                }
                case 'C': {
                    char c2 = this.orbStream.read_wchar();
                    IIOPInputStream.setCharFieldOpt(object, objectStreamField.getFieldID(clazz), c2);
                    break;
                }
                case 'S': {
                    short s2 = this.orbStream.read_short();
                    IIOPInputStream.setShortFieldOpt(object, objectStreamField.getFieldID(clazz), s2);
                    break;
                }
                case 'I': {
                    int n2 = this.orbStream.read_long();
                    IIOPInputStream.setIntFieldOpt(object, objectStreamField.getFieldID(clazz), n2);
                    break;
                }
                case 'J': {
                    long l2 = this.orbStream.read_longlong();
                    IIOPInputStream.setLongFieldOpt(object, objectStreamField.getFieldID(clazz), l2);
                    break;
                }
                case 'F': {
                    float f2 = this.orbStream.read_float();
                    IIOPInputStream.setFloatFieldOpt(object, objectStreamField.getFieldID(clazz), f2);
                    break;
                }
                case 'D': {
                    double d2 = this.orbStream.read_double();
                    IIOPInputStream.setDoubleFieldOpt(object, objectStreamField.getFieldID(clazz), d2);
                    break;
                }
                default: {
                    throw new InvalidClassException(clazz.getName());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassCastException("Assigning instance of class " + objectStreamField.getType().getName() + " to field " + this.currentClassDesc.getName() + '#' + objectStreamField.getField().getName());
        }
    }

    private boolean invokeObjectReader(ObjectStreamClass objectStreamClass, Object object, Class clazz) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (objectStreamClass.readObjectMethod == null) {
            return false;
        }
        try {
            IIOPInputStream.readObject(object, clazz, this);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("interal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    private Object skipObjectUsingFVD(String string, CodeBase codeBase) throws IOException, ClassNotFoundException {
        Enumeration enumeration = this.getOrderedDescriptions(string, codeBase).elements();
        while (enumeration.hasMoreElements()) {
            FullValueDescription fullValueDescription = (FullValueDescription)enumeration.nextElement();
            String string2 = this.vhandler.getClassName(fullValueDescription.id);
            if (string2.equals("java.lang.Object")) continue;
            if (fullValueDescription.is_custom) {
                throw new IOException("Can't skip sender's custom marshaled class: " + fullValueDescription.id);
            }
            this.inputClassFields(null, null, null, fullValueDescription.members, codeBase);
        }
        return null;
    }

    private Object inputObjectField(ValueMember valueMember, CodeBase codeBase) throws IndirectionException, ClassNotFoundException, IOException, StreamCorruptedException {
        Object object = null;
        Class clazz = null;
        String string = valueMember.id;
        try {
            clazz = this.vhandler.getClassFromType(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        String string2 = null;
        if (clazz != null) {
            string2 = ValueUtility.getSignature(valueMember);
        }
        if (string2 != null && (string2.equals("Ljava/lang/Object;") || string2.equals("Ljava/io/Serializable;") || string2.equals("Ljava/io/Externalizable;"))) {
            object = Util.readAny(this.orbStream);
        } else {
            int n2 = 2;
            if (!this.vhandler.isSequence(string)) {
                if (valueMember.type.kind().value() == kRemoteTypeCode.kind().value()) {
                    n2 = 0;
                } else if (clazz != null && clazz.isInterface() && (this.vhandler.isAbstractBase(clazz) || ObjectStreamClassCorbaExt.isAbstractInterface(clazz))) {
                    n2 = 1;
                }
            }
            switch (n2) {
                case 0: {
                    if (clazz != null) {
                        object = Utility.readObjectAndNarrow(this.orbStream, clazz);
                        break;
                    }
                    object = this.orbStream.read_Object();
                    break;
                }
                case 1: {
                    if (clazz != null) {
                        object = Utility.readAbstractAndNarrow(this.orbStream, clazz);
                        break;
                    }
                    object = this.orbStream.read_abstract_interface();
                    break;
                }
                case 2: {
                    if (clazz != null) {
                        object = this.orbStream.read_value(clazz);
                        break;
                    }
                    object = this.orbStream.read_value();
                    break;
                }
                default: {
                    throw new StreamCorruptedException("Unknown callType: " + n2);
                }
            }
        }
        return object;
    }

    private static native Object allocateNewObject(Class var0, Class var1) throws InstantiationException, IllegalAccessException;

    private static native void readObject(Object var0, Class var1, Object var2) throws InvocationTargetException, IllegalAccessException;

    private Vector getOrderedDescriptions(String string, CodeBase codeBase) {
        Vector vector = new Vector();
        FullValueDescription fullValueDescription = codeBase.meta(string);
        while (fullValueDescription != null) {
            vector.insertElementAt(fullValueDescription, 0);
            if (fullValueDescription.base_value != null && !kEmptyStr.equals(fullValueDescription.base_value)) {
                fullValueDescription = codeBase.meta(fullValueDescription.base_value);
                continue;
            }
            return vector;
        }
        return vector;
    }

    private void inputClassFields(Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray, CodeBase codeBase) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        int n2;
        int n3 = objectStreamFieldArray.length - this.currentClassDesc.objFields;
        if (object != null) {
            n2 = 0;
            while (n2 < n3) {
                if (objectStreamFieldArray[n2].getField() != null) {
                    this.inputPrimitiveField(object, clazz, objectStreamFieldArray[n2]);
                }
                ++n2;
            }
        }
        if (this.currentClassDesc.objFields > 0) {
            n2 = n3;
            while (n2 < objectStreamFieldArray.length) {
                Object object2 = null;
                try {
                    object2 = this.inputObjectField(objectStreamFieldArray[n2]);
                }
                catch (IndirectionException indirectionException) {
                    object2 = this.activeRecursionMgr.getObject(indirectionException.offset);
                }
                if (object != null && objectStreamFieldArray[n2].getField() != null) {
                    try {
                        IIOPInputStream.setObjectFieldOpt(object, objectStreamFieldArray[n2].getFieldID(clazz), object2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ClassCastException("Assigning instance of class " + object2.getClass().getName() + " to field " + this.currentClassDesc.getName() + '#' + objectStreamFieldArray[n2].getField().getName());
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object inputObject(Class var1_1, String var2_2, CodeBase var3_3, int var4_4) throws IOException, ClassNotFoundException {
        this.currentClassDesc = ObjectStreamClass.lookup(var1_1);
        this.currentClass = this.currentClassDesc.forClass();
        if (this.currentClass == null) {
            throw new ClassNotFoundException(this.currentClassDesc.getName());
        }
        try {
            if (this.currentClassDesc.isExternalizable()) {
                try {
                    v0 = this.currentObject = this.currentClass == null ? null : IIOPInputStream.allocateNewObject(this.currentClass, this.currentClass);
                    if (this.currentObject == null) ** GOTO lbl89
                    this.activeRecursionMgr.addObject(var4_4, this.currentObject);
                    this.readByte();
                    var5_5 = (Externalizable)this.currentObject;
                    var5_5.readExternal(this);
                }
                catch (NoSuchMethodError var5_6) {
                    throw new InvalidClassException(this.currentClass.getName(), "NoSuchMethodError accessing no-arg constructor");
                }
                catch (IllegalAccessException var6_8) {
                    throw new InvalidClassException(this.currentClass.getName(), "IllegalAccessException");
                }
                catch (InstantiationException var7_10) {
                    throw new InvalidClassException(this.currentClass.getName(), "InstantiationException");
                }
            } else {
                var5_7 = this.currentClassDesc;
                var6_9 = this.currentClass;
                var7_11 = this.spClass;
                var5_7 = this.currentClassDesc;
                var6_9 = this.currentClass;
                while (var5_7 != null && var5_7.isSerializable()) {
                    var8_12 = var5_7.forClass();
                    var9_14 = var6_9;
                    while (var9_14 != null) {
                        if (var8_12 == var9_14) break;
                        var9_14 = var9_14.getSuperclass();
                    }
                    ++this.spClass;
                    if (this.spClass >= this.classes.length) {
                        var10_16 = this.classes.length * 2;
                        var11_18 = new Class[var10_16];
                        var12_19 = new ObjectStreamClass[var10_16];
                        System.arraycopy(this.classes, 0, var11_18, 0, this.classes.length);
                        System.arraycopy(this.classdesc, 0, var12_19, 0, this.classes.length);
                        this.classes = var11_18;
                        this.classdesc = var12_19;
                    }
                    if (var9_14 == null) {
                        this.classdesc[this.spClass] = var5_7;
                        this.classes[this.spClass] = null;
                    } else {
                        this.classdesc[this.spClass] = var5_7;
                        this.classes[this.spClass] = var9_14;
                        var6_9 = var9_14.getSuperclass();
                    }
                    var5_7 = var5_7.getSuperclass();
                }
                try {
                    this.currentObject = this.currentClass == null ? null : IIOPInputStream.allocateNewObject(this.currentClass, var6_9);
                    this.activeRecursionMgr.addObject(var4_4, this.currentObject);
                }
                catch (NoSuchMethodError var8_13) {
                    throw new InvalidClassException(var6_9.getName(), "NoSuchMethodError accessing no-arg constructor");
                }
                catch (IllegalAccessException var9_15) {
                    throw new InvalidClassException(var6_9.getName(), "IllegalAccessException");
                }
                catch (InstantiationException var10_17) {
                    throw new InvalidClassException("UNKNOWN", "InstantiationException");
                }
                try {
                    this.spClass = this.spClass;
                    while (this.spClass > var7_11) {
                        this.currentClassDesc = this.classdesc[this.spClass];
                        this.currentClass = this.classes[this.spClass];
                        if (this.classes[this.spClass] != null) {
                            if (this.currentClassDesc.hasWriteObject()) {
                                this.readByte();
                                this.readBoolean();
                            }
                            if (!this.invokeObjectReader(this.currentClassDesc, this.currentObject, this.currentClass) && (var8_12 = this.currentClassDesc.getFieldsNoCopy()).length > 0) {
                                this.inputClassFields(this.currentObject, this.currentClass, var8_12, var3_3);
                            }
                        } else {
                            var8_12 = this.currentClassDesc.getFieldsNoCopy();
                            if (var8_12.length > 0) {
                                this.inputClassFields(null, this.currentClass, var8_12, var3_3);
                            }
                        }
                        --this.spClass;
                    }
                    var14_20 = null;
                    this.spClass = var7_11;
                }
                catch (Throwable var13_22) {
                    var14_21 = null;
                    this.spClass = var7_11;
                    throw var13_22;
                }
            }
lbl89:
            // 3 sources

            var16_23 = null;
            this.activeRecursionMgr.removeObject(var4_4);
        }
        catch (Throwable var15_25) {
            var16_24 = null;
            this.activeRecursionMgr.removeObject(var4_4);
            throw var15_25;
        }
        return this.currentObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object inputObjectUsingFVD(Class var1_1, String var2_2, CodeBase var3_3, int var4_4) throws IOException, ClassNotFoundException {
        var5_5 = this.spClass;
        try {
            var6_6 = this.currentClassDesc = ObjectStreamClass.lookup(var1_1);
            var7_7 = this.currentClass = var1_1;
            if (this.currentClassDesc.isExternalizable()) {
                try {
                    v0 = this.currentObject = this.currentClass == null ? null : IIOPInputStream.allocateNewObject(this.currentClass, this.currentClass);
                    if (this.currentObject == null) ** GOTO lbl124
                    this.activeRecursionMgr.addObject(var4_4, this.currentObject);
                    this.readByte();
                    var8_8 = (Externalizable)this.currentObject;
                    var8_8.readExternal(this);
                }
                catch (NoSuchMethodError var8_9) {
                    throw new InvalidClassException(this.currentClass.getName(), "NoSuchMethodError accessing no-arg constructor");
                }
                catch (IllegalAccessException var9_11) {
                    throw new InvalidClassException(this.currentClass.getName(), "IllegalAccessException");
                }
                catch (InstantiationException var10_14) {
                    throw new InvalidClassException(this.currentClass.getName(), "InstantiationException");
                }
            } else {
                var6_6 = this.currentClassDesc;
                var7_7 = this.currentClass;
                while (true) {
                    if (var6_6 == null || !var6_6.isSerializable()) {
                        try {
                            this.currentObject = this.currentClass == null ? null : IIOPInputStream.allocateNewObject(this.currentClass, var7_7);
                            this.activeRecursionMgr.addObject(var4_4, this.currentObject);
                            break;
                        }
                        catch (NoSuchMethodError var8_10) {
                            throw new InvalidClassException(var7_7.getName(), "NoSuchMethodError accessing no-arg constructor");
                        }
                        catch (IllegalAccessException var9_13) {
                            throw new InvalidClassException(var7_7.getName(), "IllegalAccessException");
                        }
                        catch (InstantiationException var10_16) {
                            throw new InvalidClassException(var7_7.getName(), "InstantiationException");
                        }
                    }
                    var8_8 = var6_6.forClass();
                    var9_12 = var7_7;
                    while (var9_12 != null && var8_8 != var9_12) {
                        var9_12 = var9_12.getSuperclass();
                    }
                    ++this.spClass;
                    if (this.spClass >= this.classes.length) {
                        var10_15 = this.classes.length * 2;
                        var11_19 = new Class[var10_15];
                        var12_20 = new ObjectStreamClass[var10_15];
                        System.arraycopy(this.classes, 0, var11_19, 0, this.classes.length);
                        System.arraycopy(this.classdesc, 0, var12_20, 0, this.classes.length);
                        this.classes = var11_19;
                        this.classdesc = var12_20;
                    }
                    if (var9_12 == null) {
                        this.classdesc[this.spClass] = var6_6;
                        this.classes[this.spClass] = null;
                    } else {
                        this.classdesc[this.spClass] = var6_6;
                        this.classes[this.spClass] = var9_12;
                        var7_7 = var9_12.getSuperclass();
                    }
                    var6_6 = var6_6.getSuperclass();
                }
                var8_8 = this.getOrderedDescriptions(var2_2, var3_3).elements();
                while (var8_8.hasMoreElements() && this.spClass > var5_5) {
                    block33: {
                        var9_12 = (FullValueDescription)var8_8.nextElement();
                        var10_18 = this.vhandler.getClassName(var9_12.id);
                        var11_19 = this.vhandler.getClassName(this.vhandler.getRMIRepositoryID(this.currentClass));
                        while (true) {
                            if (this.spClass <= var5_5 || var10_18.equals(var11_19)) {
                                var6_6 = this.currentClassDesc = ObjectStreamClass.lookup(this.currentClass);
                                if (!var11_19.equals("java.lang.Object")) {
                                    if (var9_12.is_custom) {
                                        this.readByte();
                                        this.readBoolean();
                                    }
                                    var12_22 = false;
                                    try {
                                        this.defaultReadObjectFVDMembers = var9_12.members;
                                        var12_22 = this.invokeObjectReader(this.currentClassDesc, this.currentObject, this.currentClass);
                                        var15_23 = null;
                                        this.defaultReadObjectFVDMembers = null;
                                        break;
                                    }
                                    catch (Throwable var14_28) {
                                        var15_23 = null;
                                        this.defaultReadObjectFVDMembers = null;
                                        throw var14_28;
                                    }
                                }
                                break block33;
                            }
                            var12_21 = this.findNextClass(var10_18, this.classes, this.spClass, var5_5);
                            if (var12_21 != -1) {
                                this.spClass = var12_21;
                                var7_7 = this.currentClass = this.classes[this.spClass];
                                var11_19 = this.vhandler.getClassName(this.vhandler.getRMIRepositoryID(this.currentClass));
                                continue;
                            }
                            if (var9_12.is_custom) {
                                throw new IOException("Remote superclass is custom marshalled: " + var9_12.id);
                            }
                            this.inputClassFields(null, this.currentClass, null, var9_12.members, var3_3);
                            if (!var8_8.hasMoreElements()) {
                                var13_24 = this.currentObject;
                                var17_25 = null;
                                this.spClass = var5_5;
                                this.activeRecursionMgr.removeObject(var4_4);
                                return var13_24;
                            }
                            var9_12 = (FullValueDescription)var8_8.nextElement();
                            var10_18 = this.vhandler.getClassName(var9_12.id);
                        }
                        if (!var12_22) {
                            this.inputClassFields(this.currentObject, this.currentClass, var6_6, var9_12.members, var3_3);
                        }
                        var7_7 = this.currentClass = this.classes[--this.spClass];
                        continue;
                    }
                    this.inputClassFields(null, this.currentClass, null, var9_12.members, var3_3);
                    while (var8_8.hasMoreElements()) {
                        var9_12 = (FullValueDescription)var8_8.nextElement();
                        if (var9_12.is_custom) {
                            throw new IOException("Sender's custom marshaling class does not match local class: " + var9_12.id);
                        }
                        this.inputClassFields(null, this.currentClass, null, var9_12.members, var3_3);
                    }
                }
                while (var8_8.hasMoreElements()) {
                    var9_12 = (FullValueDescription)var8_8.nextElement();
                    if (var9_12.is_custom) {
                        throw new IOException("Sender's custom marshaling class does not match local class: " + var9_12.id);
                    }
                    this.throwAwayData(var9_12.members, var3_3);
                }
            }
lbl124:
            // 3 sources

            var8_8 = this.currentObject;
            var17_26 = null;
            this.spClass = var5_5;
            this.activeRecursionMgr.removeObject(var4_4);
            return var8_8;
        }
        catch (Throwable var16_29) {
            var17_27 = null;
            this.spClass = var5_5;
            this.activeRecursionMgr.removeObject(var4_4);
            throw var16_29;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object simpleReadObject(Class clazz, String string, CodeBase codeBase, int n2) {
        Object object = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        ++this.simpleReadDepth;
        Object object2 = null;
        try {
            object2 = this.vhandler.useFullValueDescription(clazz, string) ? this.inputObjectUsingFVD(clazz, string, codeBase, n2) : this.inputObject(clazz, string, codeBase, n2);
            object2 = this.currentClassDesc.readResolve(object2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            IIOPInputStream.throwExceptionType(class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = IIOPInputStream.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException, classNotFoundException.getMessage());
            Object var9_14 = null;
            Object var12_9 = null;
            --this.simpleReadDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
            return var9_14;
        }
        catch (IOException iOException) {
            try {
                IIOPInputStream.throwExceptionType(class$java$io$IOException == null ? (class$java$io$IOException = IIOPInputStream.class$("java.io.IOException")) : class$java$io$IOException, iOException.getMessage());
                Object var10_17 = null;
                Object var12_10 = null;
                --this.simpleReadDepth;
                this.currentObject = object;
                this.currentClassDesc = objectStreamClass;
                return var10_17;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                --this.simpleReadDepth;
                this.currentObject = object;
                this.currentClassDesc = objectStreamClass;
                throw throwable;
            }
        }
        Object var12_8 = null;
        --this.simpleReadDepth;
        this.currentObject = object;
        this.currentClassDesc = objectStreamClass;
        IOException iOException = this.abortIOException;
        if (this.simpleReadDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            IIOPInputStream.throwExceptionType(class$java$io$IOException == null ? (class$java$io$IOException = IIOPInputStream.class$("java.io.IOException")) : class$java$io$IOException, iOException.getMessage());
            return null;
        }
        ClassNotFoundException classNotFoundException = this.abortClassNotFoundException;
        if (this.simpleReadDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (classNotFoundException != null) {
            IIOPInputStream.throwExceptionType(class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = IIOPInputStream.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException, classNotFoundException.getMessage());
            return null;
        }
        return object2;
    }

    private static native void setByteField(Object var0, Class var1, String var2, String var3, byte var4);

    private static native void setCharField(Object var0, Class var1, String var2, String var3, char var4);

    private static native void setDoubleField(Object var0, Class var1, String var2, String var3, double var4);

    private static native void setFloatField(Object var0, Class var1, String var2, String var3, float var4);

    private static native void setIntField(Object var0, Class var1, String var2, String var3, int var4);

    private static native void setLongField(Object var0, Class var1, String var2, String var3, long var4);

    private static native void setShortField(Object var0, Class var1, String var2, String var3, short var4);

    private static native void setBooleanField(Object var0, Class var1, String var2, String var3, boolean var4);

    private void inputClassFields(Object object, Class clazz, ObjectStreamClass objectStreamClass, ValueMember[] valueMemberArray, CodeBase codeBase) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        try {
            int n2 = 0;
            while (n2 < valueMemberArray.length) {
                try {
                    switch (valueMemberArray[n2].type.kind().value()) {
                        case 10: {
                            byte by = this.orbStream.read_octet();
                            if (object != null && objectStreamClass.hasField(valueMemberArray[n2])) {
                                IIOPInputStream.setByteField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), by);
                            }
                            break;
                        }
                        case 8: {
                            boolean bl2 = this.orbStream.read_boolean();
                            if (object != null && objectStreamClass.hasField(valueMemberArray[n2])) {
                                IIOPInputStream.setBooleanField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), bl2);
                            }
                            break;
                        }
                        case 9: 
                        case 26: {
                            char c2 = this.orbStream.read_wchar();
                            if (object != null && objectStreamClass.hasField(valueMemberArray[n2])) {
                                IIOPInputStream.setCharField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), c2);
                            }
                            break;
                        }
                        case 2: {
                            short s2 = this.orbStream.read_short();
                            if (object != null && objectStreamClass.hasField(valueMemberArray[n2])) {
                                IIOPInputStream.setShortField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), s2);
                            }
                            break;
                        }
                        case 3: {
                            int n3 = this.orbStream.read_long();
                            if (object != null && objectStreamClass.hasField(valueMemberArray[n2])) {
                                IIOPInputStream.setIntField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), n3);
                            }
                            break;
                        }
                        case 23: {
                            long l2 = this.orbStream.read_longlong();
                            if (object != null && objectStreamClass.hasField(valueMemberArray[n2])) {
                                IIOPInputStream.setLongField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), l2);
                            }
                            break;
                        }
                        case 6: {
                            float f2 = this.orbStream.read_float();
                            if (object != null && objectStreamClass.hasField(valueMemberArray[n2])) {
                                IIOPInputStream.setFloatField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), f2);
                            }
                            break;
                        }
                        case 7: {
                            double d2 = this.orbStream.read_double();
                            if (object != null && objectStreamClass.hasField(valueMemberArray[n2])) {
                                IIOPInputStream.setDoubleField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), d2);
                            }
                            break;
                        }
                        case 14: 
                        case 29: 
                        case 30: {
                            Object object2 = null;
                            try {
                                object2 = this.inputObjectField(valueMemberArray[n2], codeBase);
                            }
                            catch (IndirectionException indirectionException) {
                                object2 = this.activeRecursionMgr.getObject(indirectionException.offset);
                            }
                            if (object == null) break;
                            try {
                                if (objectStreamClass.hasField(valueMemberArray[n2])) {
                                    IIOPInputStream.setObjectField(object, clazz, valueMemberArray[n2].name, ValueUtility.getSignature(valueMemberArray[n2]), object2);
                                }
                                break;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw new ClassCastException("Assigning instance of class " + object2.getClass().getName() + " to field " + valueMemberArray[n2].name);
                            }
                        }
                        default: {
                            throw new StreamCorruptedException("Unknown kind: " + valueMemberArray[n2].type.kind().value());
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ClassCastException("Assigning instance of class " + valueMemberArray[n2].id + " to field " + this.currentClassDesc.getName() + '#' + valueMemberArray[n2].name);
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            throw new StreamCorruptedException(throwable.getMessage());
        }
    }

    private static native void setObjectField(Object var0, Class var1, String var2, String var3, Object var4);

    static class ActiveRecursionManager {
        private Map offsetToObjectMap = new HashMap();

        public void removeObject(int n2) {
            this.offsetToObjectMap.remove(new Integer(n2));
        }

        public boolean containsObject(int n2) {
            return this.offsetToObjectMap.containsKey(new Integer(n2));
        }

        public Object getObject(int n2) throws IOException {
            Integer n3 = new Integer(n2);
            if (!this.offsetToObjectMap.containsKey(n3)) {
                throw new IOException("Invalid indirection to offset " + n2);
            }
            return this.offsetToObjectMap.get(n3);
        }

        public void addObject(int n2, Object object) {
            this.offsetToObjectMap.put(new Integer(n2), object);
        }
    }
}

