/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.Activation;

import com.sun.corba.se.ActivationIDL.Repository;
import com.sun.corba.se.ActivationIDL.RepositoryHelper;
import com.sun.corba.se.ActivationIDL.ServerNotRegistered;
import com.sun.corba.se.internal.Activation.CommandHandler;
import com.sun.corba.se.internal.Activation.GetServerID;
import com.sun.corba.se.internal.Activation.Help;
import com.sun.corba.se.internal.Activation.ListActiveServers;
import com.sun.corba.se.internal.Activation.ListAliases;
import com.sun.corba.se.internal.Activation.ListORBs;
import com.sun.corba.se.internal.Activation.ListServers;
import com.sun.corba.se.internal.Activation.LocateServer;
import com.sun.corba.se.internal.Activation.LocateServerForORB;
import com.sun.corba.se.internal.Activation.Quit;
import com.sun.corba.se.internal.Activation.RegisterServer;
import com.sun.corba.se.internal.Activation.ShutdownServer;
import com.sun.corba.se.internal.Activation.StartServer;
import com.sun.corba.se.internal.Activation.UnRegisterServer;
import com.sun.corba.se.internal.orbutil.CorbaResourceUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.ORB;

public class ServerTool {
    static final String helpCommand = "help";
    static final String toolName = "servertool";
    static final String commandArg = "-cmd";
    private static final boolean debug = false;
    ORB orb = null;
    static Vector handlers = new Vector();
    static int maxNameLen;

    static {
        handlers.addElement(new RegisterServer());
        handlers.addElement(new UnRegisterServer());
        handlers.addElement(new GetServerID());
        handlers.addElement(new ListServers());
        handlers.addElement(new ListAliases());
        handlers.addElement(new ListActiveServers());
        handlers.addElement(new LocateServer());
        handlers.addElement(new LocateServerForORB());
        handlers.addElement(new ListORBs());
        handlers.addElement(new ShutdownServer());
        handlers.addElement(new StartServer());
        handlers.addElement(new Help());
        handlers.addElement(new Quit());
        maxNameLen = 0;
        int n2 = 0;
        while (n2 < handlers.size()) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(n2);
            int n3 = commandHandler.getCommandName().length();
            if (n3 > maxNameLen) {
                maxNameLen = n3;
            }
            ++n2;
        }
    }

    void printAvailableCommands() {
        System.out.println(CorbaResourceUtil.getText("servertool.shorthelp"));
        int n2 = 0;
        while (n2 < handlers.size()) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(n2);
            System.out.print("\t" + commandHandler.getCommandName());
            int n3 = commandHandler.getCommandName().length();
            while (n3 < maxNameLen) {
                System.out.print(" ");
                ++n3;
            }
            System.out.print(" - ");
            commandHandler.printCommandHelp(System.out, true);
            ++n2;
        }
        System.out.println();
    }

    void executeCommand(String[] stringArray) {
        if (stringArray[0].equals(helpCommand)) {
            if (stringArray.length == 1) {
                this.printAvailableCommands();
            } else {
                int n2 = 0;
                while (n2 < handlers.size()) {
                    CommandHandler commandHandler = (CommandHandler)handlers.elementAt(n2);
                    if (commandHandler.getCommandName().equals(stringArray[1])) {
                        commandHandler.printCommandHelp(System.out, false);
                    }
                    ++n2;
                }
            }
            return;
        }
        int n3 = 0;
        while (n3 < handlers.size()) {
            CommandHandler commandHandler = (CommandHandler)handlers.elementAt(n3);
            if (commandHandler.getCommandName().equals(stringArray[0])) {
                String[] stringArray2 = new String[stringArray.length - 1];
                int n4 = 0;
                while (n4 < stringArray2.length) {
                    stringArray2[n4] = stringArray[n4 + 1];
                    ++n4;
                }
                try {
                    System.out.println();
                    boolean bl2 = commandHandler.processCommand(stringArray2, this.orb, System.out);
                    if (bl2) {
                        commandHandler.printCommandHelp(System.out, false);
                    }
                    System.out.println();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            ++n3;
        }
        this.printAvailableCommands();
    }

    public static void main(String[] stringArray) {
        ServerTool serverTool = new ServerTool();
        serverTool.run(stringArray);
    }

    void run(String[] stringArray) {
        block8: {
            String[] stringArray2 = null;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(commandArg)) {
                    int n3 = stringArray.length - n2 - 1;
                    stringArray2 = new String[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        stringArray2[n4] = stringArray[++n2];
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
            try {
                Properties properties = System.getProperties();
                properties.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.internal.iiop.ORB");
                this.orb = ORB.init(stringArray, properties);
                if (stringArray2 != null) {
                    this.executeCommand(stringArray2);
                    break block8;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.println(CorbaResourceUtil.getText("servertool.banner"));
                while (true) {
                    if ((stringArray2 = this.readCommand(bufferedReader)) != null) {
                        this.executeCommand(stringArray2);
                        continue;
                    }
                    this.printAvailableCommands();
                }
            }
            catch (Exception exception) {
                System.out.println(CorbaResourceUtil.getText("servertool.usage", toolName));
                System.out.println();
                exception.printStackTrace();
            }
        }
    }

    String[] readCommand(BufferedReader bufferedReader) {
        System.out.print("servertool > ");
        try {
            StringTokenizer stringTokenizer;
            int n2 = 0;
            String[] stringArray = null;
            String string = bufferedReader.readLine();
            if (string != null && (stringTokenizer = new StringTokenizer(string)).countTokens() != 0) {
                stringArray = new String[stringTokenizer.countTokens()];
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                }
            }
            return stringArray;
        }
        catch (Exception exception) {
            System.out.println(CorbaResourceUtil.getText("servertool.usage", toolName));
            System.out.println();
            exception.printStackTrace();
            return null;
        }
    }

    static int getServerIdForAlias(ORB oRB, String string) throws ServerNotRegistered {
        try {
            Repository repository = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            int n2 = repository.getServerID(string);
            return repository.getServerID(string);
        }
        catch (Exception exception) {
            throw new ServerNotRegistered();
        }
    }
}

