/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.HKSCS;
import sun.nio.cs.ext.MS950;

public class MS950_HKSCS
extends Charset {
    public MS950_HKSCS() {
        super("MS950-HKSCS", ExtendedCharsets.aliasesFor("MS950-HKSCS"));
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS950 || charset instanceof MS950_HKSCS;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this, null);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this, null);
    }

    class 1 {
    }

    private static class Decoder
    extends HKSCS.Decoder {
        private MS950.Decoder ms950Dec;

        protected char decodeDouble(int n, int n2) {
            char c = super.decodeDouble(n, n2);
            return c != '\ufffd' ? c : this.ms950Dec.decodeDouble(n, n2);
        }

        private Decoder(Charset charset) {
            super(charset);
            this.ms950Dec = new MS950.Decoder(charset);
        }

        Decoder(Charset charset, 1 var2_2) {
            this(charset);
        }
    }

    private static class Encoder
    extends HKSCS.Encoder {
        private MS950.Encoder ms950Enc;

        protected int encodeDouble(char c) {
            int n = super.encodeDouble(c);
            return n != 0 ? n : this.ms950Enc.encodeDouble(c);
        }

        public boolean canEncode(char c) {
            int n = super.encodeDouble(c);
            if (n == 0) {
                n = this.ms950Enc.encodeDouble(c);
            }
            return n != 0;
        }

        private Encoder(Charset charset) {
            super(charset);
            this.ms950Enc = new MS950.Encoder(charset);
        }

        Encoder(Charset charset, 1 var2_2) {
            this(charset);
        }
    }
}

