/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.EUC_KR;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022;

public class ISO2022_KR
extends ISO2022
implements HistoricallyNamedCharset {
    public ISO2022_KR() {
        super("ISO-2022-KR", ExtendedCharsets.aliasesFor("ISO-2022-KR"));
    }

    public String historicalName() {
        return "ISO2022KR";
    }

    public boolean contains(Charset charset) {
        return charset instanceof EUC_KR || charset.name().equals("US-ASCII") || charset instanceof ISO2022_KR;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends ISO2022.Decoder {
        public Decoder(Charset charset) {
            super(charset);
            this.SODesig = new String[1];
            this.SODesig[0] = "$)C";
            this.SODecoder = new CharsetDecoder[1];
            try {
                Charset charset2 = Charset.forName("EUC_KR");
                this.SODecoder[0] = charset2.newDecoder();
            }
            catch (Exception exception) {}
        }
    }

    private static class Encoder
    extends ISO2022.Encoder {
        private static Charset eucKR = Charset.forName("EUC_KR");
        private static CharsetEncoder KSC5601Enc = eucKR.newEncoder();

        public boolean canEncode(char c) {
            return KSC5601Enc.canEncode(c);
        }

        public Encoder(Charset charset) {
            super(charset);
            this.SODesig = "$)C";
            try {
                Charset charset2 = Charset.forName("EUC_KR");
                this.ISOEncoder = charset2.newEncoder();
            }
            catch (Exception exception) {}
        }
    }
}

