/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class DoubleByteDecoder
extends CharsetDecoder {
    private short[] index1;
    private String[] index2;
    protected int start;
    protected int end;
    protected static final char REPLACE_CHAR = '\ufffd';
    static final boolean $assertionsDisabled = !(class$sun$nio$cs$ext$DoubleByteDecoder == null ? (class$sun$nio$cs$ext$DoubleByteDecoder = DoubleByteDecoder.class$("sun.nio.cs.ext.DoubleByteDecoder")) : class$sun$nio$cs$ext$DoubleByteDecoder).desiredAssertionStatus();
    static Class class$sun$nio$cs$ext$DoubleByteDecoder;

    protected char decodeSingle(int n) {
        if (n >= 0) {
            return (char)n;
        }
        return '\ufffd';
    }

    protected char decodeDouble(int n, int n2) {
        if (n < 0 || n > this.index1.length || n2 < this.start || n2 > this.end) {
            return '\ufffd';
        }
        int n3 = (this.index1[n] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
        return this.index2[this.index1[n] >> 4].charAt(n3);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected DoubleByteDecoder(Charset charset, short[] sArray, String[] stringArray, int n, int n2) {
        super(charset, 0.5f, 1.0f);
        this.index1 = sArray;
        this.index2 = stringArray;
        this.start = n;
        this.end = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        n = n <= n2 ? n : n2;
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        if (!$assertionsDisabled && n3 > n4) {
            throw new AssertionError();
        }
        n3 = n3 <= n4 ? n3 : n4;
        try {
            while (n < n2) {
                int n5 = byArray[n];
                int n6 = 1;
                char c = this.decodeSingle(n5);
                if (c == '\ufffd') {
                    n5 &= 0xFF;
                    if (n2 - n < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n7 = byArray[n + 1] & 0xFF;
                    c = this.decodeDouble(n5, n7);
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    n6 = 2;
                }
                if (n4 - n3 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                cArray[n3++] = c;
                n += n6;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block8: {
            CoderResult coderResult2;
            block10: {
                CoderResult coderResult3;
                n = byteBuffer.position();
                int n2 = 0;
                try {
                    while (true) {
                        if (!byteBuffer.hasRemaining()) {
                            coderResult = CoderResult.UNDERFLOW;
                            break block8;
                        }
                        int n3 = byteBuffer.get();
                        n2 = 1;
                        char c = this.decodeSingle(n3);
                        if (c == '\ufffd') {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult4 = CoderResult.UNDERFLOW;
                                Object var11_11 = null;
                                byteBuffer.position(n);
                                return coderResult4;
                            }
                            int n4 = byteBuffer.get() & 0xFF;
                            n2 = 2;
                            c = this.decodeDouble(n3 &= 0xFF, n4);
                            if (c == '\ufffd') {
                                coderResult3 = CoderResult.unmappableForLength(2);
                                break;
                            }
                        }
                        if (!charBuffer.hasRemaining()) {
                            coderResult2 = CoderResult.OVERFLOW;
                            break block10;
                        }
                        n += n2;
                        charBuffer.put(c);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    byteBuffer.position(n);
                    throw throwable;
                }
                Object var11_12 = null;
                byteBuffer.position(n);
                return coderResult3;
            }
            Object var11_13 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var11_14 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

