/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.SunJSSE_bg;
import COM.rsa.jsafe.SunJSSE_bh;
import COM.rsa.jsafe.SunJSSE_bi;
import COM.rsa.jsafe.SunJSSE_dm;
import COM.rsa.jsafe.SunJSSE_n;
import COM.rsa.jsafe.SunJSSE_w;
import com.sun.net.ssl.internal.ssl.JS_PrivateKey;
import com.sun.net.ssl.internal.ssl.JS_PublicKey;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class JS_Signature
extends SignatureSpi
implements Cloneable,
Serializable {
    protected SunJSSE_bh jsafeSignature;
    protected SunJSSE_dm jsafeParams;
    protected int[] signatureParams;
    private String a;
    private boolean b;

    void a() {
        if (this.jsafeSignature != null) {
            this.jsafeSignature.a();
        }
        this.jsafeSignature = null;
    }

    protected void finalize() {
        this.a();
    }

    protected boolean needSignRandom() {
        return false;
    }

    protected boolean needVerifyRandom() {
        return false;
    }

    protected byte[] engineSign() throws SignatureException {
        if (!this.b) {
            throw new SignatureException("Object initialized for verify.");
        }
        try {
            byte[] byArray = this.jsafeSignature.j();
            this.jsafeSignature.k();
            return byArray;
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new SignatureException(sunJSSE_n.getMessage());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        try {
            byte[] byArray = new byte[]{by};
            if (this.b) {
                this.jsafeSignature.a(byArray, 0, 1);
            } else {
                this.jsafeSignature.c(byArray, 0, 1);
            }
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new SignatureException(sunJSSE_n.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.b) {
            throw new SignatureException("Object initialized for signing.");
        }
        try {
            boolean bl = this.jsafeSignature.b(byArray, 0, byArray.length);
            this.jsafeSignature.l();
            return bl;
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new SignatureException(sunJSSE_n.getMessage());
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            if (this.b) {
                this.jsafeSignature.a(byArray, n, n2);
            } else {
                this.jsafeSignature.c(byArray, n, n2);
            }
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new SignatureException(sunJSSE_n.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Class<?> clazz = Class.forName(this.getSubclassName());
            JS_Signature jS_Signature = (JS_Signature)clazz.newInstance();
            return jS_Signature;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CloneNotSupportedException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException();
        }
        catch (InstantiationException instantiationException) {
            throw new CloneNotSupportedException();
        }
    }

    protected String getSubclassName() {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.b = true;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.a, "SunJSSE");
            JS_PrivateKey jS_PrivateKey = (JS_PrivateKey)keyFactory.translateKey(privateKey);
            SunJSSE_bi sunJSSE_bi = jS_PrivateKey.a();
            SecureRandom secureRandom = null;
            if (this.needSignRandom()) {
                if (this.appRandom != null) {
                    secureRandom = this.appRandom;
                } else {
                    try {
                        SecureRandom secureRandom2;
                        secureRandom = secureRandom2 = SunJSSE_w.getInstance("SHA1Random", "Java");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
                    }
                }
            }
            this.jsafeSignature.a(sunJSSE_bi, this.jsafeParams, secureRandom);
            sunJSSE_bi.a();
            jS_PrivateKey.b();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("Could not initialize for signing with the given key.");
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new InvalidKeyException(sunJSSE_n.getMessage());
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.b = false;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.a, "SunJSSE");
            JS_PublicKey jS_PublicKey = (JS_PublicKey)keyFactory.translateKey(publicKey);
            SunJSSE_bg sunJSSE_bg = jS_PublicKey.a();
            SecureRandom secureRandom = null;
            if (this.needVerifyRandom()) {
                if (this.appRandom != null) {
                    secureRandom = this.appRandom;
                } else {
                    try {
                        SecureRandom secureRandom2 = SunJSSE_w.getInstance("SHA1Random", "Java");
                        secureRandom = this.appRandom;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
                    }
                }
            }
            this.jsafeSignature.a(sunJSSE_bg, this.jsafeParams, secureRandom);
            sunJSSE_bg.a();
            jS_PublicKey.b();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("Could not initialize for verifying with the given key.");
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new InvalidKeyException(sunJSSE_n.getMessage());
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        SunJSSE_dm sunJSSE_dm = this.getSystemParameters(algorithmParameterSpec);
    }

    protected abstract int[] getSignatureParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected abstract SunJSSE_dm getSystemParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("JSAFE provider does not support deprecated methods.");
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("JSAFE provider does not support deprecated methods.");
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (secureRandom != null) {
            this.appRandom = secureRandom;
        }
        this.engineInitSign(privateKey);
    }

    public JS_Signature(String string, String string2, String string3) throws NoSuchAlgorithmException {
        try {
            this.jsafeSignature = SunJSSE_bh.a(string, "Java");
        }
        catch (SunJSSE_n sunJSSE_n) {
            throw new NoSuchAlgorithmException("JSAFE provider does not perform " + string);
        }
        this.a = string3;
    }
}

